(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7347,        254]
NotebookOptionsPosition[      5541,        197]
NotebookOutlinePosition[      6647,        227]
CellTagsIndexPosition[      6604,        224]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MolarVolume" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/MolarVolume"], "MolarGasConstant" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/MolarGasConstant"], 
          "BoltzmannConstant" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/BoltzmannConstant"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MolarVolume\"\>", 
       2->"\<\"MolarGasConstant\"\>", 
       3->"\<\"BoltzmannConstant\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AvogadroConstant", "ObjectName",
 CellID->15543],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["AvogadroConstant"], "InlineFormula"],
     " \[LineSeparator]is the number of molecules in one mole or gram \
molecular weight of a substance."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20848]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["AvogadroConstant"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mole",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Mole"], "^", 
   RowBox[{"-", "1"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->30226],

Cell[TextData[{
 "Avogadro\[CloseCurlyQuote]s constant is approximately ",
 Cell[BoxData[
  RowBox[{"6.02214199", "\[Times]", 
   SuperscriptBox["10", "23"]}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mole",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Mole"], "^", 
   RowBox[{"-", "1"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->16760]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14668],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MolarVolume",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/MolarVolume"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MolarGasConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/MolarGasConstant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoltzmannConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/BoltzmannConstant"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3526]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20057],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->18863]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AvogadroConstant - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 59.0006164}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "AvogadroConstant is the number of molecules in one mole or gram \
molecular weight of a substance.", "synonyms" -> {}, "title" -> 
    "AvogadroConstant", "type" -> "Symbol", "uri" -> 
    "PhysicalConstants/ref/AvogadroConstant"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1574, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2197, 67, 54, 1, 70, "ObjectName",
 CellID->15543],
Cell[2254, 70, 387, 11, 70, "Usage",
 CellID->20848]
}, Open  ]],
Cell[CellGroupData[{
Cell[2678, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3156, 103, 291, 11, 70, "Notes",
 CellID->30226],
Cell[3450, 116, 380, 14, 70, "Notes",
 CellID->16760]
}, Closed]],
Cell[CellGroupData[{
Cell[3867, 135, 311, 9, 70, "SeeAlsoSection",
 CellID->14668],
Cell[4181, 146, 789, 26, 70, "SeeAlso",
 CellID->3526]
}, Open  ]],
Cell[CellGroupData[{
Cell[5007, 177, 314, 9, 70, "TutorialsSection",
 CellID->20057],
Cell[5324, 188, 175, 4, 70, "Tutorials",
 CellID->18863]
}, Open  ]],
Cell[5514, 195, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

