(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6826,        233]
NotebookOptionsPosition[      5144,        179]
NotebookOutlinePosition[      6184,        208]
CellTagsIndexPosition[      6141,        205]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ElectronComptonWavelength" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ElectronComptonWavelength"], 
          "ClassicalElectronRadius" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ClassicalElectronRadius"], 
          "ElectronMass" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ElectronMass"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ElectronComptonWavelength\"\>", 
       2->"\<\"ClassicalElectronRadius\"\>", 
       3->"\<\"ElectronMass\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BohrRadius", "ObjectName",
 CellID->15304],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["BohrRadius"], "InlineFormula"],
     " \[LineSeparator]is the Bohr radius, an atomic constant."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22378]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["BohrRadius"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  ButtonBox["Meter",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Meter"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1391]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28125],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronComptonWavelength",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ElectronComptonWavelength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClassicalElectronRadius",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ClassicalElectronRadius"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ElectronMass"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->690]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28433],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->13260]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BohrRadius - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 59.1724958}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "BohrRadius is the Bohr radius, an atomic constant.", "synonyms" -> {}, 
    "title" -> "BohrRadius", "type" -> "Symbol", "uri" -> 
    "PhysicalConstants/ref/BohrRadius"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1633, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2256, 68, 48, 1, 70, "ObjectName",
 CellID->15304],
Cell[2307, 71, 339, 10, 70, "Usage",
 CellID->22378]
}, Open  ]],
Cell[CellGroupData[{
Cell[2683, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3161, 103, 241, 9, 70, "Notes",
 CellID->1391]
}, Closed]],
Cell[CellGroupData[{
Cell[3439, 117, 311, 9, 70, "SeeAlsoSection",
 CellID->28125],
Cell[3753, 128, 820, 26, 70, "SeeAlso",
 CellID->690]
}, Open  ]],
Cell[CellGroupData[{
Cell[4610, 159, 314, 9, 70, "TutorialsSection",
 CellID->28433],
Cell[4927, 170, 175, 4, 70, "Tutorials",
 CellID->13260]
}, Open  ]],
Cell[5117, 177, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

