(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7537,        255]
NotebookOptionsPosition[      5857,        201]
NotebookOutlinePosition[      6891,        230]
CellTagsIndexPosition[      6848,        227]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DeuteronMagneticMoment" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/DeuteronMagneticMoment"], 
          "ElectronMass" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ElectronMass"], "MuonMass" :> 
          Documentation`HelpLookup["paclet:PhysicalConstants/ref/MuonMass"], 
          "NeutronMass" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/NeutronMass"], "ProtonMass" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ProtonMass"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DeuteronMagneticMoment\"\>", 
       2->"\<\"ElectronMass\"\>", 3->"\<\"MuonMass\"\>", 
       4->"\<\"NeutronMass\"\>", 5->"\<\"ProtonMass\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DeuteronMass", "ObjectName",
 CellID->14923],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["DeuteronMass"], "InlineFormula"],
     " \[LineSeparator]is the mass of a deuteron."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16498]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["DeuteronMass"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  ButtonBox["Kilogram",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Kilogram"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->31051]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18764],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeuteronMagneticMoment",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/DeuteronMagneticMoment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ElectronMass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MuonMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/MuonMass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NeutronMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/NeutronMass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ProtonMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ProtonMass"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15117]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28864],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->22677]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DeuteronMass - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 6.5476846}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "DeuteronMass is the mass of a deuteron.", "synonyms" -> {}, "title" -> 
    "DeuteronMass", "type" -> "Symbol", "uri" -> 
    "PhysicalConstants/ref/DeuteronMass"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1844, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2467, 72, 50, 1, 70, "ObjectName",
 CellID->14923],
Cell[2520, 75, 328, 10, 70, "Usage",
 CellID->16498]
}, Open  ]],
Cell[CellGroupData[{
Cell[2885, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3363, 107, 250, 9, 70, "Notes",
 CellID->31051]
}, Closed]],
Cell[CellGroupData[{
Cell[3650, 121, 311, 9, 70, "SeeAlsoSection",
 CellID->18764],
Cell[3964, 132, 1322, 44, 70, "SeeAlso",
 CellID->15117]
}, Open  ]],
Cell[CellGroupData[{
Cell[5323, 181, 314, 9, 70, "TutorialsSection",
 CellID->28864],
Cell[5640, 192, 175, 4, 70, "Tutorials",
 CellID->22677]
}, Open  ]],
Cell[5830, 199, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

