(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7163,        247]
NotebookOptionsPosition[      5423,        191]
NotebookOutlinePosition[      6465,        220]
CellTagsIndexPosition[      6422,        217]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EarthRadius" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/EarthRadius"], 
          "AccelerationDueToGravity" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/AccelerationDueToGravity"], 
          "GravitationalConstant" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/GravitationalConstant"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"EarthRadius\"\>", 
       2->"\<\"AccelerationDueToGravity\"\>", 
       3->"\<\"GravitationalConstant\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EarthMass", "ObjectName",
 CellID->371],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["EarthMass"], "InlineFormula"],
     " \[LineSeparator]is the mass of the Earth, a physical constant."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1137]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["EarthMass"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  ButtonBox["Kilogram",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Kilogram"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->26633],

Cell[TextData[{
 "The mass of the Earth is approximately ",
 Cell[BoxData[
  RowBox[{"5.9742", "*", 
   RowBox[{"10", "^", "24"}], " ", 
   ButtonBox["Kilogram",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Kilogram"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->24312]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4685],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EarthRadius",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/EarthRadius"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AccelerationDueToGravity",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/AccelerationDueToGravity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GravitationalConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/GravitationalConstant"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->679717068]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7862],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->5320]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EarthMass - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 6.7039386}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "EarthMass is the mass of the Earth, a physical constant.", 
    "synonyms" -> {}, "title" -> "EarthMass", "type" -> "Symbol", "uri" -> 
    "PhysicalConstants/ref/EarthMass"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1621, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2244, 68, 45, 1, 70, "ObjectName",
 CellID->371],
Cell[2292, 71, 344, 10, 70, "Usage",
 CellID->1137]
}, Open  ]],
Cell[CellGroupData[{
Cell[2673, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3151, 103, 247, 9, 70, "Notes",
 CellID->26633],
Cell[3401, 114, 285, 10, 70, "Notes",
 CellID->24312]
}, Closed]],
Cell[CellGroupData[{
Cell[3723, 129, 310, 9, 70, "SeeAlsoSection",
 CellID->4685],
Cell[4036, 140, 818, 26, 70, "SeeAlso",
 CellID->679717068]
}, Open  ]],
Cell[CellGroupData[{
Cell[4891, 171, 313, 9, 70, "TutorialsSection",
 CellID->7862],
Cell[5207, 182, 174, 4, 70, "Tutorials",
 CellID->5320]
}, Open  ]],
Cell[5396, 189, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

