(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7059,        238]
NotebookOptionsPosition[      5362,        184]
NotebookOutlinePosition[      6414,        213]
CellTagsIndexPosition[      6371,        210]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ElectronMass" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ElectronMass"], "ElectronCharge" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ElectronCharge"], "MuonGFactor" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/MuonGFactor"], 
          "ElectronMagneticMoment" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ElectronMagneticMoment"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ElectronMass\"\>", 
       2->"\<\"ElectronCharge\"\>", 3->"\<\"MuonGFactor\"\>", 
       4->"\<\"ElectronMagneticMoment\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ElectronGFactor", "ObjectName",
 CellID->28301],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ElectronGFactor"], "InlineFormula"],
     " \[LineSeparator]is the electron g\[Dash]factor."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12413]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["ElectronGFactor"], "InlineFormula"],
 " is a unitless number."
}], "Notes",
 CellID->17781]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20142],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ElectronMass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronCharge",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ElectronCharge"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MuonGFactor",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/MuonGFactor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronMagneticMoment",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ElectronMagneticMoment"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14541]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28451],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->3469]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ElectronGFactor - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 7.3758308}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "ElectronGFactor is the electron g\\[Dash]factor.", "synonyms" -> {}, 
    "title" -> "ElectronGFactor", "type" -> "Symbol", "uri" -> 
    "PhysicalConstants/ref/ElectronGFactor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1722, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2345, 69, 53, 1, 70, "ObjectName",
 CellID->28301],
Cell[2401, 72, 336, 10, 70, "Usage",
 CellID->12413]
}, Open  ]],
Cell[CellGroupData[{
Cell[2774, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3252, 104, 122, 4, 70, "Notes",
 CellID->17781]
}, Closed]],
Cell[CellGroupData[{
Cell[3411, 113, 311, 9, 70, "SeeAlsoSection",
 CellID->20142],
Cell[3725, 124, 1067, 35, 70, "SeeAlso",
 CellID->14541]
}, Open  ]],
Cell[CellGroupData[{
Cell[4829, 164, 314, 9, 70, "TutorialsSection",
 CellID->28451],
Cell[5146, 175, 174, 4, 70, "Tutorials",
 CellID->3469]
}, Open  ]],
Cell[5335, 182, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

