(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8324,        273]
NotebookOptionsPosition[      6599,        219]
NotebookOutlinePosition[      7679,        248]
CellTagsIndexPosition[      7636,        245]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DeuteronMagneticMoment" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/DeuteronMagneticMoment"], 
          "ElectronMass" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ElectronMass"], "ElectronCharge" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ElectronCharge"], 
          "MuonMagneticMoment" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/MuonMagneticMoment"], 
          "NeutronMagneticMoment" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/NeutronMagneticMoment"], 
          "ProtonMagneticMoment" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ProtonMagneticMoment"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DeuteronMagneticMoment\"\>", 
       2->"\<\"ElectronMass\"\>", 3->"\<\"ElectronCharge\"\>", 
       4->"\<\"MuonMagneticMoment\"\>", 5->"\<\"NeutronMagneticMoment\"\>", 
       6->"\<\"ProtonMagneticMoment\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ElectronMagneticMoment", "ObjectName",
 CellID->11612],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ElectronMagneticMoment"], "InlineFormula"],
     " \[LineSeparator]is the electron magnetic moment."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29672]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["ElectronMagneticMoment"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Joule",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Joule"], "/", 
   ButtonBox["Tesla",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Tesla"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->26826]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27388],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeuteronMagneticMoment",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/DeuteronMagneticMoment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ElectronMass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronCharge",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ElectronCharge"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MuonMagneticMoment",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/MuonMagneticMoment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NeutronMagneticMoment",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/NeutronMagneticMoment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ProtonMagneticMoment",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ProtonMagneticMoment"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29646]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29955],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->625]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ElectronMagneticMoment - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 7.5477102}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "ElectronMagneticMoment is the electron magnetic moment.", 
    "synonyms" -> {}, "title" -> "ElectronMagneticMoment", "type" -> "Symbol",
     "uri" -> "PhysicalConstants/ref/ElectronMagneticMoment"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2113, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2736, 77, 60, 1, 70, "ObjectName",
 CellID->11612],
Cell[2799, 80, 344, 10, 70, "Usage",
 CellID->29672]
}, Open  ]],
Cell[CellGroupData[{
Cell[3180, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3658, 112, 364, 13, 70, "Notes",
 CellID->26826]
}, Closed]],
Cell[CellGroupData[{
Cell[4059, 130, 311, 9, 70, "SeeAlsoSection",
 CellID->27388],
Cell[4373, 141, 1657, 53, 70, "SeeAlso",
 CellID->29646]
}, Open  ]],
Cell[CellGroupData[{
Cell[6067, 199, 314, 9, 70, "TutorialsSection",
 CellID->29955],
Cell[6384, 210, 173, 4, 70, "Tutorials",
 CellID->625]
}, Open  ]],
Cell[6572, 217, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

