(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6381,        220]
NotebookOptionsPosition[      4650,        166]
NotebookOutlinePosition[      5738,        195]
CellTagsIndexPosition[      5695,        192]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PlanckConstant" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/PlanckConstant"], "ElectronCharge" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ElectronCharge"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PlanckConstant\"\>", 
       2->"\<\"ElectronCharge\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MagneticFluxQuantum", "ObjectName",
 CellID->28061],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["MagneticFluxQuantum"], "InlineFormula"],
     " \[LineSeparator]is magnetic flux quantum, an electromagnetic \
constant."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4010]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["MagneticFluxQuantum"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  ButtonBox["Weber",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Weber"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->19480]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17252],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlanckConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/PlanckConstant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronCharge",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ElectronCharge"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31809]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17153],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->24027]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MagneticFluxQuantum - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 15.2979086}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "MagneticFluxQuantum is magnetic flux quantum, an electromagnetic \
constant.", "synonyms" -> {}, "title" -> "MagneticFluxQuantum", "type" -> 
    "Symbol", "uri" -> "PhysicalConstants/ref/MagneticFluxQuantum"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1404, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2027, 63, 57, 1, 70, "ObjectName",
 CellID->28061],
Cell[2087, 66, 364, 11, 70, "Usage",
 CellID->4010]
}, Open  ]],
Cell[CellGroupData[{
Cell[2488, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2966, 99, 251, 9, 70, "Notes",
 CellID->19480]
}, Closed]],
Cell[CellGroupData[{
Cell[3254, 113, 311, 9, 70, "SeeAlsoSection",
 CellID->17252],
Cell[3568, 124, 511, 17, 70, "SeeAlso",
 CellID->31809]
}, Open  ]],
Cell[CellGroupData[{
Cell[4116, 146, 314, 9, 70, "TutorialsSection",
 CellID->17153],
Cell[4433, 157, 175, 4, 70, "Tutorials",
 CellID->24027]
}, Open  ]],
Cell[4623, 164, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

