(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7892,        265]
NotebookOptionsPosition[      6233,        211]
NotebookOutlinePosition[      7248,        240]
CellTagsIndexPosition[      7205,        237]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DeuteronMass" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/DeuteronMass"], "ElectronMass" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ElectronMass"], "NeutronMass" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/NeutronMass"], "ProtonMass" :> 
          Documentation`HelpLookup["paclet:PhysicalConstants/ref/ProtonMass"],
           "MuonMagneticMoment" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/MuonMagneticMoment"], "MuonGFactor" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/MuonGFactor"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DeuteronMass\"\>", 2->"\<\"ElectronMass\"\>", 
       3->"\<\"NeutronMass\"\>", 4->"\<\"ProtonMass\"\>", 
       5->"\<\"MuonMagneticMoment\"\>", 
       6->"\<\"MuonGFactor\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MuonMass", "ObjectName",
 CellID->21370],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["MuonMass"], "InlineFormula"],
     " \[LineSeparator]is the mass of a muon."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21013]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["MuonMass"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  ButtonBox["Kilogram",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Kilogram"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9836]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26956],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeuteronMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/DeuteronMass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ElectronMass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NeutronMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/NeutronMass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ProtonMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ProtonMass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MuonMagneticMoment",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/MuonMagneticMoment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MuonGFactor",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/MuonGFactor"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7701]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22110],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->10068]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MuonMass - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 22.6574720}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "MuonMass is the mass of a muon.", "synonyms" -> {}, "title" -> 
    "MuonMass", "type" -> "Symbol", "uri" -> 
    "PhysicalConstants/ref/MuonMass"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1969, 46, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2592, 73, 46, 1, 70, "ObjectName",
 CellID->21370],
Cell[2641, 76, 320, 10, 70, "Usage",
 CellID->21013]
}, Open  ]],
Cell[CellGroupData[{
Cell[2998, 91, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3476, 108, 245, 9, 70, "Notes",
 CellID->9836]
}, Closed]],
Cell[CellGroupData[{
Cell[3758, 122, 311, 9, 70, "SeeAlsoSection",
 CellID->26956],
Cell[4072, 133, 1590, 53, 70, "SeeAlso",
 CellID->7701]
}, Open  ]],
Cell[CellGroupData[{
Cell[5699, 191, 314, 9, 70, "TutorialsSection",
 CellID->22110],
Cell[6016, 202, 175, 4, 70, "Tutorials",
 CellID->10068]
}, Open  ]],
Cell[6206, 209, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

