(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7881,        261]
NotebookOptionsPosition[      6162,        207]
NotebookOutlinePosition[      7238,        236]
CellTagsIndexPosition[      7195,        233]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DeuteronMagneticMoment" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/DeuteronMagneticMoment"], 
          "ElectronMagneticMoment" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ElectronMagneticMoment"], 
          "MuonMagneticMoment" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/MuonMagneticMoment"], "NeutronMass" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/NeutronMass"], 
          "ProtonMagneticMoment" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ProtonMagneticMoment"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DeuteronMagneticMoment\"\>", 
       2->"\<\"ElectronMagneticMoment\"\>", 3->"\<\"MuonMagneticMoment\"\>", 
       4->"\<\"NeutronMass\"\>", 
       5->"\<\"ProtonMagneticMoment\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NeutronMagneticMoment", "ObjectName",
 CellID->15692],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["NeutronMagneticMoment"], "InlineFormula"],
     " \[LineSeparator]is the neutron magnetic moment."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->407]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["NeutronMagneticMoment"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Joule",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Joule"], "/", 
   ButtonBox["Tesla",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Tesla"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->23218]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5448],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeuteronMagneticMoment",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/DeuteronMagneticMoment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronMagneticMoment",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ElectronMagneticMoment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MuonMagneticMoment",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/MuonMagneticMoment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NeutronMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/NeutronMass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ProtonMagneticMoment",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ProtonMagneticMoment"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25651]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5144],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->13748]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NeutronMagneticMoment - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 23.0168562}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "NeutronMagneticMoment is the neutron magnetic moment.", "synonyms" -> {},
     "title" -> "NeutronMagneticMoment", "type" -> "Symbol", "uri" -> 
    "PhysicalConstants/ref/NeutronMagneticMoment"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1957, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2580, 74, 59, 1, 70, "ObjectName",
 CellID->15692],
Cell[2642, 77, 340, 10, 70, "Usage",
 CellID->407]
}, Open  ]],
Cell[CellGroupData[{
Cell[3019, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3497, 109, 363, 13, 70, "Notes",
 CellID->23218]
}, Closed]],
Cell[CellGroupData[{
Cell[3897, 127, 310, 9, 70, "SeeAlsoSection",
 CellID->5448],
Cell[4210, 138, 1382, 44, 70, "SeeAlso",
 CellID->25651]
}, Open  ]],
Cell[CellGroupData[{
Cell[5629, 187, 313, 9, 70, "TutorialsSection",
 CellID->5144],
Cell[5945, 198, 175, 4, 70, "Tutorials",
 CellID->13748]
}, Open  ]],
Cell[6135, 205, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

