(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7122,        243]
NotebookOptionsPosition[      5339,        187]
NotebookOutlinePosition[      6425,        216]
CellTagsIndexPosition[      6382,        213]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ElectronComptonWavelength" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ElectronComptonWavelength"], 
          "NeutronComptonWavelength" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/NeutronComptonWavelength"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"ElectronComptonWavelength\"\>", 
       2->"\<\"NeutronComptonWavelength\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ProtonComptonWavelength", "ObjectName",
 CellID->23644],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ProtonComptonWavelength"], "InlineFormula"],
     " \[LineSeparator]is the proton Compton wavelength."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4237]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["ProtonComptonWavelength"], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlanckConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/PlanckConstant"], "/", 
   RowBox[{"(", 
    RowBox[{
     ButtonBox["ProtonMass",
      BaseStyle->"Link",
      ButtonData->"paclet:PhysicalConstants/ref/ProtonMass"], "*", 
     ButtonBox["SpeedOfLight",
      BaseStyle->"Link",
      ButtonData->"paclet:PhysicalConstants/ref/SpeedOfLight"]}], ")"}]}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->13082],

Cell[TextData[{
 Cell[BoxData["ProtonComptonWavelength"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  ButtonBox["Meter",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Meter"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7619]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32042],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronComptonWavelength",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ElectronComptonWavelength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NeutronComptonWavelength",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/NeutronComptonWavelength"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12619]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30667],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->10463]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ProtonComptonWavelength - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 23.8606278}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "ProtonComptonWavelength is the proton Compton wavelength.", 
    "synonyms" -> {}, "title" -> "ProtonComptonWavelength", "type" -> 
    "Symbol", "uri" -> "PhysicalConstants/ref/ProtonComptonWavelength"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1478, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2101, 64, 61, 1, 70, "ObjectName",
 CellID->23644],
Cell[2165, 67, 345, 10, 70, "Usage",
 CellID->4237]
}, Open  ]],
Cell[CellGroupData[{
Cell[2547, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3025, 99, 582, 19, 70, "Notes",
 CellID->13082],
Cell[3610, 120, 254, 9, 70, "Notes",
 CellID->7619]
}, Closed]],
Cell[CellGroupData[{
Cell[3901, 134, 311, 9, 70, "SeeAlsoSection",
 CellID->32042],
Cell[4215, 145, 553, 17, 70, "SeeAlso",
 CellID->12619]
}, Open  ]],
Cell[CellGroupData[{
Cell[4805, 167, 314, 9, 70, "TutorialsSection",
 CellID->30667],
Cell[5122, 178, 175, 4, 70, "Tutorials",
 CellID->10463]
}, Open  ]],
Cell[5312, 185, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

