(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7990,        267]
NotebookOptionsPosition[      6322,        213]
NotebookOutlinePosition[      7347,        242]
CellTagsIndexPosition[      7304,        239]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DeuteronMass" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/DeuteronMass"], "ElectronMass" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ElectronMass"], "MuonMass" :> 
          Documentation`HelpLookup["paclet:PhysicalConstants/ref/MuonMass"], 
          "NeutronMass" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/NeutronMass"], 
          "ProtonMagneticMoment" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ProtonMagneticMoment"], 
          "ProtonComptonWavelength" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ProtonComptonWavelength"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DeuteronMass\"\>", 
       2->"\<\"ElectronMass\"\>", 3->"\<\"MuonMass\"\>", 
       4->"\<\"NeutronMass\"\>", 5->"\<\"ProtonMagneticMoment\"\>", 
       6->"\<\"ProtonComptonWavelength\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ProtonMass", "ObjectName",
 CellID->20584],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ProtonMass"], "InlineFormula"],
     " \[LineSeparator]is the mass of a proton."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->377]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["ProtonMass"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  ButtonBox["Kilogram",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Kilogram"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9246]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29745],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeuteronMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/DeuteronMass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ElectronMass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MuonMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/MuonMass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NeutronMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/NeutronMass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ProtonMagneticMoment",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ProtonMagneticMoment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ProtonComptonWavelength",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ProtonComptonWavelength"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32341]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16020],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->15406]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ProtonMass - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 30.8295562}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "ProtonMass is the mass of a proton.", "synonyms" -> {}, "title" -> 
    "ProtonMass", "type" -> "Symbol", "uri" -> 
    "PhysicalConstants/ref/ProtonMass"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2027, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2650, 75, 48, 1, 70, "ObjectName",
 CellID->20584],
Cell[2701, 78, 322, 10, 70, "Usage",
 CellID->377]
}, Open  ]],
Cell[CellGroupData[{
Cell[3060, 93, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3538, 110, 247, 9, 70, "Notes",
 CellID->9246]
}, Closed]],
Cell[CellGroupData[{
Cell[3822, 124, 311, 9, 70, "SeeAlsoSection",
 CellID->29745],
Cell[4136, 135, 1615, 53, 70, "SeeAlso",
 CellID->32341]
}, Open  ]],
Cell[CellGroupData[{
Cell[5788, 193, 314, 9, 70, "TutorialsSection",
 CellID->16020],
Cell[6105, 204, 175, 4, 70, "Tutorials",
 CellID->15406]
}, Open  ]],
Cell[6295, 211, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

