(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7819,        258]
NotebookOptionsPosition[      6027,        203]
NotebookOutlinePosition[      7174,        233]
CellTagsIndexPosition[      7131,        230]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PlanckConstant" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/PlanckConstant"], "ElectronMass" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ElectronMass"], "ElectronCharge" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ElectronCharge"], "SpeedOfLight" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/SpeedOfLight"], "VacuumPermittivity" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/VacuumPermittivity"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PlanckConstant\"\>", 
       2->"\<\"ElectronMass\"\>", 3->"\<\"ElectronCharge\"\>", 
       4->"\<\"SpeedOfLight\"\>", 
       5->"\<\"VacuumPermittivity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RydbergConstant", "ObjectName",
 CellID->8692],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["RydbergConstant"], "InlineFormula"],
     " \[LineSeparator]is an atomic constant appearing in the Rydberg formula \
expressing the wave\[Dash]numbers of the lines in a spectral series."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11114]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["RydbergConstant"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Meter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Meter"], "^", 
   RowBox[{"-", "1"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->18887]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31643],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlanckConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/PlanckConstant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ElectronMass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronCharge",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ElectronCharge"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpeedOfLight",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/SpeedOfLight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VacuumPermittivity",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/VacuumPermittivity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8819]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25960],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->31114]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RydbergConstant - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 31.1733150}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "RydbergConstant is an atomic constant appearing in the Rydberg formula \
expressing the wave\\[Dash]numbers of the lines in a spectral series.", 
    "synonyms" -> {}, "title" -> "RydbergConstant", "type" -> "Symbol", "uri" -> 
    "PhysicalConstants/ref/RydbergConstant"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1855, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2478, 71, 52, 1, 70, "ObjectName",
 CellID->8692],
Cell[2533, 74, 430, 11, 70, "Usage",
 CellID->11114]
}, Open  ]],
Cell[CellGroupData[{
Cell[3000, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3478, 107, 292, 11, 70, "Notes",
 CellID->18887]
}, Closed]],
Cell[CellGroupData[{
Cell[3807, 123, 311, 9, 70, "SeeAlsoSection",
 CellID->31643],
Cell[4121, 134, 1335, 44, 70, "SeeAlso",
 CellID->8819]
}, Open  ]],
Cell[CellGroupData[{
Cell[5493, 183, 314, 9, 70, "TutorialsSection",
 CellID->25960],
Cell[5810, 194, 175, 4, 70, "Tutorials",
 CellID->31114]
}, Open  ]],
Cell[6000, 201, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

