(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6270,        219]
NotebookOptionsPosition[      4583,        165]
NotebookOutlinePosition[      5627,        194]
CellTagsIndexPosition[      5584,        191]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SolarRadius" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/SolarRadius"], "SolarConstant" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/SolarConstant"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SolarRadius\"\>", 
       2->"\<\"SolarConstant\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SolarLuminosity", "ObjectName",
 CellID->26452],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["SolarLuminosity"], "InlineFormula"],
     " \[LineSeparator]is a physical constant."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19149]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["SolarLuminosity"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  ButtonBox["Watt",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Watt"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->31600]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32210],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SolarRadius",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/SolarRadius"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SolarConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/SolarConstant"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10742]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1491],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->18811]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SolarLuminosity - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 31.6889532}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "SolarLuminosity is a physical constant.", "synonyms" -> {}, "title" -> 
    "SolarLuminosity", "type" -> "Symbol", "uri" -> 
    "PhysicalConstants/ref/SolarLuminosity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1392, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2015, 63, 53, 1, 70, "ObjectName",
 CellID->26452],
Cell[2071, 66, 328, 10, 70, "Usage",
 CellID->19149]
}, Open  ]],
Cell[CellGroupData[{
Cell[2436, 81, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2914, 98, 245, 9, 70, "Notes",
 CellID->31600]
}, Closed]],
Cell[CellGroupData[{
Cell[3196, 112, 311, 9, 70, "SeeAlsoSection",
 CellID->32210],
Cell[3510, 123, 503, 17, 70, "SeeAlso",
 CellID->10742]
}, Open  ]],
Cell[CellGroupData[{
Cell[4050, 145, 313, 9, 70, "TutorialsSection",
 CellID->1491],
Cell[4366, 156, 175, 4, 70, "Tutorials",
 CellID->18811]
}, Open  ]],
Cell[4556, 163, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

