(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7093,        242]
NotebookOptionsPosition[      5418,        188]
NotebookOutlinePosition[      6446,        217]
CellTagsIndexPosition[      6403,        214]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EarthRadius" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/EarthRadius"], "SolarConstant" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/SolarConstant"], "SolarLuminosity" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/SolarLuminosity"], "GalacticUnit" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/GalacticUnit"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"EarthRadius\"\>", 2->"\<\"SolarConstant\"\>", 
       3->"\<\"SolarLuminosity\"\>", 
       4->"\<\"GalacticUnit\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SolarRadius", "ObjectName",
 CellID->6719],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["SolarRadius"], "InlineFormula"],
     " \[LineSeparator]is a physical constant."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13297]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["SolarRadius"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  ButtonBox["Meter",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Meter"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1654]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18913],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EarthRadius",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/EarthRadius"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SolarConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/SolarConstant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SolarLuminosity",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/SolarLuminosity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GalacticUnit",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/GalacticUnit"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18895784]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11528],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->10274]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SolarRadius - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 31.8608326}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "SolarRadius is a physical constant.", "synonyms" -> {}, "title" -> 
    "SolarRadius", "type" -> "Symbol", "uri" -> 
    "PhysicalConstants/ref/SolarRadius"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1687, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2310, 68, 48, 1, 70, "ObjectName",
 CellID->6719],
Cell[2361, 71, 324, 10, 70, "Usage",
 CellID->13297]
}, Open  ]],
Cell[CellGroupData[{
Cell[2722, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3200, 103, 242, 9, 70, "Notes",
 CellID->1654]
}, Closed]],
Cell[CellGroupData[{
Cell[3479, 117, 311, 9, 70, "SeeAlsoSection",
 CellID->18913],
Cell[3793, 128, 1054, 35, 70, "SeeAlso",
 CellID->18895784]
}, Open  ]],
Cell[CellGroupData[{
Cell[4884, 168, 314, 9, 70, "TutorialsSection",
 CellID->11528],
Cell[5201, 179, 175, 4, 70, "Tutorials",
 CellID->10274]
}, Open  ]],
Cell[5391, 186, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

