(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6337,        219]
NotebookOptionsPosition[      4609,        165]
NotebookOutlinePosition[      5694,        194]
CellTagsIndexPosition[      5651,        191]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"VacuumPermittivity" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/VacuumPermittivity"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"VacuumPermittivity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["VacuumPermeability", "ObjectName",
 CellID->12535],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["VacuumPermeability"], "InlineFormula"],
     " \[LineSeparator]is the permeability of vacuum, a universal constant."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27397]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["VacuumPermeability"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Second",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Second"], "*", 
   RowBox[{
    ButtonBox["Volt",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Volt"], "/", 
    RowBox[{"(", 
     RowBox[{
      ButtonBox["Ampere",
       BaseStyle->"Link",
       ButtonData->"paclet:Units/ref/Ampere"], "*", 
      ButtonBox["Meter",
       BaseStyle->"Link",
       ButtonData->"paclet:Units/ref/Meter"]}], ")"}]}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9025]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29073],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["VacuumPermittivity",
   BaseStyle->"Link",
   ButtonData->"paclet:PhysicalConstants/ref/VacuumPermittivity"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->29994]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13707],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->17184]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VacuumPermeability - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 39.3453992}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "VacuumPermeability is the permeability of vacuum, a universal constant.",
     "synonyms" -> {}, "title" -> "VacuumPermeability", "type" -> "Symbol", 
    "uri" -> "PhysicalConstants/ref/VacuumPermeability"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1271, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1894, 61, 56, 1, 70, "ObjectName",
 CellID->12535],
Cell[1953, 64, 360, 10, 70, "Usage",
 CellID->27397]
}, Open  ]],
Cell[CellGroupData[{
Cell[2350, 79, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2828, 96, 625, 22, 70, "Notes",
 CellID->9025]
}, Closed]],
Cell[CellGroupData[{
Cell[3490, 123, 311, 9, 70, "SeeAlsoSection",
 CellID->29073],
Cell[3804, 134, 234, 6, 70, "SeeAlso",
 CellID->29994]
}, Open  ]],
Cell[CellGroupData[{
Cell[4075, 145, 314, 9, 70, "TutorialsSection",
 CellID->13707],
Cell[4392, 156, 175, 4, 70, "Tutorials",
 CellID->17184]
}, Open  ]],
Cell[4582, 163, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

