(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22603,        600]
NotebookOptionsPosition[     19929,        524]
NotebookOutlinePosition[     21686,        566]
CellTagsIndexPosition[     21643,        563]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE TUTORIAL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"AccelerationDueToGravity" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/AccelerationDueToGravity"], 
         "AgeOfUniverse" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/AgeOfUniverse"], "AvogadroConstant" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/AvogadroConstant"], "BohrRadius" :> 
         Documentation`HelpLookup["paclet:PhysicalConstants/ref/BohrRadius"], 
         "BoltzmannConstant" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/BoltzmannConstant"], 
         "ClassicalElectronRadius" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/ClassicalElectronRadius"], 
         "CosmicBackgroundTemperature" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/CosmicBackgroundTemperature"], 
         "DeuteronMagneticMoment" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/DeuteronMagneticMoment"], 
         "DeuteronMass" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/DeuteronMass"], "EarthMass" :> 
         Documentation`HelpLookup["paclet:PhysicalConstants/ref/EarthMass"], 
         "EarthRadius" :> 
         Documentation`HelpLookup["paclet:PhysicalConstants/ref/EarthRadius"],
          "ElectronCharge" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/ElectronCharge"], 
         "ElectronComptonWavelength" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/ElectronComptonWavelength"], 
         "ElectronGFactor" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/ElectronGFactor"], 
         "ElectronMagneticMoment" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/ElectronMagneticMoment"], 
         "ElectronMass" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/ElectronMass"], "FaradayConstant" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/FaradayConstant"], 
         "FineStructureConstant" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/FineStructureConstant"], 
         "GalacticUnit" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/GalacticUnit"], 
         "GravitationalConstant" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/GravitationalConstant"], 
         "HubbleConstant" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/HubbleConstant"], "IcePoint" :> 
         Documentation`HelpLookup["paclet:PhysicalConstants/ref/IcePoint"], 
         "MagneticFluxQuantum" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/MagneticFluxQuantum"], 
         "MolarGasConstant" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/MolarGasConstant"], "MolarVolume" :> 
         Documentation`HelpLookup["paclet:PhysicalConstants/ref/MolarVolume"],
          "MuonGFactor" :> 
         Documentation`HelpLookup["paclet:PhysicalConstants/ref/MuonGFactor"],
          "MuonMagneticMoment" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/MuonMagneticMoment"], "MuonMass" :> 
         Documentation`HelpLookup["paclet:PhysicalConstants/ref/MuonMass"], 
         "NeutronComptonWavelength" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/NeutronComptonWavelength"], 
         "NeutronMagneticMoment" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/NeutronMagneticMoment"], 
         "NeutronMass" :> 
         Documentation`HelpLookup["paclet:PhysicalConstants/ref/NeutronMass"],
          "PlanckConstant" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/PlanckConstant"], 
         "PlanckConstantReduced" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/PlanckConstantReduced"], "PlanckMass" :> 
         Documentation`HelpLookup["paclet:PhysicalConstants/ref/PlanckMass"], 
         "ProtonComptonWavelength" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/ProtonComptonWavelength"], 
         "ProtonMagneticMoment" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/ProtonMagneticMoment"], "ProtonMass" :> 
         Documentation`HelpLookup["paclet:PhysicalConstants/ref/ProtonMass"], 
         "QuantizedHallConductance" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/QuantizedHallConductance"], 
         "RydbergConstant" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/RydbergConstant"], 
         "SackurTetrodeConstant" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/SackurTetrodeConstant"], 
         "SolarConstant" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/SolarConstant"], "SolarLuminosity" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/SolarLuminosity"], "SolarRadius" :> 
         Documentation`HelpLookup["paclet:PhysicalConstants/ref/SolarRadius"],
          "SolarSchwarzschildRadius" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/SolarSchwarzschildRadius"], 
         "SpeedOfLight" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/SpeedOfLight"], "SpeedOfSound" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/SpeedOfSound"], "StefanConstant" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/StefanConstant"], 
         "ThomsonCrossSection" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/ThomsonCrossSection"], 
         "VacuumPermeability" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/VacuumPermeability"], 
         "VacuumPermittivity" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/VacuumPermittivity"], 
         "WeakMixingAngle" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/ref/WeakMixingAngle"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"AccelerationDueToGravity\"\>", 
      2->"\<\"AgeOfUniverse\"\>", 3->"\<\"AvogadroConstant\"\>", 
      4->"\<\"BohrRadius\"\>", 5->"\<\"BoltzmannConstant\"\>", 
      6->"\<\"ClassicalElectronRadius\"\>", 
      7->"\<\"CosmicBackgroundTemperature\"\>", 
      8->"\<\"DeuteronMagneticMoment\"\>", 9->"\<\"DeuteronMass\"\>", 
      10->"\<\"EarthMass\"\>", 11->"\<\"EarthRadius\"\>", 
      12->"\<\"ElectronCharge\"\>", 13->"\<\"ElectronComptonWavelength\"\>", 
      14->"\<\"ElectronGFactor\"\>", 15->"\<\"ElectronMagneticMoment\"\>", 
      16->"\<\"ElectronMass\"\>", 17->"\<\"FaradayConstant\"\>", 
      18->"\<\"FineStructureConstant\"\>", 19->"\<\"GalacticUnit\"\>", 
      20->"\<\"GravitationalConstant\"\>", 21->"\<\"HubbleConstant\"\>", 
      22->"\<\"IcePoint\"\>", 23->"\<\"MagneticFluxQuantum\"\>", 
      24->"\<\"MolarGasConstant\"\>", 25->"\<\"MolarVolume\"\>", 
      26->"\<\"MuonGFactor\"\>", 27->"\<\"MuonMagneticMoment\"\>", 
      28->"\<\"MuonMass\"\>", 29->"\<\"NeutronComptonWavelength\"\>", 
      30->"\<\"NeutronMagneticMoment\"\>", 31->"\<\"NeutronMass\"\>", 
      32->"\<\"PlanckConstant\"\>", 33->"\<\"PlanckConstantReduced\"\>", 
      34->"\<\"PlanckMass\"\>", 35->"\<\"ProtonComptonWavelength\"\>", 
      36->"\<\"ProtonMagneticMoment\"\>", 37->"\<\"ProtonMass\"\>", 
      38->"\<\"QuantizedHallConductance\"\>", 39->"\<\"RydbergConstant\"\>", 
      40->"\<\"SackurTetrodeConstant\"\>", 41->"\<\"SolarConstant\"\>", 
      42->"\<\"SolarLuminosity\"\>", 43->"\<\"SolarRadius\"\>", 
      44->"\<\"SolarSchwarzschildRadius\"\>", 45->"\<\"SpeedOfLight\"\>", 
      46->"\<\"SpeedOfSound\"\>", 47->"\<\"StefanConstant\"\>", 
      48->"\<\"ThomsonCrossSection\"\>", 49->"\<\"VacuumPermeability\"\>", 
      50->"\<\"VacuumPermittivity\"\>", 
      51->"\<\"WeakMixingAngle\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Physical Constants Package", "Title",
 CellID->16421],

Cell[TextData[{
 "In addition to providing a comprehensive environment for calculations and a \
programming language, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is also a system for representing and presenting scientific and technical \
knowledge. Certain packages are included with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to provide easy access to commonly used scientific data, such as the value \
of physical constants and conversion factors for various systems of units. "
}], "Text",
 CellID->8966],

Cell[BoxData[GridBox[{
   {
    ButtonBox["SpeedOfLight",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/SpeedOfLight"], Cell[
    TextData[{
     "the speed of light is ",
     StyleBox["299792458", "InlineCode"],
     " meter/second "
    }], "TableText"]},
   {
    ButtonBox["AvogadroConstant",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/AvogadroConstant"], Cell[
    TextData[{
     "Avogadro\[CloseCurlyQuote]s constant is approximately ",
     Cell[BoxData[
      RowBox[{"6.02214199", "\[Cross]", 
       SuperscriptBox["10", "23"]}]], "InlineCode"],
     " ",
     Cell[BoxData[
      SuperscriptBox["mole", 
       RowBox[{"-", "1"}]]], "InlineCode"]
    }], "TableText"]},
   {
    ButtonBox["ElectronMass",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/ElectronMass"], Cell[
    TextData[{
     "the mass of an electron is approximately ",
     Cell[BoxData[
      RowBox[{"9.10938188", "\[Cross]", 
       SuperscriptBox["10", 
        RowBox[{"-", "31"}]]}]], "InlineCode"],
     " kilograms"
    }], "TableText"]},
   {
    ButtonBox["FineStructureConstant",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/FineStructureConstant"], Cell[
    TextData[{
     "the fine structure constant is approximately ",
     Cell[BoxData[
      RowBox[{"7.297352533", "\[Cross]", 
       SuperscriptBox["10", 
        RowBox[{"-", "3"}]]}]], "InlineCode"]
    }], "TableText"]},
   {
    ButtonBox["EarthMass",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/EarthMass"], Cell[TextData[{
     "the mass of the earth is approximately ",
     Cell[BoxData[
      RowBox[{"5.9742", "\[Cross]", 
       SuperscriptBox["10", "24"]}]], "InlineCode"],
     " kilograms"
    }], "TableText"]},
   {
    ButtonBox["AccelerationDueToGravity",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/AccelerationDueToGravity"], 
    Cell[TextData[{
     "the acceleration due to gravity is ",
     Cell[BoxData["9.80665"], "InlineCode"],
     " ",
     Cell[BoxData[
      SuperscriptBox[
       RowBox[{"meters", "/", "second"}], "2"]], "InlineCode"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->20049],

Cell["Some common physical constants. ", "Caption",
 CellID->12247],

Cell["This loads the package. ", "MathCaption",
 CellID->899],

Cell[BoxData[
 RowBox[{"<<", "PhysicalConstants`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30837],

Cell["This gives the mass of a proton. ", "MathCaption",
 CellID->32689],

Cell[CellGroupData[{

Cell[BoxData["ProtonMass"], "Input",
 CellLabel->"In[2]:=",
 CellID->22007],

Cell[BoxData[
 RowBox[{"1.67262158`*^-27", " ", "Kilogram"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->314142684]
}, Open  ]],

Cell["\<\
Here is the distance that light could travel in the age of the universe. \
\>", "MathCaption",
 CellID->17355],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpeedOfLight", " ", "AgeOfUniverse"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->26041],

Cell[BoxData[
 RowBox[{"1.4090245526`*^26", " ", "Meter"}]], "Output",
 ImageSize->{127, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->634748865]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    ButtonBox["AccelerationDueToGravity",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/AccelerationDueToGravity"], 
    ButtonBox["AgeOfUniverse",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/AgeOfUniverse"]},
   {
    ButtonBox["AvogadroConstant",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/AvogadroConstant"], 
    ButtonBox["BohrRadius",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/BohrRadius"]},
   {
    ButtonBox["BoltzmannConstant",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/BoltzmannConstant"], 
    ButtonBox["ClassicalElectronRadius",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/ClassicalElectronRadius"]},
   {
    ButtonBox["CosmicBackgroundTemperature",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/CosmicBackgroundTemperature"], 
    
    ButtonBox["DeuteronMagneticMoment",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/DeuteronMagneticMoment"]},
   {
    ButtonBox["DeuteronMass",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/DeuteronMass"], 
    ButtonBox["EarthMass",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/EarthMass"]},
   {
    ButtonBox["EarthRadius",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/EarthRadius"], 
    ButtonBox["ElectronCharge",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/ElectronCharge"]},
   {
    ButtonBox["ElectronComptonWavelength",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/ElectronComptonWavelength"], 
    ButtonBox["ElectronGFactor",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/ElectronGFactor"]},
   {
    ButtonBox["ElectronMagneticMoment",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/ElectronMagneticMoment"], 
    ButtonBox["ElectronMass",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/ElectronMass"]},
   {
    ButtonBox["FaradayConstant",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/FaradayConstant"], 
    ButtonBox["FineStructureConstant",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/FineStructureConstant"]},
   {
    ButtonBox["GalacticUnit",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/GalacticUnit"], 
    ButtonBox["GravitationalConstant",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/GravitationalConstant"]},
   {
    ButtonBox["HubbleConstant",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/HubbleConstant"], 
    ButtonBox["IcePoint",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/IcePoint"]},
   {
    ButtonBox["MagneticFluxQuantum",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/MagneticFluxQuantum"], 
    ButtonBox["MolarGasConstant",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/MolarGasConstant"]},
   {
    ButtonBox["MolarVolume",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/MolarVolume"], 
    ButtonBox["MuonGFactor",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/MuonGFactor"]},
   {
    ButtonBox["MuonMagneticMoment",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/MuonMagneticMoment"], 
    ButtonBox["MuonMass",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/MuonMass"]},
   {
    ButtonBox["NeutronComptonWavelength",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/NeutronComptonWavelength"], 
    ButtonBox["NeutronMagneticMoment",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/NeutronMagneticMoment"]},
   {
    ButtonBox["NeutronMass",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/NeutronMass"], 
    ButtonBox["PlanckConstant",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/PlanckConstant"]},
   {
    ButtonBox["PlanckConstantReduced",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/PlanckConstantReduced"], 
    ButtonBox["PlanckMass",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/PlanckMass"]},
   {
    ButtonBox["ProtonComptonWavelength",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/ProtonComptonWavelength"], 
    ButtonBox["ProtonMagneticMoment",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/ProtonMagneticMoment"]},
   {
    ButtonBox["ProtonMass",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/ProtonMass"], 
    ButtonBox["QuantizedHallConductance",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/QuantizedHallConductance"]},
   {
    ButtonBox["RydbergConstant",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/RydbergConstant"], 
    ButtonBox["SackurTetrodeConstant",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/SackurTetrodeConstant"]},
   {
    ButtonBox["SolarConstant",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/SolarConstant"], 
    ButtonBox["SolarLuminosity",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/SolarLuminosity"]},
   {
    ButtonBox["SolarRadius",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/SolarRadius"], 
    ButtonBox["SolarSchwarzschildRadius",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/SolarSchwarzschildRadius"]},
   {
    ButtonBox["SpeedOfLight",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/SpeedOfLight"], 
    ButtonBox["SpeedOfSound",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/SpeedOfSound"]},
   {
    ButtonBox["StefanConstant",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/StefanConstant"], 
    ButtonBox["ThomsonCrossSection",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/ThomsonCrossSection"]},
   {
    ButtonBox["VacuumPermeability",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/VacuumPermeability"], 
    ButtonBox["VacuumPermittivity",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/VacuumPermittivity"]},
   {
    ButtonBox["WeakMixingAngle",
     BaseStyle->"Link",
     ButtonData->"paclet:PhysicalConstants/ref/WeakMixingAngle"], "\[Null]"}
  }]], "DefinitionBox",
 CellID->28294],

Cell["Physical constants.", "Caption",
 CellID->17577]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Physical Constants Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 39.8141612}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Tutorial", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "In addition to providing a comprehensive environment for calculations \
and a programming language, Mathematica is also a system for representing and \
presenting scientific and technical knowledge. Certain packages are included \
with Mathematica to provide easy access to commonly used scientific data, \
such as the value of physical constants and conversion factors for various \
systems of units. Some common physical constants. This loads the package. ", 
    "synonyms" -> {}, "title" -> "Physical Constants Package", "type" -> 
    "Tutorial", "uri" -> "PhysicalConstants/tutorial/PhysicalConstants"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 8596, 168, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[9221, 195, 59, 1, 70, "Title",
 CellID->16421],
Cell[9283, 198, 530, 12, 70, "Text",
 CellID->8966],
Cell[9816, 212, 2242, 70, 70, "DefinitionBox",
 CellID->20049],
Cell[12061, 284, 67, 1, 70, "Caption",
 CellID->12247],
Cell[12131, 287, 61, 1, 70, "MathCaption",
 CellID->899],
Cell[12195, 290, 101, 3, 70, "Input",
 CellID->30837],
Cell[12299, 295, 72, 1, 70, "MathCaption",
 CellID->32689],
Cell[CellGroupData[{
Cell[12396, 300, 75, 2, 28, "Input",
 CellID->22007],
Cell[12474, 304, 203, 6, 36, "Output",
 CellID->314142684]
}, Open  ]],
Cell[12692, 313, 120, 3, 70, "MathCaption",
 CellID->17355],
Cell[CellGroupData[{
Cell[12837, 320, 111, 3, 70, "Input",
 CellID->26041],
Cell[12951, 325, 201, 6, 36, "Output",
 CellID->634748865]
}, Open  ]],
Cell[13167, 334, 6663, 182, 70, "DefinitionBox",
 CellID->28294],
Cell[19833, 518, 54, 1, 70, "Caption",
 CellID->17577]
}, Open  ]],
Cell[19902, 522, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

