(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10677,        371]
NotebookOptionsPosition[      8341,        293]
NotebookOutlinePosition[      9556,        329]
CellTagsIndexPosition[      9472,        324]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PIE CHARTS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Disk" :> Documentation`HelpLookup["paclet:ref/Disk"], 
         "Normalize" :> Documentation`HelpLookup["paclet:ref/Normalize"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"Disk\"\>", 
      2->"\<\"Normalize\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PieChart", "ObjectName",
 CellID->13633],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PieChart", "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a pie chart of the positive values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1722]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The data values ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["y", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " must all be positive."
}], "Notes",
 CellID->13185],

Cell["The following options can be given:", "Notes",
 CellID->17222],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PieEdgeStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:PieCharts/ref/PieEdgeStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "style of the lines", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PieExploded",
     BaseStyle->"Link",
     ButtonData->"paclet:PieCharts/ref/PieExploded"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "control of the radial positions of wedges", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PieLabels",
     BaseStyle->"Link",
     ButtonData->"paclet:PieCharts/ref/PieLabels"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "list of labels for each pie wedge", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PieOrientation",
     BaseStyle->"Link",
     ButtonData->"paclet:PieCharts/ref/PieOrientation"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "ordering of pie wedges ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PieStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:PieCharts/ref/PieStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "list of styles for each pie wedge", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->9375]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->325902772],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->285100891],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PieCharts`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->115745262],

Cell["A pie chart of four values:", "ExampleText",
 CellID->1888388196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{"{", 
   RowBox[{"0.2", ",", "0.3", ",", "0.1", ",", "0.5"}], "}"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->594859021],

Cell[BoxData[
 GraphicsBox[{{
    {Hue[0.67, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {6.283185307179586, 7.425582635757693}]}, 
    {Hue[0.9060679774997897, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {7.425582635757693, 9.139178628624853}]}, 
    {Hue[0.1421359549995791, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {9.139178628624853, 9.710377292913906}]}, 
    {Hue[0.37820393249936846`, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {9.710377292913906, 12.566370614359172`}]}}, {
    InsetBox["1", {0.5047521196987089, 0.32438449047335827`}], 
    InsetBox["2", {-0.24924900780113202`, 0.545779197212711}], 
    InsetBox["3", {-0.6, 2.2043642384652356`*^-16}], 
    InsetBox["4", {0.08538890296397025, -0.5938928651285598}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 ImageSize->{364, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4002058]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7354],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Disk",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Disk"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Normalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normalize"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9244]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PieChart - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 46.6580864}", "context" -> "PieCharts`", 
    "keywords" -> {}, "index" -> True, "label" -> "Pie Charts Package Symbol",
     "language" -> "en", "paclet" -> "PieCharts Package", "status" -> "None", 
    "summary" -> 
    "PieChart[{y_1, y_2, ...}] generates a pie chart of the positive values \
y_i.", "synonyms" -> {}, "title" -> "PieChart", "type" -> "Symbol", "uri" -> 
    "PieCharts/ref/PieChart"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4663, 157, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->325902772]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9329, 317}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 641, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1264, 42, 46, 1, 70, "ObjectName",
 CellID->13633],
Cell[1313, 45, 769, 25, 70, "Usage",
 CellID->1722]
}, Open  ]],
Cell[CellGroupData[{
Cell[2119, 75, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2597, 92, 191, 8, 70, "Notes",
 CellID->13185],
Cell[2791, 102, 68, 1, 70, "Notes",
 CellID->17222],
Cell[2862, 105, 1764, 47, 70, "3ColumnTableMod",
 CellID->9375]
}, Closed]],
Cell[CellGroupData[{
Cell[4663, 157, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->325902772],
Cell[CellGroupData[{
Cell[5048, 171, 148, 5, 70, "ExampleSection",
 CellID->285100891],
Cell[5199, 178, 132, 3, 70, "Input",
 CellID->115745262],
Cell[5334, 183, 71, 1, 70, "ExampleText",
 CellID->1888388196],
Cell[CellGroupData[{
Cell[5430, 188, 181, 6, 28, "Input",
 CellID->594859021],
Cell[5614, 196, 1867, 57, 380, "Output",
 CellID->4002058]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7542, 260, 310, 9, 70, "SeeAlsoSection",
 CellID->7354],
Cell[7855, 271, 444, 17, 70, "SeeAlso",
 CellID->9244]
}, Open  ]],
Cell[8314, 291, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

