(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20003,        679]
NotebookOptionsPosition[     16819,        571]
NotebookOutlinePosition[     18064,        607]
CellTagsIndexPosition[     17979,        602]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PIE CHARTS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"PieChart" :> 
         Documentation`HelpLookup["paclet:PieCharts/ref/PieChart"], 
         "PieStyle" :> 
         Documentation`HelpLookup["paclet:PieCharts/ref/PieStyle"], 
         "Thickness" :> Documentation`HelpLookup["paclet:ref/Thickness"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"PieChart\"\>", 
      2->"\<\"PieStyle\"\>", 3->"\<\"Thickness\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PieEdgeStyle", "ObjectName",
 CellID->4335],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["PieEdgeStyle"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["PieChart",
       BaseStyle->"Link",
       ButtonData->"paclet:PieCharts/ref/PieChart"]], "InlineFormula"],
     " that specifies the styles for lines in the pie chart."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24636]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be used:", "Notes",
 CellID->8468],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["style", "TI"], Cell[
    "style for all lines in the pie chart", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["style", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["style", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "style for lines in respective wedges in the chart", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "default behavior", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->19711]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->267403997],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->76693042],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PieCharts`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->18196036],

Cell[TextData[{
 Cell[BoxData["PieChart"], "InlineFormula"],
 " uses black edges by default:"
}], "ExampleText",
 CellID->615400351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.2", ",", "0.3", ",", "0.1", ",", "0.5"}], "}"}], ",", " ", 
   RowBox[{"PieEdgeStyle", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->369124514],

Cell[BoxData[
 GraphicsBox[{{
    {Hue[0.67, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {6.283185307179586, 7.425582635757693}]}, 
    {Hue[0.9060679774997897, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {7.425582635757693, 9.139178628624853}]}, 
    {Hue[0.1421359549995791, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {9.139178628624853, 9.710377292913906}]}, 
    {Hue[0.37820393249936846`, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {9.710377292913906, 12.566370614359172`}]}}, {
    InsetBox["1", {0.5047521196987089, 0.32438449047335827`}], 
    InsetBox["2", {-0.24924900780113202`, 0.545779197212711}], 
    InsetBox["3", {-0.6, 2.2043642384652356`*^-16}], 
    InsetBox["4", {0.08538890296397025, -0.5938928651285598}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 ImageSize->{364, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->38158906]
}, Open  ]],

Cell["Don't draw any edges:", "ExampleText",
 CellID->752455305],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.2", ",", "0.3", ",", "0.1", ",", "0.5"}], "}"}], ",", " ", 
   RowBox[{"PieEdgeStyle", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->114795318],

Cell[BoxData[
 GraphicsBox[{{
    {Hue[0.67, 0.35, 0.75], EdgeForm[None], 
     DiskBox[{0, 0}, 1, {6.283185307179586, 7.425582635757693}]}, 
    {Hue[0.9060679774997897, 0.35, 0.75], EdgeForm[None], 
     DiskBox[{0, 0}, 1, {7.425582635757693, 9.139178628624853}]}, 
    {Hue[0.1421359549995791, 0.35, 0.75], EdgeForm[None], 
     DiskBox[{0, 0}, 1, {9.139178628624853, 9.710377292913906}]}, 
    {Hue[0.37820393249936846`, 0.35, 0.75], EdgeForm[None], 
     DiskBox[{0, 0}, 1, {9.710377292913906, 12.566370614359172`}]}}, {
    InsetBox["1", {0.5047521196987089, 0.32438449047335827`}], 
    InsetBox["2", {-0.24924900780113202`, 0.545779197212711}], 
    InsetBox["3", {-0.6, 2.2043642384652356`*^-16}], 
    InsetBox["4", {0.08538890296397025, -0.5938928651285598}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 ImageSize->{364, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->23202484]
}, Open  ]],

Cell["Use red edges:", "ExampleText",
 CellID->2132597599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.2", ",", "0.3", ",", "0.1", ",", "0.5"}], "}"}], ",", " ", 
   RowBox[{"PieEdgeStyle", "\[Rule]", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->924594620],

Cell[BoxData[
 GraphicsBox[{{
    {Hue[0.67, 0.35, 0.75], EdgeForm[RGBColor[1, 0, 0]], 
     DiskBox[{0, 0}, 1, {6.283185307179586, 7.425582635757693}]}, 
    {Hue[0.9060679774997897, 0.35, 0.75], EdgeForm[RGBColor[1, 0, 0]], 
     DiskBox[{0, 0}, 1, {7.425582635757693, 9.139178628624853}]}, 
    {Hue[0.1421359549995791, 0.35, 0.75], EdgeForm[RGBColor[1, 0, 0]], 
     DiskBox[{0, 0}, 1, {9.139178628624853, 9.710377292913906}]}, 
    {Hue[0.37820393249936846`, 0.35, 0.75], EdgeForm[RGBColor[1, 0, 0]], 
     DiskBox[{0, 0}, 1, {9.710377292913906, 12.566370614359172`}]}}, {
    InsetBox["1", {0.5047521196987089, 0.32438449047335827`}], 
    InsetBox["2", {-0.24924900780113202`, 0.545779197212711}], 
    InsetBox["3", {-0.6, 2.2043642384652356`*^-16}], 
    InsetBox["4", {0.08538890296397025, -0.5938928651285598}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 ImageSize->{364, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->34939301]
}, Open  ]],

Cell["Alternate red and thick edges:", "ExampleText",
 CellID->1065777963],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.2", ",", "0.3", ",", "0.1", ",", "0.5"}], "}"}], ",", " ", 
   RowBox[{"PieEdgeStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", " ", "Thick"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->470108648],

Cell[BoxData[
 GraphicsBox[{{
    {Hue[0.67, 0.35, 0.75], EdgeForm[RGBColor[1, 0, 0]], 
     DiskBox[{0, 0}, 1, {6.283185307179586, 7.425582635757693}]}, 
    {Hue[0.9060679774997897, 0.35, 0.75], EdgeForm[Thickness[Large]], 
     DiskBox[{0, 0}, 1, {7.425582635757693, 9.139178628624853}]}, 
    {Hue[0.1421359549995791, 0.35, 0.75], EdgeForm[RGBColor[1, 0, 0]], 
     DiskBox[{0, 0}, 1, {9.139178628624853, 9.710377292913906}]}, 
    {Hue[0.37820393249936846`, 0.35, 0.75], EdgeForm[Thickness[Large]], 
     DiskBox[{0, 0}, 1, {9.710377292913906, 12.566370614359172`}]}}, {
    InsetBox["1", {0.5047521196987089, 0.32438449047335827`}], 
    InsetBox["2", {-0.24924900780113202`, 0.545779197212711}], 
    InsetBox["3", {-0.6, 2.2043642384652356`*^-16}], 
    InsetBox["4", {0.08538890296397025, -0.5938928651285598}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 ImageSize->{364, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->315508775]
}, Open  ]],

Cell["Use thick red edges:", "ExampleText",
 CellID->426111909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.2", ",", "0.3", ",", "0.1", ",", "0.5"}], "}"}], ",", " ", 
   RowBox[{"PieEdgeStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", " ", "Thick"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1952375465],

Cell[BoxData[
 GraphicsBox[{{
    {Hue[0.67, 0.35, 0.75], EdgeForm[{RGBColor[1, 0, 0], Thickness[Large]}], 
     DiskBox[{0, 0}, 1, {6.283185307179586, 7.425582635757693}]}, 
    {Hue[0.9060679774997897, 0.35, 0.75], EdgeForm[{RGBColor[1, 0, 0], 
     Thickness[Large]}], 
     DiskBox[{0, 0}, 1, {7.425582635757693, 9.139178628624853}]}, 
    {Hue[0.1421359549995791, 0.35, 0.75], EdgeForm[{RGBColor[1, 0, 0], 
     Thickness[Large]}], 
     DiskBox[{0, 0}, 1, {9.139178628624853, 9.710377292913906}]}, 
    {Hue[0.37820393249936846`, 0.35, 0.75], EdgeForm[{RGBColor[1, 0, 0], 
     Thickness[Large]}], 
     DiskBox[{0, 0}, 1, {9.710377292913906, 12.566370614359172`}]}}, {
    InsetBox["1", {0.5047521196987089, 0.32438449047335827`}], 
    InsetBox["2", {-0.24924900780113202`, 0.545779197212711}], 
    InsetBox["3", {-0.6, 2.2043642384652356`*^-16}], 
    InsetBox["4", {0.08538890296397025, -0.5938928651285598}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 ImageSize->{364, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->54465516]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13693],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PieChart",
    BaseStyle->"Link",
    ButtonData->"paclet:PieCharts/ref/PieChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PieStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:PieCharts/ref/PieStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Thickness",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Thickness"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14522]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PieEdgeStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 46.8612166}", "context" -> "PieCharts`", 
    "keywords" -> {}, "index" -> True, "label" -> "Pie Charts Package Symbol",
     "language" -> "en", "paclet" -> "PieCharts Package", "status" -> "None", 
    "summary" -> 
    "PieEdgeStyle is an option for PieChart that specifies the styles for \
lines in the pie chart.", "synonyms" -> {}, "title" -> "PieEdgeStyle", "type" -> 
    "Symbol", "uri" -> "PieCharts/ref/PieEdgeStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3558, 119, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->267403997]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17836, 595}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 789, 18, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1412, 45, 49, 1, 70, "ObjectName",
 CellID->4335],
Cell[1464, 48, 527, 15, 70, "Usage",
 CellID->24636]
}, Open  ]],
Cell[CellGroupData[{
Cell[2028, 68, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2506, 85, 67, 1, 70, "Notes",
 CellID->8468],
Cell[2576, 88, 945, 26, 70, "2ColumnTableMod",
 CellID->19711]
}, Closed]],
Cell[CellGroupData[{
Cell[3558, 119, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->267403997],
Cell[CellGroupData[{
Cell[3943, 133, 147, 5, 70, "ExampleSection",
 CellID->76693042],
Cell[4093, 140, 131, 3, 70, "Input",
 CellID->18196036],
Cell[4227, 145, 132, 4, 70, "ExampleText",
 CellID->615400351],
Cell[CellGroupData[{
Cell[4384, 153, 258, 7, 28, "Input",
 CellID->369124514],
Cell[4645, 162, 1868, 57, 380, "Output",
 CellID->38158906]
}, Open  ]],
Cell[6528, 222, 64, 1, 70, "ExampleText",
 CellID->752455305],
Cell[CellGroupData[{
Cell[6617, 227, 253, 7, 70, "Input",
 CellID->114795318],
Cell[6873, 236, 1836, 57, 380, "Output",
 CellID->23202484]
}, Open  ]],
Cell[8724, 296, 58, 1, 70, "ExampleText",
 CellID->2132597599],
Cell[CellGroupData[{
Cell[8807, 301, 252, 7, 70, "Input",
 CellID->924594620],
Cell[9062, 310, 1888, 57, 380, "Output",
 CellID->34939301]
}, Open  ]],
Cell[10965, 370, 74, 1, 70, "ExampleText",
 CellID->1065777963],
Cell[CellGroupData[{
Cell[11064, 375, 312, 9, 70, "Input",
 CellID->470108648],
Cell[11379, 386, 1887, 57, 380, "Output",
 CellID->315508775]
}, Open  ]],
Cell[13281, 446, 63, 1, 70, "ExampleText",
 CellID->426111909],
Cell[CellGroupData[{
Cell[13369, 451, 326, 9, 70, "Input",
 CellID->1952375465],
Cell[13698, 462, 1986, 60, 380, "Output",
 CellID->54465516]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15745, 529, 311, 9, 70, "SeeAlsoSection",
 CellID->13693],
Cell[16059, 540, 718, 26, 70, "SeeAlso",
 CellID->14522]
}, Open  ]],
Cell[16792, 569, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

