(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21762,        542]
NotebookOptionsPosition[     19148,        455]
NotebookOutlinePosition[     20430,        492]
CellTagsIndexPosition[     20345,        487]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PLOT LEGENDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Legend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/Legend"], 
         "PlotLegend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/PlotLegend"], 
         "LegendBorder" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/LegendBorder"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"Legend\"\>", 
      2->"\<\"PlotLegend\"\>", 3->"\<\"LegendBorder\"\>"}, "\<\"see also\"\>",
       
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LegendBackground", "ObjectName",
 CellID->17208],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["LegendBackground"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Legend",
       BaseStyle->"Link",
       ButtonData->"paclet:PlotLegends/ref/Legend"]], "InlineFormula"],
     ", which specifies the style of background to use with a legend.  "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32105]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["LegendBackground"], "InlineFormula"],
 " sets ",
 Cell[BoxData[
  ButtonBox["ShadowForeground",
   BaseStyle->"Link",
   ButtonData->"paclet:PlotLegends/ref/ShadowForeground"]], "InlineFormula"],
 " and will override any value passed to ",
 Cell[BoxData[
  ButtonBox["ShadowForeground",
   BaseStyle->"Link",
   ButtonData->"paclet:PlotLegends/ref/ShadowForeground"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->29150],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"LegendBackground", "->", 
   StyleBox["style", "TI"]}]], "InlineFormula"],
 " specifies that the legend background is created with the specified \
graphics directive or list of directives."
}], "Notes",
 CellID->5269]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->483060355],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->487615117],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->114536065],

Cell["Use a white background for the legend:", "ExampleText",
 CellID->1239353001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", " ", 
   
   RowBox[{"LegendBackground", "\[Rule]", "White"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->216563026],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->889293799]
}, Open  ]],

Cell["Use a yellow background for the legend:", "ExampleText",
 CellID->1361995554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", " ", 
   
   RowBox[{"LegendBackground", "\[Rule]", "Yellow"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1031082705],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->323604277]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23919],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Legend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/Legend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotLegend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/PlotLegend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendBorder",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/LegendBorder"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14589]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LegendBackground - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 48.1581248}", "context" -> "PlotLegends`",
     "keywords" -> {}, "index" -> True, "label" -> 
    "Plot Legends Package Symbol", "language" -> "en", "paclet" -> 
    "PlotLegends Package", "status" -> "None", "summary" -> 
    "LegendBackground is an option for Legend, which specifies the style of \
background to use with a legend. ", "synonyms" -> {}, "title" -> 
    "LegendBackground", "type" -> "Symbol", "uri" -> 
    "PlotLegends/ref/LegendBackground"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3318, 115, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->483060355]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20202, 480}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 833, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1456, 47, 54, 1, 70, "ObjectName",
 CellID->17208],
Cell[1513, 50, 540, 15, 70, "Usage",
 CellID->32105]
}, Open  ]],
Cell[CellGroupData[{
Cell[2090, 70, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2568, 87, 451, 14, 70, "Notes",
 CellID->29150],
Cell[3022, 103, 259, 7, 70, "Notes",
 CellID->5269]
}, Closed]],
Cell[CellGroupData[{
Cell[3318, 115, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->483060355],
Cell[CellGroupData[{
Cell[3703, 129, 148, 5, 70, "ExampleSection",
 CellID->487615117],
Cell[3854, 136, 134, 3, 70, "Input",
 CellID->114536065],
Cell[3991, 141, 82, 1, 70, "ExampleText",
 CellID->1239353001],
Cell[CellGroupData[{
Cell[4098, 146, 536, 16, 47, "Input",
 CellID->216563026],
Cell[4637, 164, 6329, 108, 265, "Output",
 Evaluatable->False,
 CellID->889293799]
}, Open  ]],
Cell[10981, 275, 83, 1, 70, "ExampleText",
 CellID->1361995554],
Cell[CellGroupData[{
Cell[11089, 280, 538, 16, 47, "Input",
 CellID->1031082705],
Cell[11630, 298, 6361, 108, 265, "Output",
 Evaluatable->False,
 CellID->323604277]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18052, 413, 311, 9, 70, "SeeAlsoSection",
 CellID->23919],
Cell[18366, 424, 740, 26, 70, "SeeAlso",
 CellID->14589]
}, Open  ]],
Cell[19121, 453, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

