(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22813,        568]
NotebookOptionsPosition[     20214,        482]
NotebookOutlinePosition[     21472,        518]
CellTagsIndexPosition[     21387,        513]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PLOT LEGENDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Legend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/Legend"], 
         "PlotLegend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/PlotLegend"], 
         "LegendLabel" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/LegendLabel"], 
         "LegendBorderSpace" :> 
         Documentation`HelpLookup[
          "paclet:PlotLegends/ref/LegendBorderSpace"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Legend\"\>", 2->"\<\"PlotLegend\"\>", 
      3->"\<\"LegendLabel\"\>", 
      4->"\<\"LegendBorderSpace\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LegendLabelSpace", "ObjectName",
 CellID->22933],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["LegendLabelSpace"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Legend",
       BaseStyle->"Link",
       ButtonData->"paclet:PlotLegends/ref/Legend"]], "InlineFormula"],
     ", which specifies the space for ",
     Cell[BoxData[
      ButtonBox["LegendLabel",
       BaseStyle->"Link",
       ButtonData->"paclet:PlotLegends/ref/LegendLabel"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18483]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be given:", "Notes",
 CellID->7226],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["s", "TI"], Cell[TextData[{
     "a number giving the ratio of a key box size (see ",
     Cell[BoxData[
      ButtonBox["LegendTextSpace",
       BaseStyle->"Link",
       ButtonData->"paclet:PlotLegends/ref/LegendTextSpace"]], 
      "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "determine the space automatically", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->22574]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->177998750],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->239401342],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->144934169],

Cell["\<\
Allow an automatic amount of space around the legend's label:\
\>", "ExampleText",
 CellID->1945460557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", " ", 
   
   RowBox[{"LegendLabelSpace", "\[Rule]", "Automatic"}], ",", " ", 
   RowBox[{"LegendLabel", "\[Rule]", "\"\<Curves\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->216563026],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->253949070]
}, Open  ]],

Cell["Tighten the space around the legend's label:", "ExampleText",
 CellID->586211278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", " ", 
   
   RowBox[{"LegendLabelSpace", "\[Rule]", 
    RowBox[{"1", "/", "3"}]}], ",", " ", 
   RowBox[{"LegendLabel", "\[Rule]", "\"\<Curves\>\""}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1657977728],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->144614666]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27202],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Legend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/Legend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotLegend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/PlotLegend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendLabel",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/LegendLabel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendBorderSpace",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/LegendBorderSpace"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14589]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LegendLabelSpace - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 55.7520692}", "context" -> "PlotLegends`",
     "keywords" -> {}, "index" -> True, "label" -> 
    "Plot Legends Package Symbol", "language" -> "en", "paclet" -> 
    "PlotLegends Package", "status" -> "None", "summary" -> 
    "LegendLabelSpace is an option for Legend, which specifies the space for \
LegendLabel. ", "synonyms" -> {}, "title" -> "LegendLabelSpace", "type" -> 
    "Symbol", "uri" -> "PlotLegends/ref/LegendLabelSpace"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3745, 125, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->177998750]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21244, 506}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 985, 23, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1608, 50, 54, 1, 70, "ObjectName",
 CellID->22933],
Cell[1665, 53, 671, 20, 70, "Usage",
 CellID->18483]
}, Open  ]],
Cell[CellGroupData[{
Cell[2373, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2851, 95, 68, 1, 70, "Notes",
 CellID->7226],
Cell[2922, 98, 786, 22, 70, "2ColumnTableMod",
 CellID->22574]
}, Closed]],
Cell[CellGroupData[{
Cell[3745, 125, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->177998750],
Cell[CellGroupData[{
Cell[4130, 139, 148, 5, 70, "ExampleSection",
 CellID->239401342],
Cell[4281, 146, 134, 3, 70, "Input",
 CellID->144934169],
Cell[4418, 151, 113, 3, 70, "ExampleText",
 CellID->1945460557],
Cell[CellGroupData[{
Cell[4556, 158, 608, 17, 47, "Input",
 CellID->216563026],
Cell[5167, 177, 6398, 109, 265, "Output",
 Evaluatable->False,
 CellID->253949070]
}, Open  ]],
Cell[11580, 289, 87, 1, 70, "ExampleText",
 CellID->586211278],
Cell[CellGroupData[{
Cell[11692, 294, 626, 18, 47, "Input",
 CellID->1657977728],
Cell[12321, 314, 6463, 110, 265, "Output",
 Evaluatable->False,
 CellID->144614666]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18845, 431, 311, 9, 70, "SeeAlsoSection",
 CellID->27202],
Cell[19159, 442, 1013, 35, 70, "SeeAlso",
 CellID->14589]
}, Open  ]],
Cell[20187, 480, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

