(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21973,        544]
NotebookOptionsPosition[     19349,        457]
NotebookOutlinePosition[     20635,        494]
CellTagsIndexPosition[     20550,        489]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PLOT LEGENDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Legend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/Legend"], 
         "PlotLegend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/PlotLegend"], 
         "LegendPosition" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/LegendPosition"], 
         "LegendSize" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/LegendSize"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"Legend\"\>", 
      2->"\<\"PlotLegend\"\>", 3->"\<\"LegendPosition\"\>", 
      4->"\<\"LegendSize\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LegendOrientation", "ObjectName",
 CellID->11362],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["LegendOrientation"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Legend",
       BaseStyle->"Link",
       ButtonData->"paclet:PlotLegends/ref/Legend"]], "InlineFormula"],
     ", which specifies the direction in which key boxes are laid out. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18694]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be given:", "Notes",
 CellID->21057],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "Horizontal", Cell[
    "left to right", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Vertical", Cell[
    "top to bottom", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->24592]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->44968456],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->441648594],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->49309769],

Cell["Legend keys are next to each other:", "ExampleText",
 CellID->101273690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", " ", 
   
   RowBox[{"LegendOrientation", "\[Rule]", "Horizontal"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->216563026],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXHuMFdUZH/beuyssC4vswi6P3eW9wArL8hIEdldggSolaggxagsSI7RV
imKaYnR91bURY9U2SmvdWBTjoxFjQ2tCi9FoJbGSGAlGTaimRptIbKRKSUlu
f9/5zplv7rdn7syg9i82l8s5c+Z+79d5zKzdtGPLNddt2rF186aWVTds+vGW
rZtvbOnZdgMu5QYFwaAtQRD8uyFAu4iW+Ud/W/GPm7pVje87cNv731qvgr5z
J0+e7Ovr6+3tDSrxpUePHTtWW1tLo730lWtvbw/4r3LgnS0tLdTsNf2NGzee
vfPsnWfvPHvn2Tu/pTurTP/48S+3Xf8iPsFo+sq9/95nRfMXNJvxd/cfevH6
X+ETjKKv3OsP7rPjLakxnWP6R9759PBbH+MTjMLXRHPt1ImvPn7rfXyCUfSV
++KT45mh/7+kuIyuFUKK8QG1wUpczRFTEcmtTQ1zEV2r/PzDf779zMv7d+ze
u/7O3Uu396/ZmSNZV3IX3xh687E/ffbePxbT/Xno7I/7371v16ubr36uonPp
7hxprgodtPHZumXf7kcOvfrKsVOnTgdrUtOywBgFeDr0yB+A8+kr+qDrj944
SlxWuTH0QclzV+/as+7WV3c9C8qDeWYMuP584AMQcsm6PX13v/zCviOQB2u+
Epp/8onDN+98aeXyR/EN2lelpspAL0DYB277Hag6/MQBome4ufrl8S+O7HsN
hEJaZD7t5uqJE6f6H3tzw/q9t992gBRTa65CHCALxD37zNsklxWpKegwMgen
0AIQfXDgrXpzBRjZMz595+9tbBunTjNmfENHQZ3T1kMPvo6rwLw8NVbDSx7W
BiVA3JB7o8O6b8svXr77KTA/3Vw59MZHUD1QgvGGCMarrngagu9OjXG2+S2Y
gUBhjqdP/XeciwC4AraDqeYOoIEkb9qx/8MPPzd35NFgm4MAOlPjm2WuwdjA
D5jheEMcQ9PgD/gnubgBVmA0NibAlMAvrrJHpsLV5qIN1AUTCiY5ziBasuEJ
DjL4IM1xdAJfMGiYcrA0NaaZ5hpcFTIjm5xi+sABLqHEoIkpOXUa1gmJ2XH0
4c74BEtSY5rB97zytpXfNMcj7BScBaw9aAs8wTWDVtMHN1AdrgaLU2Oa7qT1
0s7HoBaLGTqCKKlpLDP3ySdfQC/k9TwOu4T0CNOi1JiYRkQYAKdmm7MR2x9t
+sAByMBnx7lPejs/NSaSVgUQzXa8WQz1CsMs14cUqb8wNYapFsMchWFkBANJ
p91Jz2JckBoD2w6UAAFRs0NhGqEwdShM81NjmmyuIQbAN6k5T2EeriDPc/4D
qRHmeakxsWfCU6ytLXAWYG2txlk1bC2UFsUIYKa4Pjc1ponOUxET4DVsOzmg
hUtRs9p5JlIWbNmOI4+gH0o7FSaOLshbiDaEyfhDDtxx8rCYEFQR5KjJ40gX
iOLUnJMaU4uLAYgJFNcuMH1EB/Qpbw4mm0SqMFEmB/BAQs32jBg44VJziZMi
MJC+uKpEvEF8o6aJnFSgIBVTc3ZqTM1K88uKNt5BRdQsRDyTNL9MWUZ6TE0K
cpfpI/EiDZqm+UJ8sTGgS9ncrNSYxitL6FaWwJgQoGFw1OxWlnBeakzjFGRT
eVSGmNFjqKYOysGkYdhFF3EzYBApGUgFlqJoZYXzImgF8SAD/LFKKz3sf/c/
f/OlDxCkHhdjAJkwzUwNeYzzCuRo0oKpRnP33PWXx6+8l2TFfTgjXJKaM7yQ
qdaqCPh6gUDnzW30Z0emR+7Q//t/0RBLrXic4bvAcQj6BA/kd0wznA6uR83p
XpoNrMrArh/ahcTA3Rd2meNCeJ+9WhF/NfJb3R/j4YkqBsqNhupKrhzguehx
9lrlPA7XKa/7uXEayCVQQPe0xtOelzvTwfJpia/BehAHqckcSNxjOGANDEas
OcwmrbEcOuwhlCFReqNa5O8ynEb4yKeA5OOTKzBYnK2ciU/KKAYeZR7YI1Wj
zL/ktGle/hqtBlns/Bfti+REBq3Km3JnAGN0LGeSb1hDiPKIZEakpo/KBPW1
jMNqMTshG/Vz2OvBNMpck5zJkBDDgInqZ86hKLVQcAkmpAQkBmpO9WIar3hc
qvrNHkrqnTZBCegJtckrNtAjtCzaxPwE0wdqTknNK2OQSlFH7cGmL5VlKAtI
lXJtekxmtk0zLdAsEREihQqNsXulCveEk1JzckZMEBncXSBBNBAQNasTpDcp
NSaeKyDB8rKbxQRr27B+L0mvxis9scn0mM4113Q+kUpkmOnD9OEAgkly5MSM
mKTOZkhSMQ73UiKRdEJqTDz/0RWESIfGwywUscn0GGqd/4BWqq8ZktTVI7zj
mPc/+cRharZkwiS0Sn010suj+E96DMO9/iNyr/PqTaJSc0ZM2pYkF9Z7LUBq
1KbUmIbFSQf+QxYwukSq4lfpMdQ4De9df6f4umg4zJcRC6AImxWDzkvQLTRM
tDYm8Dg+NaahXgsQuY9J8NxxGTFpSGIBXPsjI4ESajIlvLwUjqfCxLGY12pL
pGPnI5w1ZRbT4/wL42eCCQSDbIEkczfGpGcdUrGPSY2JM5ms82iNG08skzXS
YxrstW6Jb80x1p0Ng88DJyRYdWNqDGEtAx58MyVeB9LZXKy6ISMmXeOLLU1K
sOrRqTFVeSFJtp7spUT8KysmNfuMQJrila7EjFGpMVUqjWvpTE3w1KyY4j01
XEkvmcuIxdSnxsRzBk91a614eoKnpseU93oqkhBSETWnJ3hyXUZM8TTPjBtH
vqK14PSYcgk0tyXocWRGTDrHCk/nKdvUekyPqSLBX2Z5eZI6+9yMmOL9hXc+
JDNqfxuRGpMxibBc0xzx/kZ8rs+Ah9TEgCy1Un3yLkt8bK3NgCUeSkcCL1mw
xEOZm8DL8AxYGAQNrXQ2ayuf+Qn2kYClv7+fmoUEH5yfYO/DUmHJJ/jfwgRe
smCJ52VhAi81qbDkEnhZlMBLFizxvDCW+PW6oamw8LjEeqrmaDmV1o9p6Wmo
4q3Z9INwTapR/X6Y/R3F24owU0scLkNVVUgV/iRnVEcwBhZylAK3I9bipUzg
jFDjfPZC+o5WyU7VpbQ2NDQcPHgw6KWvytWrV4e0Mvc1Cn6b6p+jJNFkJT1W
SbA2JZ0CKUrnyZMnIcaurq5gPr4IzEzqUKPL/AVj6Ktw9OjREikP82Al/VUr
mTQpbYS7VBZOMvVVCqKZC/FZhsjvZqr+OI+dRcdnJEi7xfIzXsGpsdfbrN3q
36WjjnUovjh0ANfaarUUSumT1fk0VkXW76dzRglUiUiO65mW68GK64le6UvE
c793Xs5Skygx2EvNatPX0VdkcGGxfMQ7pwxUT7S162vLFe06WvuhrvLSKpli
RQKtVWWgxmeGlQm0KqgYkLviae1JoNXEE5PnyVI7XOUpeKLYI9xUJvS/7v0m
A+ZlFdHZ2TeHIel+Q0EhlCQLaAAV3zTfXiryoj/nr98chjQUD0J3EP1fLLEN
NqMBcV9D0ONmrp+XCtrtKsRDaEwY5/wnu0F6xzCJoqzjXJ/J7GvI14R3hjrI
cxxgF9V5idfhZR5Sp8b1/SwzmadMU+NcY4nWtB3q7HRuKZ34n1fllis4ev50
kaJ7rcCRfXF7VrFb3avnWhcrXBf7YDFqCyuerrUKVwSWnMkISetMoOy7CttF
MdAYf2cCbescNrsnLdByLqJHcPOpL70XLrtOl5i+ZKrvCG0D7EVoYKjxmYah
SqbyQ9VnqHg8PitepmhdUwaq5NrFCbRepmj1Q+UZp+Ta8xNoXa9oXV0GqtB6
fgKt6x2tdmfCD7WgaOWTl/FrmxtMX2rlVWWgyt4rrxfEr2Nu8I0PgKrnYvMU
LXp973LfeGj9esY010ujYLtcjfd4adQ1fEcCjVeYvuz6rCwDVX41R+lWz/Ov
VLaxwguVaxbZ1WxXdqgr0auUHZeDKhYzW/mMrkS/p2hd7oU6WFn3rARav69o
LQdVaOUZmd4rlQi50fRlj/tCL1TO+rLXxBkwPkpvMn3JCX6o1YqWGepXmtar
FdbuEuuvVjTMUJzp/bLNpi91d7eXRl4ZktMFrUoLOppco7TYVQaq6LZVWYyO
fNcoi/NDrVF2yDtROvLJDse1xVJP7iwDVSIf76TFR5Vr1bgf6jD1q8mKlh6F
1TwvHokqy8pAlagyycmt5ISTSOgHSu5LvVD5HIjE9olKx9pTf6hspBxUsZwJ
Ssfa+n+k7HlJifXXKuvnGlafIpPx65SvLfHSOEJZf5P6la6ntjGWXc8e2fca
NS8oA1XkxVD1zrZY/zYnGZsb/FB5ZiWn18YlWP92ZXGLy0AVixrrtX7But2N
25OKfqgjFYd8YkXv64mEblQWxU8q0bzGe644cDu6GqPsqvA8U59dklOIO0xf
Yi0/sWRiqmedU9fK0q9Tdteg4Op9w5tMX/LVmeLlOaHa3/fNBKz3/aRY6tML
M+ClCRbLV047+U6sRuMd45O11Dh8BatjrU/mR2JSnbJmHT9/avpwSzgnNReU
wTewRtd4xY6Yb123idx3Fkt9e36J5VbZ/zUWPo0mqxz+s5hiVTcXbVyys0LG
or2ObU/OR3DMjD+TeEuRz/yUgybxZLjTeMwJu1vcuF3znueFyn4pkYEzmkRU
HRl6TV/WZ+Z6oXJ8kVzC9Yc8BRBybk923276ci6nowxUoaXaY/O0an+HsxGb
hQUaARur5DSk6D/teqfpSwUwx0vTWGWfXA/Hn7a+y/Qlq7Z7oXIukTP2PCPQ
p43kZPXPTF+iqx/qeMU5z9+0D0tM6SuW+vDsMlBFAgWvBGTd4R4lgVleqE1O
AvZZsvDMS0l8kzj+c6VzP9RmayG5GJ3fWyz10PNioQSVofWix5a9Sln1fcqq
27zQTOVU4J2Vr078J+bE9H2OfzsusAgU13K49eGrHqRnnPUpkPuLpV4700sJ
Q4FafnlpHz1XHlYw9mmjBxhqWDXMKMMPa+Jfn35urWKlsoIHHD8wBHoe3A/L
SLoqvAs90dVyx7ONXA85C7DPdE6PhxiJbxXKjrqV3RlxUeSC5MiaW8tZa+gp
nF+kSus0fXkG8+FiaWyZVsazBHfB2Rdoo+f8GapUy48o3qZ6oXJsgYTs8/Fc
YYTPmpnZA/nIr52G7JOSfmhj1V2DleXxk7aSOX/jtGT9dEqJHTM0mUUMUTpe
pLTzWychm1cme2mkvEHeXqN8is+tyNPY/cXSeDjJC61R6XqYsuz5zmvsU7GP
W+x+aJzVZdYQztLs09XznOWAY4ope5SOJ3ihcj0jT4uPUFA7FNQni6WRqsUL
dZSCGtb4bIJ29UugPqWgNnuh1iuo9REoROssBfVpBbXJC7XOydVCHa0k0Oa0
ZKE+4+wYeoBoY6CGzx3hLoLaGIFK78PgNSCO5QT1905b1qLGlVg7VZkVGBnn
oCBg0K5fq/MZ+9aA5x1W8EI171gvbbXOs+ALuNdGOpi6fcvBFNcHrdR/wfT5
PRlUH47xQmV7ROyFv5J/c46Atu27RiY67QAq0W4eZrPv9aB3ozR6oRpPzEOC
4WtOjHfkwW34xhSmH7pCNQJZBCacyHtQ0BjthT3UUYxMSe804d02fjsKWSm/
mwWaR2EOr0XDBCb7Phc6QznKC9fEIto3hxYQ7NDgUzj8NhQAA/H8nhkQD3Qg
G3W/SZR5MIhfIYmhdKnzQjcVXh7D/D4fkGFqjzxAYMaI5ARzMr+k9/hAibgI
MZEeD5r74D/QEJCAcd4fdKdQ9EzVN7szfXqHE7/WCpBId6biLSA3QnJQCxrh
vIPqFVgrqIDSqTYwZSg95c4/hwtRdOezknr/knfeo7NAky+ro7tz/D4p6A/w
+tfshMKpSjCxtQp212feWQS5Q9BQKuUCk8eq0AGd0AaGQTackmj+qxmDdOGK
e9bdCpNDQAZA8qbqDDSap9OpDofdEj28qwjsQAt1gJ6Vyx/tXLo7T2+eqrxo
TT/aaIJa6BFi+ptRNfwI6Jmx3Uu3gxp+/U5VFmnRHSCBfJJqq7x51xY/K07D
puygzIh7wiyfBba9Ql9tX/u3bv5dWfSvLsid1Ip/f2f2VjDofxWOlUA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->198755516]
}, Open  ]],

Cell["Legend keys are above one another:", "ExampleText",
 CellID->1299859406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", " ", 
   
   RowBox[{"LegendOrientation", "\[Rule]", "Vertical"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1344395520],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->263265413]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2232],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Legend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/Legend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotLegend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/PlotLegend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendPosition",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/LegendPosition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendSize",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/LegendSize"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14589]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LegendOrientation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 56.3927106}", "context" -> "PlotLegends`",
     "keywords" -> {}, "index" -> True, "label" -> 
    "Plot Legends Package Symbol", "language" -> "en", "paclet" -> 
    "PlotLegends Package", "status" -> "None", "summary" -> 
    "LegendOrientation is an option for Legend, which specifies the direction \
in which key boxes are laid out. ", "synonyms" -> {}, "title" -> 
    "LegendOrientation", "type" -> "Symbol", "uri" -> 
    "PlotLegends/ref/LegendOrientation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3249, 108, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->44968456]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20408, 482}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 963, 22, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1586, 49, 55, 1, 70, "ObjectName",
 CellID->11362],
Cell[1644, 52, 541, 15, 70, "Usage",
 CellID->18694]
}, Open  ]],
Cell[CellGroupData[{
Cell[2222, 72, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2700, 89, 69, 1, 70, "Notes",
 CellID->21057],
Cell[2772, 92, 440, 11, 70, "2ColumnTableMod",
 CellID->24592]
}, Closed]],
Cell[CellGroupData[{
Cell[3249, 108, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->44968456],
Cell[CellGroupData[{
Cell[3633, 122, 148, 5, 70, "ExampleSection",
 CellID->441648594],
Cell[3784, 129, 133, 3, 70, "Input",
 CellID->49309769],
Cell[3920, 134, 78, 1, 70, "ExampleText",
 CellID->101273690],
Cell[CellGroupData[{
Cell[4023, 139, 542, 16, 47, "Input",
 CellID->216563026],
Cell[4568, 157, 6369, 108, 265, "Output",
 Evaluatable->False,
 CellID->198755516]
}, Open  ]],
Cell[10952, 268, 78, 1, 70, "ExampleText",
 CellID->1299859406],
Cell[CellGroupData[{
Cell[11055, 273, 541, 16, 47, "Input",
 CellID->1344395520],
Cell[11599, 291, 6329, 108, 265, "Output",
 Evaluatable->False,
 CellID->263265413]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17989, 406, 310, 9, 70, "SeeAlsoSection",
 CellID->2232],
Cell[18302, 417, 1005, 35, 70, "SeeAlso",
 CellID->14589]
}, Open  ]],
Cell[19322, 455, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

