(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14510,        419]
NotebookOptionsPosition[     12138,        341]
NotebookOutlinePosition[     13427,        378]
CellTagsIndexPosition[     13342,        373]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PLOT LEGENDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Legend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/Legend"], 
         "LegendSize" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/LegendSize"], 
         "LegendShadow" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/LegendShadow"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"Legend\"\>", 
      2->"\<\"LegendSize\"\>", 3->"\<\"LegendShadow\"\>"}, "\<\"see also\"\>",
       
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LegendPosition", "ObjectName",
 CellID->2821],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["LegendPosition"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Legend",
       BaseStyle->"Link",
       ButtonData->"paclet:PlotLegends/ref/Legend"]], "InlineFormula"],
     ", which specifies the location of the lower\[Dash]left corner of a \
legend box. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2902]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Places the lower\[Hyphen]left corner of a legend box in a position \
specified by a coordinate system scaled so the center of the graphic is at ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", " ", "0"}], "}"}]], "InlineFormula"],
 ", and the longest side of the graphic runs from ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " to ",
 Cell[BoxData["1"], "InlineFormula"],
 ". This same coordinate system is used for ",
 Cell[BoxData[
  ButtonBox["LegendSize",
   BaseStyle->"Link",
   ButtonData->"paclet:PlotLegends/ref/LegendSize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LegendShadow",
   BaseStyle->"Link",
   ButtonData->"paclet:PlotLegends/ref/LegendShadow"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9271],

Cell[TextData[{
 "If called from ",
 Cell[BoxData[
  ButtonBox["ShowLegend",
   BaseStyle->"Link",
   ButtonData->"paclet:PlotLegends/ref/ShowLegend"]], "InlineFormula"],
 ", the position will be in the coordinate system, with the graphic centered \
at ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["0", "TR"], ",", 
    StyleBox["0", "TR"]}], "}"}]], "InlineFormula"],
 " and scaled to fit inside ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", 
       StyleBox["1", "TR"]}], ",", 
      RowBox[{"-", 
       StyleBox["1", "TR"]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["1", "TR"], ",", 
      StyleBox["1", "TR"]}], "}"}]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17601]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->31758563],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->989041212],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->880362166],

Cell["Legend placed in the bottom-right corner:", "ExampleText",
 CellID->531488599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", " ", 
   
   RowBox[{"LegendPosition", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.8", ",", 
      RowBox[{"-", "0.8"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->216563026],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 199},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->521008115]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2107],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Legend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/Legend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendSize",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/LegendSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendShadow",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/LegendShadow"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21329]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LegendPosition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 56.7989710}", "context" -> "PlotLegends`",
     "keywords" -> {}, "index" -> True, "label" -> 
    "Plot Legends Package Symbol", "language" -> "en", "paclet" -> 
    "PlotLegends Package", "status" -> "None", "summary" -> 
    "LegendPosition is an option for Legend, which specifies the location of \
the lower\\[Dash]left corner of a legend box. ", "synonyms" -> {}, "title" -> 
    "LegendPosition", "type" -> "Symbol", "uri" -> 
    "PlotLegends/ref/LegendPosition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4165, 147, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->31758563]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13200, 366}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 833, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1456, 47, 51, 1, 70, "ObjectName",
 CellID->2821],
Cell[1510, 50, 553, 16, 70, "Usage",
 CellID->2902]
}, Open  ]],
Cell[CellGroupData[{
Cell[2100, 71, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2578, 88, 775, 23, 70, "Notes",
 CellID->9271],
Cell[3356, 113, 772, 29, 70, "Notes",
 CellID->17601]
}, Closed]],
Cell[CellGroupData[{
Cell[4165, 147, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->31758563],
Cell[CellGroupData[{
Cell[4549, 161, 148, 5, 70, "ExampleSection",
 CellID->989041212],
Cell[4700, 168, 134, 3, 70, "Input",
 CellID->880362166],
Cell[4837, 173, 84, 1, 70, "ExampleText",
 CellID->531488599],
Cell[CellGroupData[{
Cell[4946, 178, 607, 19, 47, "Input",
 CellID->216563026],
Cell[5556, 199, 5426, 93, 220, "Output",
 Evaluatable->False,
 CellID->521008115]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11043, 299, 310, 9, 70, "SeeAlsoSection",
 CellID->2107],
Cell[11356, 310, 740, 26, 70, "SeeAlso",
 CellID->21329]
}, Open  ]],
Cell[12111, 339, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

