(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29296,        697]
NotebookOptionsPosition[     26462,        602]
NotebookOutlinePosition[     27714,        638]
CellTagsIndexPosition[     27629,        633]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PLOT LEGENDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Legend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/Legend"], 
         "PlotLegend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/PlotLegend"], 
         "ShadowBox" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/ShadowBox"], 
         "LegendBackground" :> 
         Documentation`HelpLookup[
          "paclet:PlotLegends/ref/LegendBackground"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Legend\"\>", 2->"\<\"PlotLegend\"\>", 
      3->"\<\"ShadowBox\"\>", 
      4->"\<\"LegendBackground\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LegendShadow", "ObjectName",
 CellID->27853],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["LegendShadow"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Legend",
       BaseStyle->"Link",
       ButtonData->"paclet:PlotLegends/ref/Legend"]], "InlineFormula"],
     " which specifies the shadowing drawn around the legend."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16602]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be used:", "Notes",
 CellID->12008],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "no shadow is drawn, and a transparent backdrop is used", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "a shadow is placed automatically", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["xoffset", "TI"], ",", 
      StyleBox["yoffset", "TI"]}], "}"}], Cell[
    "specifies offset of shadow from the box", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->12178]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->410248819],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->656981722],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->18981501],

Cell["Don't draw a shadow for the legend:", "ExampleText",
 CellID->393080539],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", " ", 
   
   RowBox[{"LegendShadow", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->216563026],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 236},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->246118485]
}, Open  ]],

Cell["Use the default shadow:", "ExampleText",
 CellID->844920801],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", " ", 
   
   RowBox[{"LegendShadow", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1784127448],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->292189017]
}, Open  ]],

Cell["Place the shadow below and to the left of the legend:", "ExampleText",
 CellID->1422028443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", " ", 
   
   RowBox[{"LegendShadow", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "0.1"}], ",", 
      RowBox[{"-", "0.1"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->686534038],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 242},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->701729497]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23976],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Legend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/Legend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotLegend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/PlotLegend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShadowBox",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/ShadowBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendBackground",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/LegendBackground"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13801]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LegendShadow - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 57.1271044}", "context" -> "PlotLegends`",
     "keywords" -> {}, "index" -> True, "label" -> 
    "Plot Legends Package Symbol", "language" -> "en", "paclet" -> 
    "PlotLegends Package", "status" -> "None", "summary" -> 
    "LegendShadow is an option for Legend which specifies the shadowing drawn \
around the legend.", "synonyms" -> {}, "title" -> "LegendShadow", "type" -> 
    "Symbol", "uri" -> "PlotLegends/ref/LegendShadow"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3683, 121, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->410248819]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27486, 626}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 976, 23, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1599, 50, 50, 1, 70, "ObjectName",
 CellID->27853],
Cell[1652, 53, 526, 15, 70, "Usage",
 CellID->16602]
}, Open  ]],
Cell[CellGroupData[{
Cell[2215, 73, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2693, 90, 68, 1, 70, "Notes",
 CellID->12008],
Cell[2764, 93, 882, 23, 70, "2ColumnTableMod",
 CellID->12178]
}, Closed]],
Cell[CellGroupData[{
Cell[3683, 121, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->410248819],
Cell[CellGroupData[{
Cell[4068, 135, 148, 5, 70, "ExampleSection",
 CellID->656981722],
Cell[4219, 142, 133, 3, 70, "Input",
 CellID->18981501],
Cell[4355, 147, 78, 1, 70, "ExampleText",
 CellID->393080539],
Cell[CellGroupData[{
Cell[4458, 152, 531, 16, 47, "Input",
 CellID->216563026],
Cell[4992, 170, 6227, 106, 257, "Output",
 Evaluatable->False,
 CellID->246118485]
}, Open  ]],
Cell[11234, 279, 66, 1, 70, "ExampleText",
 CellID->844920801],
Cell[CellGroupData[{
Cell[11325, 284, 537, 16, 47, "Input",
 CellID->1784127448],
Cell[11865, 302, 6329, 108, 265, "Output",
 Evaluatable->False,
 CellID->292189017]
}, Open  ]],
Cell[18209, 413, 97, 1, 70, "ExampleText",
 CellID->1422028443],
Cell[CellGroupData[{
Cell[18331, 418, 627, 20, 47, "Input",
 CellID->686534038],
Cell[18961, 440, 6077, 104, 263, "Output",
 Evaluatable->False,
 CellID->701729497]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25099, 551, 311, 9, 70, "SeeAlsoSection",
 CellID->23976],
Cell[25413, 562, 1007, 35, 70, "SeeAlso",
 CellID->13801]
}, Open  ]],
Cell[26435, 600, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

