(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22896,        567]
NotebookOptionsPosition[     20268,        480]
NotebookOutlinePosition[     21558,        517]
CellTagsIndexPosition[     21473,        512]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PLOT LEGENDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Legend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/Legend"], 
         "PlotLegend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/PlotLegend"], 
         "LegendTextOffset" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/LegendTextOffset"], 
         "LegendTextSpace" :> 
         Documentation`HelpLookup[
          "paclet:PlotLegends/ref/LegendTextSpace"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Legend\"\>", 2->"\<\"PlotLegend\"\>", 
      3->"\<\"LegendTextOffset\"\>", 
      4->"\<\"LegendTextSpace\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LegendTextDirection", "ObjectName",
 CellID->32213],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["LegendTextDirection"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Legend",
       BaseStyle->"Link",
       ButtonData->"paclet:PlotLegends/ref/Legend"]], "InlineFormula"],
     ", which specifies the direction of text next to the key box. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3062]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be given:", "Notes",
 CellID->14981],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "automatically determine directions (default)", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["dir", "TI"], Cell[TextData[{
     "the same settings used in the ",
     Cell[BoxData[
      ButtonBox["Text",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Text"]], "InlineFormula"],
     " graphics primitive"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->20276]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->201068339],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->585488183],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->98345631],

Cell["Normally oriented text in the legend:", "ExampleText",
 CellID->1870530212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", " ", 
   
   RowBox[{"LegendTextDirection", "\[Rule]", "Automatic"}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->216563026],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30064741]
}, Open  ]],

Cell["Legend text at a 45\[Degree] angle:", "ExampleText",
 CellID->1836595049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", " ", 
   
   RowBox[{"LegendTextDirection", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->427136203],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->368694741]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32427],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Legend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/Legend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotLegend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/PlotLegend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendTextOffset",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/LegendTextOffset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendTextSpace",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/LegendTextSpace"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31871]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LegendTextDirection - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 2.9397532}", "context" -> "PlotLegends`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Plot Legends Package Symbol", "language" -> "en", "paclet" -> 
    "PlotLegends Package", "status" -> "None", "summary" -> 
    "LegendTextDirection is an option for Legend, which specifies the \
direction of text next to the key box. ", "synonyms" -> {}, "title" -> 
    "LegendTextDirection", "type" -> "Symbol", "uri" -> 
    "PlotLegends/ref/LegendTextDirection"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3596, 119, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->201068339]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21330, 505}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 994, 23, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1617, 50, 57, 1, 70, "ObjectName",
 CellID->32213],
Cell[1677, 53, 538, 15, 70, "Usage",
 CellID->3062]
}, Open  ]],
Cell[CellGroupData[{
Cell[2252, 73, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2730, 90, 69, 1, 70, "Notes",
 CellID->14981],
Cell[2802, 93, 757, 21, 70, "2ColumnTableMod",
 CellID->20276]
}, Closed]],
Cell[CellGroupData[{
Cell[3596, 119, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->201068339],
Cell[CellGroupData[{
Cell[3981, 133, 148, 5, 70, "ExampleSection",
 CellID->585488183],
Cell[4132, 140, 133, 3, 70, "Input",
 CellID->98345631],
Cell[4268, 145, 81, 1, 70, "ExampleText",
 CellID->1870530212],
Cell[CellGroupData[{
Cell[4374, 150, 545, 17, 47, "Input",
 CellID->216563026],
Cell[4922, 169, 6328, 108, 265, "Output",
 Evaluatable->False,
 CellID->30064741]
}, Open  ]],
Cell[11265, 280, 79, 1, 70, "ExampleText",
 CellID->1836595049],
Cell[CellGroupData[{
Cell[11369, 285, 586, 18, 47, "Input",
 CellID->427136203],
Cell[11958, 305, 6874, 117, 265, "Output",
 Evaluatable->False,
 CellID->368694741]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18893, 429, 311, 9, 70, "SeeAlsoSection",
 CellID->32427],
Cell[19207, 440, 1019, 35, 70, "SeeAlso",
 CellID->31871]
}, Open  ]],
Cell[20241, 478, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

