(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15154,        417]
NotebookOptionsPosition[     12740,        338]
NotebookOutlinePosition[     14003,        374]
CellTagsIndexPosition[     13918,        369]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PLOT LEGENDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Legend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/Legend"], 
         "PlotLegend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/PlotLegend"], 
         "LegendTextOffset" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/LegendTextOffset"], 
         "LegendTextDirection" :> 
         Documentation`HelpLookup[
          "paclet:PlotLegends/ref/LegendTextDirection"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Legend\"\>", 2->"\<\"PlotLegend\"\>", 
      3->"\<\"LegendTextOffset\"\>", 
      4->"\<\"LegendTextDirection\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LegendTextSpace", "ObjectName",
 CellID->18987],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["LegendTextSpace"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Legend",
       BaseStyle->"Link",
       ButtonData->"paclet:PlotLegends/ref/Legend"]], "InlineFormula"],
     ", which specifies the space in the legend box for text."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8056]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be given:", "Notes",
 CellID->18518],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["s", "TI"], Cell["a number", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "automatic spacing", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->14109],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " gives the ratio of the text space to the size of a key box."
}], "Notes",
 CellID->17300]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->331589506],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->447370236],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->192249661],

Cell["\<\
A larger ratio effectively decreases the height of the legend:\
\>", "ExampleText",
 CellID->954379916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<sine\>\"", ",", " ", "\"\<cosine\>\""}], "}"}]}], ",", " ", 
   
   RowBox[{"LegendTextSpace", "\[Rule]", "5"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->216563026],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->218993033]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14166],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Legend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/Legend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotLegend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/PlotLegend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendTextOffset",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/LegendTextOffset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendTextDirection",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/LegendTextDirection"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8929]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LegendTextSpace - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 3.7835248}", "context" -> "PlotLegends`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Plot Legends Package Symbol", "language" -> "en", "paclet" -> 
    "PlotLegends Package", "status" -> "None", "summary" -> 
    "LegendTextSpace is an option for Legend, which specifies the space in \
the legend box for text.", "synonyms" -> {}, "title" -> "LegendTextSpace", 
    "type" -> "Symbol", "uri" -> "PlotLegends/ref/LegendTextSpace"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3546, 120, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->331589506]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13775, 362}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1006, 23, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1629, 50, 53, 1, 70, "ObjectName",
 CellID->18987],
Cell[1685, 53, 528, 15, 70, "Usage",
 CellID->8056]
}, Open  ]],
Cell[CellGroupData[{
Cell[2250, 73, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2728, 90, 69, 1, 70, "Notes",
 CellID->18518],
Cell[2800, 93, 528, 14, 70, "2ColumnTableMod",
 CellID->14109],
Cell[3331, 109, 178, 6, 70, "Notes",
 CellID->17300]
}, Closed]],
Cell[CellGroupData[{
Cell[3546, 120, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->331589506],
Cell[CellGroupData[{
Cell[3931, 134, 148, 5, 70, "ExampleSection",
 CellID->447370236],
Cell[4082, 141, 134, 3, 70, "Input",
 CellID->192249661],
Cell[4219, 146, 113, 3, 70, "ExampleText",
 CellID->954379916],
Cell[CellGroupData[{
Cell[4357, 153, 531, 16, 47, "Input",
 CellID->216563026],
Cell[4891, 171, 6406, 109, 265, "Output",
 Evaluatable->False,
 CellID->218993033]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11358, 287, 311, 9, 70, "SeeAlsoSection",
 CellID->14166],
Cell[11672, 298, 1026, 35, 70, "SeeAlso",
 CellID->8929]
}, Open  ]],
Cell[12713, 336, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

