(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9592,        341]
NotebookOptionsPosition[      7031,        256]
NotebookOutlinePosition[      8313,        293]
CellTagsIndexPosition[      8229,        288]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PLOT LEGENDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ShadowBox" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/ShadowBox"], 
         "ShadowBackground" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/ShadowBackground"], 
         "ShadowOffset" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/ShadowOffset"], 
         "ShadowForeground" :> 
         Documentation`HelpLookup[
          "paclet:PlotLegends/ref/ShadowForeground"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"ShadowBox\"\>", 2->"\<\"ShadowBackground\"\>", 
      3->"\<\"ShadowOffset\"\>", 
      4->"\<\"ShadowForeground\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ShadowBorder", "ObjectName",
 CellID->21241],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ShadowBorder"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["ShadowBox",
       BaseStyle->"Link",
       ButtonData->"paclet:PlotLegends/ref/ShadowBox"]], "InlineFormula"],
     ", which specifies the style of the border around the rectangle above a \
shadow. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13487]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ShadowBorder", "->", 
   StyleBox["style", "TI"]}]], "InlineFormula"],
 " specifies that the border line is to be generated with the given graphics \
directives or list of directives."
}], "Notes",
 CellID->22511],

Cell[TextData[{
 "Styles are the same as those for a ",
 Cell[BoxData[
  ButtonBox["Line",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Line"]], "InlineFormula"],
 " primitive."
}], "Notes",
 CellID->59]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->146290962],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->134381681],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->86184944],

Cell["Use a red border around the box:", "ExampleText",
 CellID->1458018162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"ShadowBox", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"ShadowBorder", "\[Rule]", "Red"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1419097921],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], RectangleBox[{0.1, -0.1}]}, 
   {GrayLevel[1], RectangleBox[{0, 0}]}, 
   {RGBColor[1, 0, 0], 
    LineBox[{{0, 0}, {1, 0}, {1, 1}, {0, 1}, {0, 0}}]}}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->865645974]
}, Open  ]],

Cell["Use a thick red border around the box:", "ExampleText",
 CellID->1578393594],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"ShadowBox", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"ShadowBorder", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Red", ",", " ", "Thick"}], "]"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1857660240],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], RectangleBox[{0.1, -0.1}]}, 
   {GrayLevel[1], RectangleBox[{0, 0}]}, 
   {RGBColor[1, 0, 0], Thickness[Large], 
    LineBox[{{0, 0}, {1, 0}, {1, 1}, {0, 1}, {0, 0}}]}}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->195642967]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27348],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShadowBox",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/ShadowBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShadowBackground",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/ShadowBackground"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShadowOffset",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/ShadowOffset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShadowForeground",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/ShadowForeground"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31402]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ShadowBorder - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 4.5491694}", "context" -> "PlotLegends`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Plot Legends Package Symbol", "language" -> "en", "paclet" -> 
    "PlotLegends Package", "status" -> "None", "summary" -> 
    "ShadowBorder is an option for ShadowBox, which specifies the style of \
the border around the rectangle above a shadow. ", "synonyms" -> {}, "title" -> 
    "ShadowBorder", "type" -> "Symbol", "uri" -> 
    "PlotLegends/ref/ShadowBorder"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3263, 113, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->146290962]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8086, 281}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1012, 23, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1635, 50, 50, 1, 70, "ObjectName",
 CellID->21241],
Cell[1688, 53, 558, 16, 70, "Usage",
 CellID->13487]
}, Open  ]],
Cell[CellGroupData[{
Cell[2283, 74, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2761, 91, 255, 7, 70, "Notes",
 CellID->22511],
Cell[3019, 100, 207, 8, 70, "Notes",
 CellID->59]
}, Closed]],
Cell[CellGroupData[{
Cell[3263, 113, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->146290962],
Cell[CellGroupData[{
Cell[3648, 127, 148, 5, 70, "ExampleSection",
 CellID->134381681],
Cell[3799, 134, 133, 3, 70, "Input",
 CellID->86184944],
Cell[3935, 139, 76, 1, 70, "ExampleText",
 CellID->1458018162],
Cell[CellGroupData[{
Cell[4036, 144, 321, 10, 28, "Input",
 CellID->1419097921],
Cell[4360, 156, 342, 10, 201, "Output",
 CellID->865645974]
}, Open  ]],
Cell[4717, 169, 82, 1, 70, "ExampleText",
 CellID->1578393594],
Cell[CellGroupData[{
Cell[4824, 174, 396, 12, 70, "Input",
 CellID->1857660240],
Cell[5223, 188, 360, 10, 201, "Output",
 CellID->195642967]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5644, 205, 311, 9, 70, "SeeAlsoSection",
 CellID->27348],
Cell[5958, 216, 1031, 35, 70, "SeeAlso",
 CellID->31402]
}, Open  ]],
Cell[7004, 254, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

