(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11289,        391]
NotebookOptionsPosition[      8926,        313]
NotebookOutlinePosition[     10157,        349]
CellTagsIndexPosition[     10073,        344]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PLOT LEGENDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{RowBox[{"Legend", " "}] :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/Legend"], 
         "ShadowBorder" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/ShadowBorder"], 
         "ShadowBackground" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/ShadowBackground"], 
         "ShadowOffset" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/ShadowOffset"], 
         "ShadowForeground" :> 
         Documentation`HelpLookup[
          "paclet:PlotLegends/ref/ShadowForeground"]}, #, 2]& , Evaluator -> 
       Automatic], {1->
      RowBox[{"RowBox", "[", 
       RowBox[{"{", 
        RowBox[{"\<\"Legend\"\>", ",", "\<\" \"\>"}], "}"}], "]"}], 
      2->"\<\"ShadowBorder\"\>", 3->"\<\"ShadowBackground\"\>", 
      4->"\<\"ShadowOffset\"\>", 
      5->"\<\"ShadowForeground\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ShadowBox", "ObjectName",
 CellID->28095],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ShadowBox", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["xlength", "TI"], ",", 
          StyleBox["ylength", "TI"]}], "}"}], ",", 
        StyleBox["options", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a box with a drop shadow."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11110]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The box is generated at position ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
 " with size specified by ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["xlength", "TI"], ",", 
    StyleBox["ylength", "TI"]}], 
   StyleBox["}", "TI"]}]], "InlineFormula"],
 ", ",
 "and with colors specified in ",
 Cell[BoxData[
  StyleBox["options", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17405],

Cell["The following options can be given:", "Notes",
 CellID->7041],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ShadowBorder",
     BaseStyle->"Link",
     ButtonData->"paclet:PlotLegends/ref/ShadowBorder"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       ButtonBox["Thickness",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Thickness"], "[", "0.001", "]"}], ",", " ", 
      RowBox[{
       ButtonBox["GrayLevel",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GrayLevel"], "[", "0", "]"}]}], "}"}], Cell[
    "style of the line around the box", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ShadowForeground",
     BaseStyle->"Link",
     ButtonData->"paclet:PlotLegends/ref/ShadowForeground"], 
    RowBox[{
     ButtonBox["GrayLevel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GrayLevel"], "[", "1", "]"}], Cell[
    "color of the box with the shadow", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ShadowBackground",
     BaseStyle->"Link",
     ButtonData->"paclet:PlotLegends/ref/ShadowBackground"], 
    RowBox[{
     ButtonBox["GrayLevel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GrayLevel"], "[", "0", "]"}], Cell[
    "color of the shadow", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ShadowOffset",
     BaseStyle->"Link",
     ButtonData->"paclet:PlotLegends/ref/ShadowOffset"], 
    RowBox[{"{", 
     RowBox[{"0.1", ",", " ", 
      RowBox[{"-", "0.1"}]}], "}"}], Cell[
    "x and y offset of the shadow from the box", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->12104]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->15243118],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->274075993],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->531898286],

Cell[TextData[{
 "Shadow box from ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "0"}], "}"}]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "1"}], "}"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1458018162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"ShadowBox", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", " ", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1419097921],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], RectangleBox[{0.1, -0.1}]}, 
   {GrayLevel[1], RectangleBox[{0, 0}]}, 
   {GrayLevel[0], Thickness[0.001], 
    LineBox[{{0, 0}, {1, 0}, {1, 1}, {0, 1}, {0, 0}}]}},
  Frame->True]], "Output",
 ImageSize->{184, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->300112035]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12736],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    RowBox[{"Legend", " "}],
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/Legend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShadowBorder",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/ShadowBorder"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShadowBackground",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/ShadowBackground"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShadowOffset",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/ShadowOffset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShadowForeground",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/ShadowForeground"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24428]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ShadowBox - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 4.7210488}", "context" -> "PlotLegends`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Plot Legends Package Symbol", "language" -> "en", "paclet" -> 
    "PlotLegends Package", "status" -> "None", "summary" -> 
    "ShadowBox[{x, y}, {xlength, ylength}, options] generates a box with a \
drop shadow.", "synonyms" -> {}, "title" -> "ShadowBox", "type" -> "Symbol", 
    "uri" -> "PlotLegends/ref/ShadowBox"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5531, 180, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->15243118]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9931, 337}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1257, 29, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1880, 56, 47, 1, 70, "ObjectName",
 CellID->28095],
Cell[1930, 59, 673, 21, 70, "Usage",
 CellID->11110]
}, Open  ]],
Cell[CellGroupData[{
Cell[2640, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3118, 102, 507, 20, 70, "Notes",
 CellID->17405],
Cell[3628, 124, 67, 1, 70, "Notes",
 CellID->7041],
Cell[3698, 127, 1796, 48, 70, "3ColumnTableMod",
 CellID->12104]
}, Closed]],
Cell[CellGroupData[{
Cell[5531, 180, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->15243118],
Cell[CellGroupData[{
Cell[5915, 194, 148, 5, 70, "ExampleSection",
 CellID->274075993],
Cell[6066, 201, 134, 3, 70, "Input",
 CellID->531898286],
Cell[6203, 206, 260, 11, 70, "ExampleText",
 CellID->1458018162],
Cell[CellGroupData[{
Cell[6488, 221, 338, 11, 28, "Input",
 CellID->1419097921],
Cell[6829, 234, 370, 11, 203, "Output",
 CellID->300112035]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7260, 252, 311, 9, 70, "SeeAlsoSection",
 CellID->12736],
Cell[7574, 263, 1310, 45, 70, "SeeAlso",
 CellID->24428]
}, Open  ]],
Cell[8899, 311, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

