(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     76358,       1446]
NotebookOptionsPosition[     73940,       1366]
NotebookOutlinePosition[     75212,       1403]
CellTagsIndexPosition[     75126,       1398]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PLOT LEGENDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Legend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/Legend"], 
         "PlotLegend" :> 
         Documentation`HelpLookup["paclet:PlotLegends/ref/PlotLegend"], 
         "Plot" :> Documentation`HelpLookup["paclet:ref/Plot"], "ColorData" :> 
         Documentation`HelpLookup["paclet:ref/ColorData"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Legend\"\>", 2->"\<\"PlotLegend\"\>",
       3->"\<\"Plot\"\>", 4->"\<\"ColorData\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ShowLegend", "ObjectName",
 CellID->32688],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ShowLegend", "[", 
       RowBox[{
        StyleBox["graphics", "TI"], ",", 
        SubscriptBox[
         StyleBox["legend", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["legend", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]places the ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["legend", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["legend", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     ", in the given graphic ",
     Cell[BoxData[
      StyleBox["graphics", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32003]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["legend", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is in the same format as a call to ",
 Cell[BoxData[
  ButtonBox["Legend",
   BaseStyle->"Link",
   ButtonData->"paclet:PlotLegends/ref/Legend"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->23615],

Cell[TextData[{
 "The graphic ",
 Cell[BoxData[
  StyleBox["graphics", "TI"]], "InlineFormula"],
 " is placed in a rectangle whose center is at ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "0"}], "}"}]], "InlineFormula"],
 ", and whose boundaries are ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "}"}]], "InlineFormula"],
 ". These coordinates must be used to place the legends."
}], "Notes",
 CellID->286],

Cell[TextData[{
 "The aspect ratio of ",
 Cell[BoxData[
  StyleBox["graphics", "TI"]], "InlineFormula"],
 " is unchanged."
}], "Notes",
 CellID->12855]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->14945426],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->574136224],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->151534233],

Cell["Density plot with a legend:", "ExampleText",
 CellID->466584274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowLegend", "[", 
  RowBox[{
   RowBox[{"DensityPlot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", " ", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "30"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"ColorData", "[", "\"\<LakeColors\>\"", "]"}], "[", 
       RowBox[{"1", "-", "#1"}], "]"}], "&"}], ",", "10", ",", "\"\< 1\>\"", 
     ",", "\"\<-1\>\"", ",", 
     RowBox[{"LegendPosition", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1.1", ",", 
        RowBox[{"-", ".4"}]}], "}"}]}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2120014461],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 295},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->37517682]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19426],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Legend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/Legend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotLegend",
    BaseStyle->"Link",
    ButtonData->"paclet:PlotLegends/ref/PlotLegend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Plot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7032]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ShowLegend - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 10.7368278}", "context" -> "PlotLegends`",
     "keywords" -> {}, "index" -> True, "label" -> 
    "Plot Legends Package Symbol", "language" -> "en", "paclet" -> 
    "PlotLegends Package", "status" -> "None", "summary" -> 
    "ShowLegend[graphics, legend_1, legend_2, ...] places the legend_1, \
legend_2, ..., in the given graphic graphics.", "synonyms" -> {}, "title" -> 
    "ShowLegend", "type" -> "Symbol", "uri" -> 
    "PlotLegends/ref/ShowLegend"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4191, 152, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->14945426]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 74984, 1391}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 878, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1501, 46, 48, 1, 70, "ObjectName",
 CellID->32688],
Cell[1552, 49, 1019, 33, 70, "Usage",
 CellID->32003]
}, Open  ]],
Cell[CellGroupData[{
Cell[2608, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3086, 104, 332, 13, 70, "Notes",
 CellID->23615],
Cell[3421, 119, 579, 20, 70, "Notes",
 CellID->286],
Cell[4003, 141, 151, 6, 70, "Notes",
 CellID->12855]
}, Closed]],
Cell[CellGroupData[{
Cell[4191, 152, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->14945426],
Cell[CellGroupData[{
Cell[4575, 166, 148, 5, 70, "ExampleSection",
 CellID->574136224],
Cell[4726, 173, 134, 3, 70, "Input",
 CellID->151534233],
Cell[4863, 178, 70, 1, 70, "ExampleText",
 CellID->466584274],
Cell[CellGroupData[{
Cell[4958, 183, 870, 25, 47, "Input",
 CellID->2120014461],
Cell[5831, 210, 66734, 1098, 316, "Output",
 Evaluatable->False,
 CellID->37517682]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[72626, 1315, 311, 9, 70, "SeeAlsoSection",
 CellID->19426],
Cell[72940, 1326, 958, 35, 70, "SeeAlso",
 CellID->7032]
}, Open  ]],
Cell[73913, 1364, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

