(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22386,        582]
NotebookOptionsPosition[     19431,        486]
NotebookOutlinePosition[     20831,        524]
CellTagsIndexPosition[     20746,        519]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["POLYHEDRON OPERATIONS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PolyhedronOperations" :> 
          Documentation`HelpLookup[
           "paclet:PolyhedronOperations/tutorial/PolyhedronOperations"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"PolyhedronOperations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PolyhedronData" :> 
          Documentation`HelpLookup["paclet:ref/PolyhedronData"], "Geodesate" :> 
          Documentation`HelpLookup[
           "paclet:PolyhedronOperations/ref/Geodesate"], "Stellate" :> 
          Documentation`HelpLookup[
           "paclet:PolyhedronOperations/ref/Stellate"], "Truncate" :> 
          Documentation`HelpLookup[
           "paclet:PolyhedronOperations/ref/Truncate"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"PolyhedronData\"\>", 2->"\<\"Geodesate\"\>", 
       3->"\<\"Stellate\"\>", 4->"\<\"Truncate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["OpenTruncate", "ObjectName",
 CellID->10391],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"OpenTruncate", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]truncates each edge of each polygon in graphics \
expression ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " without filling in with a polygon."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"OpenTruncate", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["ratio", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]truncates to the specified ",
     Cell[BoxData[
      StyleBox["ratio", "TI"]], "InlineFormula"],
     " of the edge length."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->14030]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"OpenTruncate", "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " uses a truncation ratio of 3/10."
}], "Notes",
 CellID->10334],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"OpenTruncate", "[", 
   RowBox[{
    ButtonBox["PolyhedronData",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PolyhedronData"], "[", 
    StyleBox["poly", "TI"], "]"}], "]"}]], "InlineFormula"],
 " creates a truncated polyhedron."
}], "Notes",
 CellID->340034898],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["ratio", "TI"]], "InlineFormula"],
 " must be between 0 and 1/2."
}], "Notes",
 CellID->512546019]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->578140427],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->276396585],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PolyhedronOperations`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->431875943],

Cell[TextData[{
 Cell[BoxData["OpenTruncate"], "InlineFormula"],
 " works on graphics primitives:"
}], "ExampleText",
 CellID->590121926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OpenTruncate", "[", 
  RowBox[{"PolyhedronData", "[", 
   RowBox[{"\"\<Cube\>\"", ",", "\"\<Faces\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1212219481],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXduOJEcRbfdl1sZ7m8vau2vDjNfGXhBvsNwENpIvPGAjMOYFGaSVhWRL
IBtj4BeAn/IzfAv/UExWVfRkn46sE5GZ1dPjrZZ2e/ISkZGRWZlZEacj33v8
xcd//PPjLz756PHZzz9//NnHn3z017N3Pv38PGvx1Gw2f3U2m/3v7uz87+b8
r/affB6e/+uS/zn/Nz8v+nCd89/w12Jde/a7EUruQe5tSD9XOf08KV9C+muF
8rH2vGmUL6TDqB2o2r0LuYd97eeN33ej75jPos9H7aT43zW0w3o5lNZ7Oz//
b3WeDNKG7BWUH/TljLvUW/V8Foly1g4rn/flOJZPR+1q8l4j5Zh+WhnNRU+X
Ix9rn8lv1c/Y41Rv1s1W8Ro763W3nStP77Vkqfas67VxVOaDtXPkGaZ5BtpH
7cqa8XSFvqYl0XigZPVGKNXHHP359GLrU6q2lWtqTtlbL3++cAfFWgu17Zuk
JzcULgfnScy/BunrptZvkdbxFDGH9KHKFddtVdblRXp7BUTpsXe31HbvEGmx
t/pswFr47OCIzfsRYSOJfVTnh3sVx1r1+uSfLTjONi6h32EyHGnUONcGylET
qrSDs0571gIBa5lJPt68848R01reWQJllRMYao6NUSvdxhjhCiQ7l77ysBHV
dXa754m9uNXo7yzYCvZCdil9zb1tllxrW2TSZNXOyqg/NqsWWyOQ6t04p1L+
lGry0DnVp2fWOelaJ/RZ5V3P1JW8aD3jPWG6ZPt/3srG9o1Yistb0zyn7xvF
dbHP5RxtY6HXukllbGTcMt95bHKMpe2SXufNeVstNvPHfH9BC6fs4WJtudVs
WkduNhdWlnmUxvpxWvYN2ZmkfA7phdIr7RTG2ovTWnuxPCLfMuqfvCPPo/Qq
IZ/P4hn+3IXdOvy5bTEPn4c0ddk2b7Y77bvN+7NWi7Vs2zj/x7ZtC/+/qL0Q
m7V8p2ycrJzZUseyZV8z0MvqNjTGaOuw2vJLbcgW+S22cIstPWd8Mf1pk5pF
l2GDzmnhsu3W+Jz7amvWpXFtzjVHUbc5X7YlvL5tW+t7t4sw6zI7pbL3fov9
uJ7dWX2v3Kql7XjW98Z0296e43OvWkzcrfitDFiOOsTe44j/rW3G68H2Wlvq
2ITzuNhmVRiZpbLWsJ7WkZzZ7Xw28/YJcc0ib68x/fdGm0XMFqjJPzSXN6y8
qJ1B+/CG5XkZ6zFpyc+w0Gh9WplbXCj5Fsvbms5sPbZ5/djekDcn2Ml5yE4b
/szyHfTpWVJTJ5ujJDkjzYltG+2dtFRsNtSw9brWCo+dVkvr86Lc0ldihyyx
vqK+dHsh1hpzzdF55cmp1/JYSndrrS23sGrpbs5abaEp26WUa7bRZZRG2+NK
4c/mUswn1Y7YbJmNlNls47TmA/xHqz3RP7cw5qa+3lyc4ULzx41ua0X94TvY
hNodlu+NVtunkMtQQuwZC72+Cuhe4f+zVguCDo0tkprlS87mYpmTZ7SrKB+G
9tHePmRFwbGw2gEvw05rtVNasa5X1d469jhh+vXw39Z6p78PpCxPem2vhdAz
y1PWud2gSMe09qWsxz6rbj6e1aKXXVs7y/tf05o7rl9B4/FGk/+MxuvsbJRn
le1QaNHMs/SVWooslsIDpd08CyPON2bd2yebIbZis9SjLchrK8JW32pkzq9P
C7aZuGG58MzrOjuTnOrqvHXuxqqe86z4bRBXwU6+m1HD9NuNzHXL7LXpEa2k
88F5P9conL0Y0/qSY4kWe8vwCqHVWCj5Qe5AyOabppWlo51cvPbAk22z6Dn2
UnYCSM3njXeaDQ/IYj2x5SOzsmN+kbdIlHlR5rucrWwN8+Kc1Vk9MF74JGu/
FaC6itLM3872k7xfqAz4/l3Y9VJ8fWp2Pwv1zgjfy5yRY2KRvbMTy70rrJe/
Y+WspLG6fqemKUPUd/M32MeW/awNa+mDxmYZlzWYWfxTqGlMC2o6LhePhMiz
UJ5qzcMR17+Z4Bf6syLyS3oxs3tyUE/vtFqWcRjPw3Ha9+d+L8f9Pv1a/30P
yh9C/nGf/xLQS/nDRP6jdevbM+6eI/e1nXI4UnP3oRedPnHP+Aak0fPwLUi/
QOhfJfXRT/QSaR/pv+Os//2212FU5rNtzODXIY3eVnkWTxL02Brymzvp0Qsm
9OJVRJ8Dyov8lkCPe46VXtbcbkXAlRFPW4FrSKI2cN9FaZAPSiN80d7n5XOU
4KO9A2r9QH7sPHEjkw+u+N9UtY+t4ROBTyjDdyE/lBL5s9Fg/LA/llEZ6p82
h9nolPCzjVJ7dt9ak+9DrftqLebl1nnruwC2yEbPw/uY8GYjqfdeb4u9YeKo
lvC2jXCwYodkmC/L2cV5iGk4povp2agj3UmCTtN6LJ/Qs9G6YaSzaQsjpOBT
9iKk8XSO3rpd88Ny5Ie+NLYnMfkYXojxY++0p01qlMK+/2L/jTuYeDnRMlGL
DnuZwtncNLaHdM8ROk1rod6Zqi02Jmwn8Y5xbX4M+4unT7azM/mQH74bePlh
ut3Jt9ZNwVixuYLaq0WXmtOojdvG9pDuLqFLzenTVluaLUzQQrPFl19+Oes+
YSdo032965XroZToI35S5LrhlAdX1BWhf7aJUVzl9Zg8y8rt5cqF6Zcbba34
ANK4i7Py9yCNp1JW/lsi9Sut1LgPvQ9p7BUr/wWkcU1g5b8hUusnwknqSeqv
otSyQt2Db8tbfQ26owRdaqdn7SHddSOdTVvMQopppo1d88MzNNMelnvlQ37s
PZPxm0ZJ0+rVGKWUl8PyHuXxUpTSa++ZsZfCq22k92pX93KgZ4pxYZ4yb33U
0tjyPJp6/YT1+qzZtBTI97eN+WKte+Dk84O29ab/2KK/BeHlJIPIAcwXZILk
IzLhMCqP8yUtSIQuSl3r79JRYUW++3IOOtagXAY9t7wXnT7RMo17N/P4s/r4
LOCzxRAL6MVCex3Wx3L0j/6+7bXszWitw5OV14Pvpce9EbWTQjCk6FFbWuT7
IXqsj4gE2ZNbS8hWb8VDz7w1Vg99KR9Mo3ZTCAbGB7V8mMlH6HCU8cT1flLb
QzO/1PNeyg+fDdQ+Qy4wfjgKWO7lh2lcmVDftlHx7ApeL3pN3tdVKr0Fhlqw
8db3KoyOnscbueh4A+SdHlG5hyJkez30OXQhedIMIxBSdMfRt5cuRhTg3qhr
h+1ApZ702vxwFaotH/IfW753k6MS2wC8HvhcujuF7Wk4jpL23lO1w/bzUk95
bX44J2rLh+mx5Wst++r+a5l7KQ97Lh2bQ6y91JzNba97onV03rAHe588xvsm
D/Pc75t+WPku5bAgI/Dc+6tGe8bfhrTXA/9LUs74I/2vWylxf3gT0l7P5Luk
nPFHev3kNUk5SbmPUsrKI3Zdr+c6lw7tzt72DjPppD3b2yRyZ2dFr++yNj92
tiuVD9O1+zuNytUZFbHKe0eDWdVL6S3vN572tfetEvk3rfJonWPU6KHx1mfa
Yfwx7ZXnw6nXT1ivw44bv4GjhzuVj79nwfonhM8f2tab/sM95eGNH7F/oTNn
kC8W15cgLZ7v00b3iMf5MZ3wlxNKbBFOedB1r4Fuoz91cNBzz4o56DJ4/N86
B49PxSODzrfNpb/7Rhsx+00slp+ScvTEId6F+dSxPvPxYxqferQvtlaE5OmA
/RYQfd6Mnvnc8exijVqQap/53Bm9FzPATlepqAetpYj+Plz7PflC0RqeIBkf
q69ei8kQkiz6AZMn5av38snFIGA5jloqisIz6qihllDbXl864+f19aOXzBtF
gcnHfP1efqXYBuSnIUyG+Omj3PbCuJd5/e4e3l68wMrExRadwSa3DS9QwLtY
Jzpv/azBIj/os0XQW4JTsOIHkM6KVziA+qkIDan2EK9gpfPiKuL2hF6j07XK
0O9evEDtyAXsV+NefrXxIMxXX1s+FkmiC0GawlvEWGykqhkp4VYmXS4u5FYm
HbaX+rX9UtUqm5te3ELtCAkM++zlVxuXwhCTteVjESvaeJVJ3Ad7dmpFZDjM
pMvFpxxm0mF7qWenW5G8eBEr3qEUh7BvEQ8O9kyefcH1MDl2hZ8p1Yc3Qkd7
atw7nMo7pPx1SLdrx97hBd4i5T+BtH6Cnnox9WLqRRpnI14kK34lN7LEKpMu
Fw8kdF5cD7aXiriha5V5B7zIiNqxCpid3MuvNvKFeSdqy8diR0yjbNHiV2OU
rR5Chr8pjXjhHT3Wvhe/5B0db/upiCGdhxAt20z73ugKD5z1kT/TJvNme/kj
/dGkpUlLVbUkeCixaInFKBUJ5OVE/gOgx3zET2H9O1FaRPTcaSIeFjmxSeSQ
+5CPd5RI/hnkywnwFPgcQ/4R5B+tpbJ68zwxOjxIq93edVKO9vLI4MdJhfGN
Z7+KE4rSiC5ELz/WZ7eZ4NP3CqnPVieUB0+pDIeF9Tt8XyruGKNmKGS0WzN6
drsJizvGblfxnuJQfvT5e3FaKXodJ4XalDUHuXpjmtzL5JO6BQVHhfFJ3cqC
o+PFSUm/cNbm4rYYH/09UYvYMvRMeWOi4Irh5cduS2EeOd1rlObHPK4M14T9
xRW8FMfF+OmjrN+qoiHsasVVwXNtHm/brSp5vG23weh7eB5OSv0tw0j4Lhtv
fbbITS+CA7LeXyUr7gsZdDHO6cRIhzfLHDvoYjm9dMeETtcq7l+4cpXGVSnF
XTF+tW+g8crHsC2lOLM6OCl5Q4y/kUrDEeHNMLl0uTfYWNtDXJYXB5aHk2Ix
hErju5Tirhi/2jfdeOVjOK5SnFkdnJTcXMOeHXYDTS5d7k051vYQl+XFgeXh
pKw3xDBcya7itewKt1Vbnn25OWdsPNu+3CQ04aTCnxNOaurF1IsnuxeyM4iX
yBvnx4uvQrrcG39y8Vze9vJwUrjSsneO0jtYavOrfedMbcRQqXx1cFLTKH8V
RznlIbTYDYY8hF6clXf0vDitUpyXt30fTophQ1isHNbb2rfceLE2jL8N2zJp
adJSLS2dNds4pfCNNyOl8lM3LKXwVli/FCeF8aTk+7TRT45nkMb6ePIL9RdR
GvFWeIJ+sJZqjFhOHozSmaPuWLGcyjmU3wrVjQiLJ8VQh+xpRdSkFwXJnlbE
VbGbZNidVNhed7u0FS3uRUt7TyEsss9YaO0UzgrfARg9uwMr1f82coM7npQW
+3LoxMz4eXFKLFJPqXxs9Kx4LOZPz72Di+mrXXvc8aZYJAI2Cl6PHfJD77c3
UoJ3lpTispjH14sbY7faID99lD0xofJuqfK0kIdN0mNPeU4SeX3wnBO82K0B
THUx5syDh0fe+izS4kmFbw9uKXxbcUsHUN/bXhwXykoX47+sdHifWKp/ulZr
x40aG79UO85TKZ6sFA9V+x6xDuvP4lB54zTl4p1y40J5cWBWnFTuPWMnqlYZ
3qg0jlJt/FLtOE+leLJSPFTt+8w6axCLQ+WN05SLd8qNC+XFgVlxUrn3nXUr
kn4WuTrxlnaFI2JxqPYl7lNtHNG+tW/FudW+r61dw7bWIIaXqo2H8pZj+63t
d2u/ZLiQ2rgPbzm2r5+Yp15MvZh6weNOeeMyefFNq0b3YtXCN9Wis94np2u1
dgSh2kgWr5dibCTL2PxKb0ibRnmMUdnPUZ48iXXoc+/N6zyJLFbQvnu9vfW9
d609mLQ0aamqljDuFMaFQnzUy5BmcaRS+al7+1rcSC+iBU/1z0Y/yb4GaYxH
hSdRzJf6b65bKfOKlkeB8iCLPDJ4vJadNv7V+J4sL/Kw9IZL9qS072CzPzUX
O174lhtY0V5iPQGcGOlLd1B2AmD0qfZ/utYKlg6lmQ+RYWnQeub1SXpjLZVi
fbx+EOT34ywtl3qvUMveSBPemEil2BvGj8mXp2U9hlAJ9gX74WmhZqyimtgX
Twu2PuSNlsTwYRgTHAOk82A3FjM/xgTpUu11WrjTlz7qvxEzwbSCnj0vRgS9
7oxfbcyEFyPC+DH5vtdqHbk8Ir22jILFD42eLKTLxUZYMRxIl2qv1Ucb0yQU
htxV9N2H5Wg/obbU6zY/+TT9UrCIuAQP27JPy3egvqZwjVtdYnkvJxsXTLOI
UGzcSyNWlaIkvKgQxo/J991O5b3mw/9zGdZGPuuB38rV6+q5ajydIo48d/2/
RybU1vIiPds6/eHqo3mULesGzjuky8WFWPErSJdqr1tdL22+4JOwMTYHlHvp
fJA3SjzvqPMG0rLS1YhTY62nnbDGlGtfcB+1cDi15PHq5YdNOx+XjUzZ5mIn
RfmWydmcP8dlN9+a09WfLplV2lPF1tYPII2WBobbYeWI2/lRg2ufWJrSupHT
00a/tTwt7Vk/C0aqUJ7B/ZGd196HNL7bMXQGK0d0RvdOFo+hrOnx6VNOtPNE
mfR5s7b8hkDOs6kna32a3ni+sR3tpBHLlHtCvnyNo17wjW7APhPV0iK971+/
Q1/DXJD3Mg1vHMrj89f+98pr2bkaUsqpgWGoNBug5pnyYpOsGCqkS7WXpwWv
t4Rpx+s9KUWHeNEwXu/KpOXL1fLk4UMP37+dvd837+2bUy/2rBcBD6BhSFKx
dxD7gfURK9L+YqFvUnAfs6f+D5juY6o=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{550, 236},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->77274783]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["OpenTruncate"], "InlineFormula"],
 " also works on graphics objects:"
}], "ExampleText",
 CellID->1099728436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OpenTruncate", "[", 
  RowBox[{"PolyhedronData", "[", 
   RowBox[{"\"\<Icosahedron\>\"", ",", " ", "\"\<Image\>\""}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1891557770],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->504500165]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13216],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolyhedronData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyhedronData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Geodesate",
    BaseStyle->"Link",
    ButtonData->"paclet:PolyhedronOperations/ref/Geodesate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Stellate",
    BaseStyle->"Link",
    ButtonData->"paclet:PolyhedronOperations/ref/Stellate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Truncate",
    BaseStyle->"Link",
    ButtonData->"paclet:PolyhedronOperations/ref/Truncate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10957]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28484],

Cell[TextData[ButtonBox["PolyhedronOperations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PolyhedronOperations/tutorial/PolyhedronOperations"]], "Tutorials",
 CellID->27964]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OpenTruncate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 11.7056026}", "context" -> 
    "PolyhedronOperations`", "keywords" -> {}, "index" -> True, "label" -> 
    "Polyhedron Operations Package Symbol", "language" -> "en", "paclet" -> 
    "PolyhedronOperations Package", "status" -> "None", "summary" -> 
    "OpenTruncate[expr] truncates each edge of each polygon in graphics \
expression expr without filling in with a polygon. OpenTruncate[expr, ratio] \
truncates to the specified ratio of the edge length.", "synonyms" -> {}, 
    "title" -> "OpenTruncate", "type" -> "Symbol", "uri" -> 
    "PolyhedronOperations/ref/OpenTruncate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4382, 148, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->578140427]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20603, 512}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1620, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2243, 66, 50, 1, 70, "ObjectName",
 CellID->10391],
Cell[2296, 69, 894, 27, 70, "Usage",
 CellID->14030]
}, Open  ]],
Cell[CellGroupData[{
Cell[3227, 101, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3705, 118, 181, 6, 70, "Notes",
 CellID->10334],
Cell[3889, 126, 313, 10, 70, "Notes",
 CellID->340034898],
Cell[4205, 138, 140, 5, 70, "Notes",
 CellID->512546019]
}, Closed]],
Cell[CellGroupData[{
Cell[4382, 148, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->578140427],
Cell[CellGroupData[{
Cell[4767, 162, 148, 5, 70, "ExampleSection",
 CellID->276396585],
Cell[4918, 169, 145, 4, 70, "Input",
 CellID->431875943],
Cell[5066, 175, 137, 4, 70, "ExampleText",
 CellID->590121926],
Cell[CellGroupData[{
Cell[5228, 183, 197, 5, 28, "Input",
 CellID->1212219481],
Cell[5428, 190, 6893, 117, 257, "Output",
 Evaluatable->False,
 CellID->77274783]
}, Open  ]],
Cell[12336, 310, 140, 4, 70, "ExampleText",
 CellID->1099728436],
Cell[CellGroupData[{
Cell[12501, 318, 212, 6, 28, "Input",
 CellID->1891557770],
Cell[12716, 326, 4751, 82, 216, "Output",
 Evaluatable->False,
 CellID->504500165]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17528, 415, 311, 9, 70, "SeeAlsoSection",
 CellID->13216],
Cell[17842, 426, 1018, 35, 70, "SeeAlso",
 CellID->10957]
}, Open  ]],
Cell[CellGroupData[{
Cell[18897, 466, 314, 9, 70, "TutorialsSection",
 CellID->28484],
Cell[19214, 477, 175, 4, 70, "Tutorials",
 CellID->27964]
}, Open  ]],
Cell[19404, 484, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

