(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23229,        599]
NotebookOptionsPosition[     20338,        504]
NotebookOutlinePosition[     21679,        541]
CellTagsIndexPosition[     21594,        536]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["POLYHEDRON OPERATIONS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PolyhedronOperations" :> 
          Documentation`HelpLookup[
           "paclet:PolyhedronOperations/tutorial/PolyhedronOperations"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"PolyhedronOperations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PolyhedronData" :> 
          Documentation`HelpLookup["paclet:ref/PolyhedronData"], "Geodesate" :> 
          Documentation`HelpLookup[
           "paclet:PolyhedronOperations/ref/Geodesate"], "Stellate" :> 
          Documentation`HelpLookup[
           "paclet:PolyhedronOperations/ref/Stellate"], "OpenTruncate" :> 
          Documentation`HelpLookup[
           "paclet:PolyhedronOperations/ref/OpenTruncate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PolyhedronData\"\>", 
       2->"\<\"Geodesate\"\>", 3->"\<\"Stellate\"\>", 
       4->"\<\"OpenTruncate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Truncate", "ObjectName",
 CellID->4805],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Truncate", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]truncates each edge of each polygon in",
     " graphics expression",
     " ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Truncate", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["ratio", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]truncates to the specified ",
     Cell[BoxData[
      StyleBox["ratio", "TI"]], "InlineFormula"],
     " of the edge length."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->29789]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Truncate", "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " uses a truncation ratio of 3/10."
}], "Notes",
 CellID->10334],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Truncate", "[", 
   RowBox[{
    ButtonBox["PolyhedronData",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PolyhedronData"], "[", 
    StyleBox["poly", "TI"], "]"}], "]"}]], "InlineFormula"],
 " creates a truncated polyhedron."
}], "Notes",
 CellID->19516],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["ratio", "TI"]], "InlineFormula"],
 " must be between 0 and 1/2."
}], "Notes",
 CellID->512546019]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->637031458],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->300797335],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PolyhedronOperations`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->331620859],

Cell[TextData[{
 Cell[BoxData["Truncate"], "InlineFormula"],
 " works on graphics primitives:"
}], "ExampleText",
 CellID->590121926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Truncate", "[", 
  RowBox[{"PolyhedronData", "[", 
   RowBox[{"\"\<Cube\>\"", ",", "\"\<Faces\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1212219481],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXU2THEcRHe/MrmysD6+0siXZsGPZ2ILgBgKbwOZgMAcsAvxxIQwRCgcR
NgHYYXwADsDR5i8Q/Bb/tEbdPTmqeZPZL7OqenZW6omQZqu7MisrK7uqOvNN
1r37X3z8hz/f/+KTj+4vf/H5/c8+/uSjvy7f/vTzB5fmT8xmB6/MZk9cvjF7
8Hczm/X/5HPnwb+++OWDfwcPbv1vfeWr9q/5uvbsvyPcWcLVZ6D8LCkvoPyN
yvye3rF8V6D8HOHXlttRO4TrWO61fQpXj1fUz62+b8D9+eo6Su2lQ+2VtvfM
6vumQyuRsq6dVpq22H4fPvhGqqPV9YNVvSPjvvDBMUF+T0L5wGjXksNqR+4f
Jv0Z4veUIQfjb8lbSw9D/DX9Xwi2W8dqWilnh+kcOzPGsLVk1DXKODfqlbXi
6WmsVa02jseB0Qo+7Xorw21fCOlDr12m0xypsefW/OeXrNyevwVXL2iyDKxY
OOqXXH1Bu0cqtr5dzpDiSNEh8sH7qI2LQbnmWb1nI3eVtOrTOXLFdUKbm/h8
yGYBtJ+W6+JBEa/7ngGkwvs17IZLgbs6bcWKjPc4utBsv9U8Sr/L2edUqaXt
b30a0WxL2wmUWo3wRc11T8jiYZlbirX+H2uckc9W/7EWe/bYjHBRbUWzl4Vj
fqljIdH5xWcpdZ4w9pyro2jw88wz2J5rHknKnZVt2GvUgpgET6t6VWecANdd
7tzP0p78s1xNq4rsbC+5+qnXqqn/iHTqrB2YFfOsb6n0Yz57+G4gvg55a78C
ZeSKK8TBqn5br+3y5YR+kZQvrL6x17inTOUTeVDe9L5HPo2f9Fve6pm3IuYB
a//chV+z/XPbo9p+7tDSy6sREs1cSzQypInH3XeK9Mx3+vdO26/AVdQy28tr
dn6efKpChz5VoftHpyV5OlMfouaLk7c32RHLU95XlI/nmdb212fliRW6hUHv
9cB6PbqWB3bXnmDLE5vbz6hH9m/tf/r67PbT6bWj3rqItdbzX1pvg/vivyzz
D8fkzfeJ5mjMpvF6tcfQ7zi66dfBvKcsnUFmozxtbI7SRwl3m8xvm+eX7bgO
vi8jRdQjgPWZf5rx9+hB84szD6WuP/Y+63vTxFH4ZyP2ul7DfFa0MVIRm6yz
LpytJ/xoSwOltsr6y3bOu/HF1/Gp5FkuUv2rEcv12GJgX5HWGrTiA42C9NVa
N3B8rqitopVpsSltL6iNgL2fs2p7/OtD48p2qNqz2RY1b8dwJED1xS/Sfmqx
mXHtcmOfviHLfM1GPmJdvUofXpsb96JeNZdve3B+4zVc3u2qcyhbE7I8/Fvj
fTLQimYPvN/XiBx17RB9HkvSeskbWcQ3fVZ+7DFjEPW9/+oKMChHvr4isQ9/
b3U7bSVarKyznd1uNz4/7ZAnXSvneNIjkQPL0y/etssJ3SIpHzV65MCST9pP
IxES2x6S79+dtmU8uP88t4SzStRfHS2jf3ps/zxrL1r2RmLe77R7ClfR/8y+
byTfuIPz+LeRz1A7kbVF2v9A7aXXY+r17FqeW6/n1+O5lWc7vf9kszknaF6Y
ofu1POyWfKx9Jr9XP2OPU9Sn8F5jWd1ZIGi13Wxd72vMX2r5z5+s0Nfde9vH
jRHE9VLm/fdytWwqP5rgkaJfsxAL7fN6Rv1Y4nPN8dXyXT+LZ6sYsC2uOF/H
PeEoPfZOf3O9TqTNexNinkdBh7ORZLEJvP/bTp5TQlWvD3Hr8PlYLU+19ibB
3gyGNFHufxHJWMtM8vHsLD5GUX+tbnUom+W5dL2Hb4yJFklcY5jpG7vPAlN0
HEqnvYOrvkBl3tfnVB+6+pLRdvr+PSSDhSJ3/aZkYwSs3kV3m7rl8KeQRU+G
cMgzrw2G5gHdiqLzlTpTF81XTq/1gAxsPc+buSKxv93NWbv142Ifx/IM+0aI
e02bZt+Q1eV1fb2u6Q8fet78XKLvHb29LxXe89m2Zxg9s+KJvWzUtzzDKWa7
JobbKmvtaZ7qRbOJWReM+mWo732b+7DTrozPo+tBZmvFvnuQP+m0eApXcz3F
2m/mxvQUC/8/qr0QT7CFjS3NojC2h5hhd60sDMzz6/WQl3pmPfJ7PMweD3XO
+GL548ayorPw7NZCyu7SG+xHxVq5GDT9jOfJrTmKuif3rP3L9T3GWt/7VYT5
btkekr11e5G0dby6PpwC+5V4Hoo32nOGWc5rJf7OH8WC4Ij/pWvmlFAxO3L5
NAd6MaYf12dVkhci2tM6ktfL/LD2A4esKNprLH/aaFYUxZUyW7byRHDv7Ibf
dwtvqvLL8J9ofdIRrtY7JvPFDfbL7bv1xdTY2pBnE1WyN2TSz0xNddjRDQtS
0aSVbGLbY3rdlopZQw3P605/MaHbRbkfrsRLWOIb9SE/PfjBWvblQ4365NRr
RfyYu/Wllvs/tXJvs0uF93zmzxYh9zVPZoo5tTCtKX9mSykfqx3xsDKPJvOw
pmUtAvdZpz3R/3ieSUTQP9vk5ZjAd7IJEzss32ud9lFKzLVQmnOi5X8esLTC
/3VVK/hs7jbHhOX3K83tMLZf1+vXzM19cV78s2OPE5Z/1Gg2jKOz77kqyvMN
l2A7x/QWWt7nmFd43LzLu/aWlve/pjd49zmb+9WYaepcZb5Iynmew1LPkzfT
8tnkid4nHyS24vP8o28p6nvCVt/o+Grr1np34bPMM86mEcuOEbX6cbz2Oc9O
3MdxHvzwuxk1LL/ZWLZ/nvNxjOntyfF8i39nWMdajblyvZVbyybtsXotY4YX
Ze1FZw886T4PYmCtZTsEr33vU16PXVpvNBsHQz2zzMHRvNaumTwpu7LCD7SX
93uUAexBCMleirb3Wvs42UPGsdAxkctRa8X70Rk4yj8ws1bSWN04WNOU4e97
e+6sdSsqnptjhMUjWJZxKQsCO72fZhG3snVbWcmlvpWVvO3PIZFfyvOZP86E
evppp3PR9Hjxl9NVf26t5Li1Kr+6+r4J9+/A9Wur6y8Cvdy/Y1y/u2592/5u
Bq6+ulMOV9Wr+9CLXp+4giDWEOMe34Hy84Qec5JjfYxavUjaR/rvBev/sOt1
OyoHs21E4zehrJ3O2NKdGPTYGvI7CNJjTE7oJcaJEQ6UF/ktgB5XIC+9zLn9
jIAzI+7FWq5tEbWBqzBKg3xQGuGL3sMon6sGH+2NUesH8mO7i0uZfHDG/7aq
fWwNnwiGJmbnuKKUyJ+NBuPH8h2z93jsn2bDbHRK+PlGST896BbUuqXWYjF2
nbe+CmCLbPQivDGzYnQk9d7rbbH3TxzVEt6+EW594m2xtZfF7OF+iGk4pUvp
2agj3YlBp2k9lU/o2WhdctL5tIXZUfApewHKuDvHd+dd88P7yA8jdWxNYvIx
9BLjx95wTxtrlNp1/4XVN65gEkNFP0UtOuylhfK57GwP6Z4ldJrW2npLVVts
TNhKEh3j2vwYMhl3n2xlZ/IhP3w3iPLDcreSb82bgvBitoLaq0Vn2TRq4xln
e0h3g9BZNn3aaUvzjAk2aTb/+uuvZ/2nXQm68qrexcr1UEqMOD8ucl0KyoMz
6iGhf7pJMWPl9Zg8i8rt5cqF5Zcaba54H8q4irP796CMu1J2/wMi9cud1LgO
vQtl7BW7/0so45zA7r9HpNZ3hJPUk9SPotQyQ92Eb89bfQ26qwadtdKz9pDu
opPOpy3mIcUy08au+eEemmkP70flQ37sPZPxm0ZJ0+r5GCUryuF5j4pEKUrp
tffMNEoR1TbSR7WrRzkwMsW4sEhZtD5qaWx57k69fsx6vWw2PQXy/V3ndfHW
3Q7y6X9/1Kw+HIEgcT/ZySByAK8LMkGuIzLhOLmfXpeyIBH63HtdvEvHjBXF
7ss56FiDchn0q+W96PWJnmlcu1nEn9XHZwGfLYZYwCgW+uuwPt7H+Ojvul7L
2ozeOtxZRSP4UXpcG1E7FoLBokdtaVnvh+ixPiISZE3uz6jB3kqEnkVrvBH6
Uj5YRu1aCAbGB7V8nMlH6HCUccf1rqntIcsvjbyX8sNnA7XPkAuMH44C3o/y
wzLOTKhv36hEVoVoFL0m74sqld4CQy34eOtrFWZSz+ONXHS8AfK2R1TOpGgv
RyP0OXRt8aQZRiBYdNeS7yhdiijAtVHXDluBSiPptfnhLFRbPuQ/tnzvmKOS
+gCiEfhcuuuF7Wk4jpL27qnaYet5aaS8Nj+0idrysTN4a8vXefbV9ddje1aE
PZeO2RBrz7LZ3Pb6J1pH5w1HsPcpYrxv8rDI/b7ph93fpRweZATue3/daM/4
z6EcjcD/itxn/JH+N52UuD68BeVoZPIdcp/xR3p95zVJOUm5j1LKzCN+3Wjk
OpcO/c7R9o4z6aQ939skcmd7xWjssjY/trcrlQ/Ltfs7jcr5GRXxykdHg3nV
S+k97zeR9rX3rRL5N73y6J1j1BihidZn2mH8sRyV58Op149Zr9sVN30Dxwi3
dR1/z4L1Twif33etN6sPj5S3b/yI/Ws7s4Tr4nF9EcoS+T5t9Ih4ej2lE/6y
Q0k9wlYEXY8a6D760wAH/eqymIMuQyT+rXOIxFQiMuh8u6v0d9/oI2a/icX7
p+Q+RuIQ78Ji6lifxfixjE89+hc7L4K5O2C/BcSYN6NnMXfcu3izFljts5g7
o49iBtjuysp60HmK6O/Dtd+TzxWt4Q6S8fHG6rWcDG2RZT9g8lix+iifXAwC
3sdRs7IoPKWOGmoJtR2NpTN+0Vg/RsmiWRSYfCzWH+VXim1AfhrCZIifPspd
L5xrWTTuHuEdxQscurj4sjP45PbhBQp4F+tE563vNVjmB91aBL0lOAUvfgDp
vHiFI6hvZWiw2kO8gpcuiqtI2xN6jU7XKkO/R/ECtTMXsF+NR/nVxoOwWH1t
+VgmiT5BqYW3SLHYSFUzU8KVTLpcXMiVTDpsz/q1/ULVKrPNKG6hdoYEhn2O
8quNS2GIydrysYwVXfZKE/fBnp1aGRmOM+ly8SnHmXTYnvXs9DNSFC/ixTuU
4hD2LePB0Z7Jsy+4HibHrvAzpfqIZujodo17h1N5m9x/E8rd3LF3eIGfkfs/
gbK+g556MfVi6oWNs5Eokhe/kptZ4jCTLhcPJHRRXA+2Z2Xc0LXKogNRZETt
XAXMTx7lVxv5wqITteVjuSOmUfZo8dEYZW+EkOFvSjNeREePtR/FL0VHJ9q+
lTGkjxCiZ5tpP5pd4XawPvJn2mTR7Ch/pL86aWnSUlUtCR5KPFriMbIygbxk
XL8N9Hgd8VNY/3pSFhEjZ5pIhEV2bJI55BZcxzNK5PoSrssO8BT4XIPrV+H6
1bVU3mheJEdHBGm127NOytFeERniOKl2fFPrV3FCSRnRhRjlx/rsNBN8+l4m
9dnshPLgLpXhsLB+j++z8o4xaoZCRr81o2enm7C8Y+x0leguDuXHmH8Up2XR
6zgp1KbMOcg1mtPkZiYf6xQUHBXGxzqVBUcnipOSfqHV5uK2GB/9PVHL2DL0
TEVzouCMEeXHTkthETk9amTzYxFXhmvC/uIMXorjYvz0UdZPVdEQdrXyquC+
No+371SVPN6+02D0NTwPJ6X+lmEkfJePt24tctKL4IC851fJjPt8Bl2Kczpx
0uHJMtcCdKmcUbprhE7XKq5fOHOV5lUpxV0xfrVPoInKx7AtpTizOjgpeUNM
v5FKwxHhyTC5dLkn2HjbQ1xWFAeWh5NiOYRK87uU4q4Yv9on3UTlYziuUpxZ
HZyUnFzDnh12Ak0uXe5JOd72EJcVxYHl4aS8J8QwXMmu8rXsCrdVW559OTln
bDzbvpwkNOGk2j8nnNTUi6kXj3cvZGWQKFE0z08UX4V0uSf+5OK5ou3l4aRw
pmXvHKVnsNTmV/vMmdqIoVL56uCkplF+FEfZihB6/AZDEcIozio6elGcVinO
K9p+DCfFsCEsVw7rbe1TbqJYG8bfh22ZtDRpqZaWls02Tqn9xpORrOvWCUsW
3grrl+KkMJ+UfJ82+s5xCWWsjzu/tv48KSPeCnfQt9dSjZHLKYJRWgbqjpXL
qZxD+alQ/YiwfFIMdcieVkRNRlGQ7GlFXBU7SYadSYXt9adLe9HiUbR0dBfC
MvuMhda2cFb4DsDo2RlYVv+7zA3hfFJa7suhHTPjF8UpsUw9pfKx0fPisVg8
PfcMLqavbu4J55timQjYKEQjdsgPo9/RTAlRKynFZbGIbxQ3xk61QX76KEdy
QuWdUhVpIQ+bpOeeiuwk8voQ2SdEsVsDmOpizFkED4+8dSvS8km13xHcUvvt
xS0dQf1oe2leKC9div/y0uF5Ylb/dK3Wzhs1Nn6pdp6nUjxZKR6q9jliPdaf
5aGK5mnKxTvl5oWK4sC8OKncc8ZOVK0yvFFpHqXa+KXaeZ5K8WSleKja55n1
3iCWhyqapykX75SbFyqKA/PipHLPO+tnJH0vcn7yLe0KR8TyUO1L3qfaOKJ9
a9+Lc6t9Xls3h23NQQwvVRsPFb2P7Xe+3631kuFCauM+ovexfX3HPPVi6sXU
C553KpqXKYpvOmz0KFYtfFMtOu95crpWa2cQqo1kiUYpxkayjM2v9IS0aZTH
GJX9HOUpkliHPvfcvD6SyHIF7XvUO1o/etba7UlLk5aqagnzTmFeKMRHvQRl
lkfKum6d29fhRlYievBUXzb6TvZVKGM+KtyJ4nWp/9a6lbKoaHkWqAiyKCJD
JGrZa+OrJvZkRZGHpSdcsieleweb/al5uOK133ICK/pLvDuAEyd96QrKdgCM
3mr/jbVW8O5QmcUQGZYGvWfRmGQ011Ip1icaB0F+P87Scmn0CrUczTQRzYlU
ir1h/Jh8eVrWcwiVYF+wH5EWauYqqol9ibTg60PeaEkOH4YxwTFAugh2Yz6L
Y0yQzmqv18L11d27q2/ETDCtYGQvihHBqDvjVxszEcWIMH5Mvh90Wkcud0mv
PaPgiUNjJAvpcrERXgwH0lntdfrocpq0N9urh8n3Ki1H92lrS71+8ZNPs5oK
5gmXNsK2WJXlu6W+oHBNW13g/ZWcbFywzDJCsXEvzVhVipKIokIYPybf93uV
rzTf/n8gw9rIZz3wW1f1uvpVNZ9OEUd+df1/RCbU1uJheba1+8PZR4soe+YN
tDuky8WFePErSGe118+uZ2Yv+CRsjM0R5V5qD/JGifsd1W6gLDNdjTw13nra
DmtMufYF91ELh1NLnqheXms6e1w0YrLNw5UU5VuY1pxv47Kab9l09adLrEp7
qtjc+j6U0dPAcDvsPuJ2Xm9w7hNPk60b2T1t9Fu7ppUj82fBSBXKM7g+sv3a
u1DGdzuGzmD3EZ3Rv5OlYyhzerr7lB3tgXFP+rxZW35DIPtZ68la76Y3nm9s
R9tppDLl7pDPXuOoF3yjG/DPJLW0TO/71++2r60tyHuZhjdu76f7r/3vVdSz
cz6klF0Dw1BpPkAtMhXFJnkxVEhntZenhWi0hGknGj0pRYdE0TDR6Mqk5bPV
8hThwwjff4K937fo7VtTL/asFy0eQMOQWLl3EPuB9REr0v1iYdWk4D5mT/wf
8nNEkg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{550, 270},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->652555914]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["Truncate"], "InlineFormula"],
 " also works on graphics objects:"
}], "ExampleText",
 CellID->1099728436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Truncate", "[", 
  RowBox[{"PolyhedronData", "[", 
   RowBox[{"\"\<Icosidodecahedron\>\"", ",", " ", "\"\<Image\>\""}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1891557770],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 187},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->535258383]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32366],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolyhedronData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyhedronData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Geodesate",
    BaseStyle->"Link",
    ButtonData->"paclet:PolyhedronOperations/ref/Geodesate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Stellate",
    BaseStyle->"Link",
    ButtonData->"paclet:PolyhedronOperations/ref/Stellate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenTruncate",
    BaseStyle->"Link",
    ButtonData->"paclet:PolyhedronOperations/ref/OpenTruncate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25386]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14239],

Cell[TextData[ButtonBox["PolyhedronOperations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PolyhedronOperations/tutorial/PolyhedronOperations"]], "Tutorials",
 CellID->8614]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Truncate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 12.3931202}", "context" -> 
    "PolyhedronOperations`", "keywords" -> {}, "index" -> True, "label" -> 
    "Polyhedron Operations Package Symbol", "language" -> "en", "paclet" -> 
    "PolyhedronOperations Package", "status" -> "None", "summary" -> 
    "Truncate[expr] truncates each edge of each polygon in graphics \
expression expr. Truncate[expr, ratio] truncates to the specified ratio of \
the edge length.", "synonyms" -> {}, "title" -> "Truncate", "type" -> 
    "Symbol", "uri" -> "PolyhedronOperations/ref/Truncate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4359, 150, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->637031458]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21451, 529}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1640, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2263, 67, 45, 1, 70, "ObjectName",
 CellID->4805],
Cell[2311, 70, 868, 28, 70, "Usage",
 CellID->29789]
}, Open  ]],
Cell[CellGroupData[{
Cell[3216, 103, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3694, 120, 177, 6, 70, "Notes",
 CellID->10334],
Cell[3874, 128, 305, 10, 70, "Notes",
 CellID->19516],
Cell[4182, 140, 140, 5, 70, "Notes",
 CellID->512546019]
}, Closed]],
Cell[CellGroupData[{
Cell[4359, 150, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->637031458],
Cell[CellGroupData[{
Cell[4744, 164, 148, 5, 70, "ExampleSection",
 CellID->300797335],
Cell[4895, 171, 145, 4, 70, "Input",
 CellID->331620859],
Cell[5043, 177, 133, 4, 70, "ExampleText",
 CellID->590121926],
Cell[CellGroupData[{
Cell[5201, 185, 193, 5, 28, "Input",
 CellID->1212219481],
Cell[5397, 192, 7846, 133, 291, "Output",
 Evaluatable->False,
 CellID->652555914]
}, Open  ]],
Cell[13258, 328, 136, 4, 70, "ExampleText",
 CellID->1099728436],
Cell[CellGroupData[{
Cell[13419, 336, 214, 6, 28, "Input",
 CellID->1891557770],
Cell[13636, 344, 4731, 82, 208, "Output",
 Evaluatable->False,
 CellID->535258383]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18428, 433, 311, 9, 70, "SeeAlsoSection",
 CellID->32366],
Cell[18742, 444, 1026, 35, 70, "SeeAlso",
 CellID->25386]
}, Open  ]],
Cell[CellGroupData[{
Cell[19805, 484, 314, 9, 70, "TutorialsSection",
 CellID->14239],
Cell[20122, 495, 174, 4, 70, "Tutorials",
 CellID->8614]
}, Open  ]],
Cell[20311, 502, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

