(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     87462,       2083]
NotebookOptionsPosition[     82679,       1929]
NotebookOutlinePosition[     84400,       1971]
CellTagsIndexPosition[     84357,       1968]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["POLYHEDRON OPERATIONS PACKAGE TUTORIAL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"First" :> Documentation`HelpLookup["paclet:ref/First"], 
         "Geodesate" :> 
         Documentation`HelpLookup[
          "paclet:PolyhedronOperations/ref/Geodesate"], "GraphicsComplex" :> 
         Documentation`HelpLookup["paclet:ref/GraphicsComplex"], "Line" :> 
         Documentation`HelpLookup["paclet:ref/Line"], "OpenTruncate" :> 
         Documentation`HelpLookup[
          "paclet:PolyhedronOperations/ref/OpenTruncate"], "Polygon" :> 
         Documentation`HelpLookup["paclet:ref/Polygon"], "PolyhedronData" :> 
         Documentation`HelpLookup["paclet:ref/PolyhedronData"], "Stellate" :> 
         Documentation`HelpLookup["paclet:PolyhedronOperations/ref/Stellate"],
          "Truncate" :> 
         Documentation`HelpLookup[
          "paclet:PolyhedronOperations/ref/Truncate"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"First\"\>", 2->"\<\"Geodesate\"\>", 
      3->"\<\"GraphicsComplex\"\>", 4->"\<\"Line\"\>", 
      5->"\<\"OpenTruncate\"\>", 6->"\<\"Polygon\"\>", 
      7->"\<\"PolyhedronData\"\>", 8->"\<\"Stellate\"\>", 
      9->"\<\"Truncate\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Polyhedron Operations Package", "Title",
 CellID->516],

Cell[TextData[{
 "A Platonic solid is a convex polyhedron whose faces and vertices are all of \
the same type. There are five such solids. There are also a few nonconvex \
polyhedra known that have faces and vertices all of the same type. This \
package contains functionality for modifying some of the properties of the \
polyhedra available in ",
 Cell[BoxData[
  ButtonBox["PolyhedronData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolyhedronData"]], "InlineFormula"],
 "."
}], "Text",
 CellID->21936],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell["Tetrahedron"], Cell["Cube"]},
    {Cell["Octahedron"], Cell["Dodecahedron"]},
    {Cell["Icosahedron"], Cell["Hexahedron"]},
    {Cell["GreatDodecahedron"], Cell["SmallStellatedDodecahedron"]},
    {Cell["GreatStellatedDodecahedron"], Cell["GreatIcosahedron"]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21274],

Cell["Some of the available polyhedra.", "Caption",
 CellID->11522],

Cell["This loads the package. ", "MathCaption",
 CellID->18417],

Cell[BoxData[
 RowBox[{"<<", "PolyhedronOperations`"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23516],

Cell["This displays a dodecahedron centered at the origin. ", "MathCaption",
 CellID->5602],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", "\"\<Dodecahedron\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23212],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{0, 0, (Rational[9, 8] + Rational[3, 8] 5^Rational[1, 2])^
      Rational[1, 2]}, {
     0, 0, Rational[-1, 2] (Rational[3, 2] (3 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {(Rational[1, 8] + Rational[-1, 24] 5^Rational[1, 2])^
      Rational[1, 2], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), (Rational[1, 8] + 
       Rational[1, 24] 5^Rational[1, 2])^
      Rational[1, 2]}, {(Rational[1, 8] + Rational[-1, 24] 5^Rational[1, 2])^
      Rational[1, 2], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), (Rational[1, 8] + 
       Rational[1, 24] 5^Rational[1, 2])^
      Rational[1, 2]}, {(Rational[1, 8] + Rational[1, 24] 5^Rational[1, 2])^
      Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
      Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {(Rational[1, 8] + Rational[1, 24] 5^Rational[1, 2])^
      Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
      Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {(Rational[5, 8] + Rational[5, 24] 5^Rational[1, 2])^
      Rational[1, 2], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[1, 8] + 
       Rational[1, 24] 5^Rational[1, 2])^
      Rational[1, 2]}, {(Rational[5, 8] + Rational[5, 24] 5^Rational[1, 2])^
      Rational[1, 2], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[1, 8] + 
       Rational[1, 24] 5^Rational[1, 2])^
      Rational[1, 2]}, {-(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
       Rational[1, 2], 
      Rational[-1, 2], (Rational[1, 8] + Rational[1, 24] 5^Rational[1, 2])^
      Rational[1, 2]}, {-(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
       Rational[1, 2], Rational[
      1, 2], (Rational[1, 8] + Rational[1, 24] 5^Rational[1, 2])^
      Rational[1, 2]}, {(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
      Rational[1, 2], Rational[-1, 2], 
      Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
      Rational[1, 2], Rational[1, 2], 
      Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {-(Rational[1, 6] (3 + 5^Rational[1, 2]))^
       Rational[1, 2], 0, 
      Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[5, 24] 5^Rational[1, 2])^Rational[1, 2]}, {
     Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[5, 24] 5^Rational[1, 2])^
      Rational[1, 2]}, {(Rational[1, 6] (3 + 5^Rational[1, 2]))^
      Rational[1, 2], 0, (Rational[5, 8] + Rational[5, 24] 5^Rational[1, 2])^
      Rational[1, 2]}, {
     Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), 
      Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), 
      Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), 
      Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), 
      Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
       Rational[1, 2]}}, {{0, 0, 1.4012585384440737`}, {
     0, 0, -1.4012585384440737`}, {0.17841104488654497`, -1.3090169943749475`,
      0.46708617948135783`}, {0.17841104488654497`, 1.3090169943749475`, 
     0.46708617948135783`}, {
     0.46708617948135783`, -0.8090169943749475, -1.0444364486709836`}, {
     0.46708617948135783`, 0.8090169943749475, -1.0444364486709836`}, {
     1.0444364486709836`, -0.8090169943749475, 0.46708617948135783`}, {
     1.0444364486709836`, 0.8090169943749475, 
     0.46708617948135783`}, {-1.2228474935575286`, -0.5, 
     0.46708617948135783`}, {-1.2228474935575286`, 0.5, 
     0.46708617948135783`}, {
     1.2228474935575286`, -0.5, -0.46708617948135783`}, {1.2228474935575286`, 
     0.5, -0.46708617948135783`}, {-0.9341723589627157, 
      0, -1.0444364486709836`}, {-0.46708617948135783`, -0.8090169943749475, 
     1.0444364486709836`}, {-0.46708617948135783`, 0.8090169943749475, 
     1.0444364486709836`}, {
     0.9341723589627157, 0, 
      1.0444364486709836`}, {-1.0444364486709836`, -0.8090169943749475, \
-0.46708617948135783`}, {-1.0444364486709836`, 
     0.8090169943749475, -0.46708617948135783`}, {-0.17841104488654494`, \
-1.3090169943749475`, -0.46708617948135783`}, {-0.17841104488654494`, 
     1.3090169943749475`, -0.46708617948135783`}}], 
   Polygon3DBox[{{15, 10, 9, 14, 1}, {2, 6, 12, 11, 5}, {5, 11, 7, 3, 19}, {
    11, 12, 8, 16, 7}, {12, 6, 20, 4, 8}, {6, 2, 13, 18, 20}, {2, 5, 19, 17, 
    13}, {4, 20, 18, 10, 15}, {18, 13, 17, 9, 10}, {17, 19, 3, 14, 9}, {3, 7, 
    16, 1, 14}, {16, 8, 4, 15, 1}}]],
  ImageMargins->0.,
  ImageSize->Medium,
  ViewAngle->Automatic,
  ViewCenter->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 ImageSize->{364, 417},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1182430349,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "This displays two polyhedra simultaneously. The diameter of the icosahedron \
is reduced by a factor of ",
 StyleBox["0.15", "MR"],
 " and its center is moved to the point ",
 StyleBox["{3,", "MR"],
 " ",
 StyleBox["3,", "MR"],
 " ",
 StyleBox["3}", "MR"],
 ". "
}], "MathCaption",
 CellID->30717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
    "PolyhedronData", "[", "\"\<GreatStellatedDodecahedron\>\"", "]"}], ",", 
    RowBox[{"Graphics3D", "[", 
     RowBox[{"Scale", "[", 
      RowBox[{
       RowBox[{"Translate", "[", 
        RowBox[{
         RowBox[{"PolyhedronData", "[", 
          RowBox[{"\"\<Icosahedron\>\"", ",", "\"\<Faces\>\""}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "3", ",", "3"}], "}"}]}], "]"}], ",", "0.15"}], 
      "]"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->30681],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 189},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->6460985]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Stellate",
      BaseStyle->"Link",
      ButtonData->"paclet:PolyhedronOperations/ref/Stellate"], "[", 
     RowBox[{
      ButtonBox["PolyhedronData",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PolyhedronData"], "[", 
      StyleBox["polyname", "TI"], "]"}], "]"}], Cell[
    "display a stellated polyhedron", "TableText"]},
   {
    RowBox[{
     ButtonBox["Stellate",
      BaseStyle->"Link",
      ButtonData->"paclet:PolyhedronOperations/ref/Stellate"], "[", 
     RowBox[{
      RowBox[{
       ButtonBox["PolyhedronData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PolyhedronData"], "[", 
       StyleBox["polyname", "TI"], "]"}], ",", 
      StyleBox["ratio", "TI"]}], "]"}], Cell[TextData[{
     "display a stellated polyhedron with stellation ratio ",
     Cell[BoxData[
      StyleBox["ratio", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Geodesate",
      BaseStyle->"Link",
      ButtonData->"paclet:PolyhedronOperations/ref/Geodesate"], "[", 
     RowBox[{
      RowBox[{
       ButtonBox["PolyhedronData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PolyhedronData"], "[", 
       StyleBox["polyname", "TI"], "]"}], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "display the projection of the order ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " regular tessellation of each face of the polyhedron onto the \
circumscribed sphere"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Geodesate",
      BaseStyle->"Link",
      ButtonData->"paclet:PolyhedronOperations/ref/Geodesate"], "[", 
     RowBox[{
      RowBox[{
       ButtonBox["PolyhedronData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PolyhedronData"], "[", 
       StyleBox["polyname", "TI"], "]"}], ",", 
      StyleBox["n", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["z", "TI"]}], "}"}], ",", 
      StyleBox["radius", "TI"]}], "]"}], Cell[TextData[{
     "display the projection of the order ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " regular tessellation of each face of the polyhedron onto the \
circumscribed sphere having center ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["z", "TI"]}], "}"}]], "InlineFormula"],
     " and size ",
     Cell[BoxData[
      StyleBox["radius", "TI"]], "InlineFormula"],
     "."
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Truncate",
      BaseStyle->"Link",
      ButtonData->"paclet:PolyhedronOperations/ref/Truncate"], "[", 
     RowBox[{
      ButtonBox["PolyhedronData",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PolyhedronData"], "[", 
      StyleBox["polyname", "TI"], "]"}], "]"}], Cell[
    "display a truncated polyhedron", "TableText"]},
   {
    RowBox[{
     ButtonBox["Truncate",
      BaseStyle->"Link",
      ButtonData->"paclet:PolyhedronOperations/ref/Truncate"], "[", 
     RowBox[{
      RowBox[{
       ButtonBox["PolyhedronData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PolyhedronData"], "[", 
       StyleBox["polyname", "TI"], "]"}], ",", 
      StyleBox["ratio", "TI"]}], "]"}], Cell[TextData[{
     "display a truncated polyhedron with the polygon edges truncated by the \
ratio ",
     Cell[BoxData[
      StyleBox["ratio", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["OpenTruncate",
      BaseStyle->"Link",
      ButtonData->"paclet:PolyhedronOperations/ref/OpenTruncate"], "[", 
     RowBox[{
      ButtonBox["PolyhedronData",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PolyhedronData"], "[", 
      StyleBox["polyname", "TI"], "]"}], "]"}], Cell["\<\
display a truncated polyhedron without the polygons that close the truncated \
vertices\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["OpenTruncate",
      BaseStyle->"Link",
      ButtonData->"paclet:PolyhedronOperations/ref/OpenTruncate"], "[", 
     RowBox[{
      RowBox[{
       ButtonBox["PolyhedronData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PolyhedronData"], "[", 
       StyleBox["polyname", "TI"], "]"}], ",", 
      StyleBox["ratio", "TI"]}], "]"}], Cell[TextData[{
     "display a truncated polyhedron with edges truncated by the ratio ",
     Cell[BoxData[
      StyleBox["ratio", "TI"]], "InlineFormula"],
     " without the polygons that close the truncated vertices"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->410783112],

Cell["Transformation functions for polyhedra.", "Caption",
 CellID->2019321926],

Cell[TextData[{
 "The polyhedra are by default centered at the origin with a unit distance \
from the origin to the midpoint of the edges. Any of the convex solids can be \
stellated using ",
 Cell[BoxData[
  ButtonBox["Stellate",
   BaseStyle->"Link",
   ButtonData->"paclet:PolyhedronOperations/ref/Stellate"]], 
  "InlineFormula"],
 ". This replaces each of the polygon faces by a pyramid with the polygon as \
its base. The user can also adjust the stellation ratio. Note that ratios \
less than ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula"],
 " give concave figures and that the default value of this ratio is ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["Geodesate",
   BaseStyle->"Link",
   ButtonData->"paclet:PolyhedronOperations/ref/Geodesate"]], 
  "InlineFormula"],
 " triangulates five\[Hyphen]sided or greater polygons before projecting onto \
the circumscribed sphere. If the order ",
 StyleBox["n", "TI"],
 " of the regular tessellation of each face is not given, a default value of \
",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineFormula"],
 " is assumed. The default position of the sphere is ",
 StyleBox["{0,0,0}", "MR"],
 " with radius ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["Truncate",
   BaseStyle->"Link",
   ButtonData->"paclet:PolyhedronOperations/ref/Truncate"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["OpenTruncate",
   BaseStyle->"Link",
   ButtonData->"paclet:PolyhedronOperations/ref/OpenTruncate"]], 
  "InlineFormula"],
 " act on every polygon and truncate at each vertex of the polygon. The \
default value of the truncation ratio is ",
 Cell[BoxData[
  FormBox["0.3", TraditionalForm]], "InlineFormula"],
 ". "
}], "Text",
 CellID->32196],

Cell[TextData[{
 "Here is a stellated octahedron with stellation ratio equal to ",
 Cell[BoxData[
  FormBox["4.0", TraditionalForm]], "InlineFormula"],
 ". This gives very long points. "
}], "MathCaption",
 CellID->22478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Stellate", "[", 
  RowBox[{
   RowBox[{"PolyhedronData", "[", "\"\<Octahedron\>\"", "]"}], ",", "4.0"}], 
  "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->19088],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{Rational[-1, 2], Rational[-1, 2], 0}, {
     Rational[-1, 2], Rational[1, 2], 0}, {0, 0, -2^Rational[-1, 2]}, {
     0, 0, 2^Rational[-1, 2]}, {Rational[1, 2], Rational[-1, 2], 0}, {
     Rational[1, 2], Rational[1, 2], 0}, {
     1.3333333333333333`, 0, 0.9428090415820632}, {
     0, 1.3333333333333333`, 0.9428090415820632}, {-1.3333333333333333`, 0, 
      0.9428090415820632}, {0, -1.3333333333333333`, 0.9428090415820632}, {
     0, -1.3333333333333333`, -0.9428090415820632}, {
     1.3333333333333333`, 0, -0.9428090415820632}, {-1.3333333333333333`, 
      0, -0.9428090415820632}, {
     0, 1.3333333333333333`, -0.9428090415820632}}, {{-0.5, -0.5, 0}, {-0.5, 
      0.5, 0}, {0, 0, -0.7071067811865475}, {0, 0, 0.7071067811865475}, {
     0.5, -0.5, 0}, {0.5, 0.5, 0}, {
     1.3333333333333333`, 0, 0.9428090415820632}, {
     0, 1.3333333333333333`, 0.9428090415820632}, {-1.3333333333333333`, 0, 
      0.9428090415820632}, {0, -1.3333333333333333`, 0.9428090415820632}, {
     0, -1.3333333333333333`, -0.9428090415820632}, {
     1.3333333333333333`, 0, -0.9428090415820632}, {-1.3333333333333333`, 
      0, -0.9428090415820632}, {
     0, 1.3333333333333333`, -0.9428090415820632}}], 
   Polygon3DBox[{{7, 4, 5}, {7, 5, 6}, {7, 6, 4}, {8, 4, 6}, {8, 6, 2}, {8, 2,
     4}, {9, 4, 2}, {9, 2, 1}, {9, 1, 4}, {10, 4, 1}, {10, 1, 5}, {10, 5, 
    4}, {11, 5, 1}, {11, 1, 3}, {11, 3, 5}, {12, 5, 3}, {12, 3, 6}, {12, 6, 
    5}, {13, 3, 1}, {13, 1, 2}, {13, 2, 3}, {14, 6, 3}, {14, 3, 2}, {14, 2, 
    6}}]]]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->1623097559,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
Here is an example of a polyhedron that is triangulated before being \
projected onto the circumscribed sphere. \
\>", "MathCaption",
 CellID->31968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Geodesate", "[", 
  RowBox[{
   RowBox[{"PolyhedronData", "[", "\"\<Dodecahedron\>\"", "]"}], ",", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->19029],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 196},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->215751433]
}, Open  ]],

Cell["\<\
Here is a an example of a polyhedron with edges truncated on each side by 40 \
percent. \
\>", "MathCaption",
 CellID->28128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Truncate", "[", 
  RowBox[{
   RowBox[{"PolyhedronData", "[", "\"\<Dodecahedron\>\"", "]"}], ",", ".4"}], 
  "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->1295],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 397},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->52434209]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OpenTruncate",
   BaseStyle->"Link",
   ButtonData->"paclet:PolyhedronOperations/ref/OpenTruncate"]], 
  "InlineFormula"],
 " allows you to view the interior of the truncated polyhedron. "
}], "MathCaption",
 CellID->17405],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OpenTruncate", "[", 
  RowBox[{
   RowBox[{"PolyhedronData", "[", "\"\<Dodecahedron\>\"", "]"}], ",", ".4"}], 
  "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->7041],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 397},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->376672760]
}, Open  ]],

Cell[TextData[{
 "You can extract the polygon list in the form of a ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 " from the object produced by ",
 Cell[BoxData[
  ButtonBox["PolyhedronData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolyhedronData"]], "InlineFormula"],
 " using ",
 Cell[BoxData[
  ButtonBox["First",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/First"]], "InlineFormula"],
 ". In addition, the \"",
 StyleBox["VertexCoordinates", "InlineCode"],
 "\", \"",
 StyleBox["Faces", "InlineCode"],
 "\", and \"",
 StyleBox["Edges", "InlineCode"],
 "\" properties available in ",
 Cell[BoxData[
  ButtonBox["PolyhedronData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolyhedronData"]], "InlineFormula"],
 " give you the vertex coordinates, a list of graphics primitives for each \
face of the polyhedra, and graphics primitives for the edges of a polyhedron \
respectively. "
}], "Text",
 CellID->17738],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["First",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/First"], "[", 
     RowBox[{
      ButtonBox["PolyhedronData",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PolyhedronData"], "[", 
      StyleBox["polyname", "TI"], "]"}], "]"}], Cell[TextData[{
     "give the ",
     Cell[BoxData[
      ButtonBox["GraphicsComplex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
     " representing the graphic of the named polyhedron"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PolyhedronData",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolyhedronData"], "[", 
     RowBox[{
      StyleBox["polyname", "TI"], ",", "\"\<VertexCoordinates\>\""}], "]"}], 
    Cell["\<\
give a list of the coordinates of the vertices of the polyhedron\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["PolyhedronData",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolyhedronData"], "[", 
     RowBox[{
      StyleBox["polyname", "TI"], ",", "\"\<Faces\>\""}], "]"}], Cell[
    TextData[{
     "give a list of the faces of the polyhedron as ",
     Cell[BoxData[
      ButtonBox["Polygon",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
     " primitives"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PolyhedronData",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolyhedronData"], "[", 
     RowBox[{
      StyleBox["polyname", "TI"], ",", "\"\<Edges\>\""}], "]"}], Cell[
    TextData[{
     "give a list of the edges of the polyhedron as ",
     Cell[BoxData[
      ButtonBox["Line",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Line"]], "InlineFormula"],
     " primitives"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->1200154176],

Cell["Getting vertex, face, and edge data.", "Caption",
 CellID->1824823408],

Cell[TextData[{
 "Here is the ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 " object for the tetrahedron centered at the origin. "
}], "MathCaption",
 CellID->12736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "[", 
  RowBox[{"PolyhedronData", "[", "\"\<Tetrahedron\>\"", "]"}], "]"}]], "Input",\

 CellLabel->"In[34]:=",
 CellID->24428],

Cell[BoxData[
 RowBox[{"GraphicsComplex", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{
        SqrtBox[
         FractionBox["2", "3"]], "-", 
        FractionBox["1", 
         RowBox[{"2", " ", 
          SqrtBox["6"]}]]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", 
         RowBox[{"2", " ", 
          SqrtBox["3"]}]]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", 
         RowBox[{"2", " ", 
          SqrtBox["6"]}]]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", 
         RowBox[{"2", " ", 
          SqrtBox["3"]}]]}], ",", 
       FractionBox["1", "2"], ",", 
       RowBox[{"-", 
        FractionBox["1", 
         RowBox[{"2", " ", 
          SqrtBox["6"]}]]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", 
        SqrtBox["3"]], ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["1", 
         RowBox[{"2", " ", 
          SqrtBox["6"]}]]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "2", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "4", ",", "3"}], "}"}]}], "}"}], "]"}]}], 
  "]"}]], "Output",
 ImageSize->{570, 76},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]=",
 CellID->1593055449]
}, Open  ]],

Cell["These are the vertices of the tetrahedron. ", "MathCaption",
 CellID->27254],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Tetrahedron\>\"", ",", "\"\<VertexCoordinates\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->21295],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{
      SqrtBox[
       FractionBox["2", "3"]], "-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["3"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["3"]}]]}], ",", 
     FractionBox["1", "2"], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["3"]], ",", "0", ",", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{587, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]=",
 CellID->1804304194]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Normal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normal"]], "InlineFormula"],
 " to transform a ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 " to a list of ",
 Cell[BoxData[
  ButtonBox["Polygon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
 " primitives."
}], "MathCaption",
 CellID->5791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"PolyhedronData", "[", 
   RowBox[{"\"\<Tetrahedron\>\"", ",", "\"\<Faces\>\""}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->9979],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["3"]}]]}], ",", 
         RowBox[{"-", 
          FractionBox["1", "2"]}], ",", 
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["6"]}]]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["3"]}]]}], ",", 
         FractionBox["1", "2"], ",", 
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["6"]}]]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["1", 
          SqrtBox["3"]], ",", "0", ",", 
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["6"]}]]}]}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["3"]}]]}], ",", 
         FractionBox["1", "2"], ",", 
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["6"]}]]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["3"]}]]}], ",", 
         RowBox[{"-", 
          FractionBox["1", "2"]}], ",", 
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["6"]}]]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{
          SqrtBox[
           FractionBox["2", "3"]], "-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["6"]}]]}]}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["1", 
          SqrtBox["3"]], ",", "0", ",", 
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["6"]}]]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{
          SqrtBox[
           FractionBox["2", "3"]], "-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["6"]}]]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["3"]}]]}], ",", 
         RowBox[{"-", 
          FractionBox["1", "2"]}], ",", 
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["6"]}]]}]}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{
          SqrtBox[
           FractionBox["2", "3"]], "-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["6"]}]]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["1", 
          SqrtBox["3"]], ",", "0", ",", 
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["6"]}]]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["3"]}]]}], ",", 
         FractionBox["1", "2"], ",", 
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["6"]}]]}]}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{542, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]=",
 CellID->1752772552]
}, Open  ]],

Cell["\<\
This gives the list of Line primitives representing the edges of the \
tetrahedron.\
\>", "MathCaption",
 CellID->1908190900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"PolyhedronData", "[", 
   RowBox[{"\"\<Tetrahedron\>\"", ",", "\"\<Edges\>\""}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[39]:=",
 CellID->1815095565],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{
          SqrtBox[
           FractionBox["2", "3"]], "-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["6"]}]]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["3"]}]]}], ",", 
         RowBox[{"-", 
          FractionBox["1", "2"]}], ",", 
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["6"]}]]}]}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{
          SqrtBox[
           FractionBox["2", "3"]], "-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["6"]}]]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["3"]}]]}], ",", 
         FractionBox["1", "2"], ",", 
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["6"]}]]}]}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{
          SqrtBox[
           FractionBox["2", "3"]], "-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["6"]}]]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["1", 
          SqrtBox["3"]], ",", "0", ",", 
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["6"]}]]}]}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["3"]}]]}], ",", 
         RowBox[{"-", 
          FractionBox["1", "2"]}], ",", 
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["6"]}]]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["3"]}]]}], ",", 
         FractionBox["1", "2"], ",", 
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["6"]}]]}]}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["3"]}]]}], ",", 
         RowBox[{"-", 
          FractionBox["1", "2"]}], ",", 
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["6"]}]]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["1", 
          SqrtBox["3"]], ",", "0", ",", 
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["6"]}]]}]}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["3"]}]]}], ",", 
         FractionBox["1", "2"], ",", 
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["6"]}]]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["1", 
          SqrtBox["3"]], ",", "0", ",", 
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["6"]}]]}]}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{378, 228},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[39]=",
 CellID->443672002]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Polyhedron Operations Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 20.1745694}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Polyhedron Operations Package Tutorial", "language" -> "en", "paclet" -> 
    "Polyhedron Operations Package", "status" -> "None", "summary" -> 
    "A Platonic solid is a convex polyhedron whose faces and vertices are all \
of the same type. There are five such solids. There are also a few nonconvex \
polyhedra known that have faces and vertices all of the same type. This \
package contains functionality for modifying some of the properties of the \
polyhedra available in PolyhedronData. Some of the available polyhedra. This \
loads the package. ", "synonyms" -> {}, "title" -> 
    "Polyhedron Operations Package", "type" -> "Tutorial", "uri" -> 
    "PolyhedronOperations/tutorial/PolyhedronOperations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1524, 30, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2149, 57, 60, 1, 70, "Title",
 CellID->516],
Cell[2212, 60, 512, 12, 70, "Text",
 CellID->21936],
Cell[2727, 74, 763, 18, 70, "DefinitionBox",
 CellID->21274],
Cell[3493, 94, 67, 1, 70, "Caption",
 CellID->11522],
Cell[3563, 97, 63, 1, 70, "MathCaption",
 CellID->18417],
Cell[3629, 100, 104, 3, 70, "Input",
 CellID->23516],
Cell[3736, 105, 91, 1, 70, "MathCaption",
 CellID->5602],
Cell[CellGroupData[{
Cell[3852, 110, 125, 3, 28, "Input",
 CellID->23212],
Cell[3980, 115, 12961, 227, 438, 5405, 99, "CachedBoxData", "BoxData", \
"Output",
 CellID->1182430349]
}, Open  ]],
Cell[16956, 345, 315, 12, 70, "MathCaption",
 CellID->30717],
Cell[CellGroupData[{
Cell[17296, 361, 586, 17, 47, "Input",
 CellID->30681],
Cell[17885, 380, 5397, 93, 210, "Output",
 Evaluatable->False,
 CellID->6460985]
}, Open  ]],
Cell[23297, 476, 4707, 139, 70, "DefinitionBox",
 CellID->410783112],
Cell[28007, 617, 79, 1, 70, "Caption",
 CellID->2019321926],
Cell[28089, 620, 1853, 53, 70, "Text",
 CellID->32196],
Cell[29945, 675, 221, 6, 70, "MathCaption",
 CellID->22478],
Cell[CellGroupData[{
Cell[30191, 685, 188, 6, 70, "Input",
 CellID->19088],
Cell[30382, 693, 5984, 103, 193, 1599, 27, "CachedBoxData", "BoxData", \
"Output",
 CellID->1623097559]
}, Open  ]],
Cell[36381, 799, 159, 4, 70, "MathCaption",
 CellID->31968],
Cell[CellGroupData[{
Cell[36565, 807, 189, 6, 28, "Input",
 CellID->19029],
Cell[36757, 815, 12076, 202, 217, "Output",
 Evaluatable->False,
 CellID->215751433]
}, Open  ]],
Cell[48848, 1020, 135, 4, 70, "MathCaption",
 CellID->28128],
Cell[CellGroupData[{
Cell[49008, 1028, 188, 6, 28, "Input",
 CellID->1295],
Cell[49199, 1036, 8399, 142, 418, "Output",
 Evaluatable->False,
 CellID->52434209]
}, Open  ]],
Cell[57613, 1181, 267, 8, 70, "MathCaption",
 CellID->17405],
Cell[CellGroupData[{
Cell[57905, 1193, 192, 6, 28, "Input",
 CellID->7041],
Cell[58100, 1201, 8806, 148, 418, "Output",
 Evaluatable->False,
 CellID->376672760]
}, Open  ]],
Cell[66921, 1352, 1022, 31, 70, "Text",
 CellID->17738],
Cell[67946, 1385, 1854, 59, 70, "DefinitionBox",
 CellID->1200154176],
Cell[69803, 1446, 76, 1, 70, "Caption",
 CellID->1824823408],
Cell[69882, 1449, 256, 8, 70, "MathCaption",
 CellID->12736],
Cell[CellGroupData[{
Cell[70163, 1461, 159, 5, 70, "Input",
 CellID->24428],
Cell[70325, 1468, 1686, 60, 97, "Output",
 CellID->1593055449]
}, Open  ]],
Cell[72026, 1531, 82, 1, 70, "MathCaption",
 CellID->27254],
Cell[CellGroupData[{
Cell[72133, 1536, 175, 5, 70, "Input",
 CellID->21295],
Cell[72311, 1543, 1171, 46, 62, "Output",
 CellID->1804304194]
}, Open  ]],
Cell[73497, 1592, 479, 18, 70, "MathCaption",
 CellID->5791],
Cell[CellGroupData[{
Cell[74001, 1614, 196, 6, 70, "Input",
 CellID->9979],
Cell[74200, 1622, 3953, 138, 180, "Output",
 CellID->1752772552]
}, Open  ]],
Cell[78168, 1763, 135, 4, 70, "MathCaption",
 CellID->1908190900],
Cell[CellGroupData[{
Cell[78328, 1771, 202, 6, 70, "Input",
 CellID->1815095565],
Cell[78533, 1779, 4092, 144, 249, "Output",
 CellID->443672002]
}, Open  ]]
}, Open  ]],
Cell[82652, 1927, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

