(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8502,        286]
NotebookOptionsPosition[      6807,        231]
NotebookOutlinePosition[      7799,        259]
CellTagsIndexPosition[      7756,        256]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["POLYTOPES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polytopes Package" :> 
          Documentation`HelpLookup["paclet:Polytopes/tutorial/Polytopes"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Polytopes Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NumberOfFaces" :> 
          Documentation`HelpLookup["paclet:Polytopes/ref/NumberOfFaces"], 
          "Area" :> Documentation`HelpLookup["paclet:Polytopes/ref/Area"], 
          "NumberOfVertices" :> 
          Documentation`HelpLookup["paclet:Polytopes/ref/NumberOfVertices"], 
          "NumberOfEdges" :> 
          Documentation`HelpLookup["paclet:Polytopes/ref/NumberOfEdges"], 
          "Vertices" :> 
          Documentation`HelpLookup["paclet:Polytopes/ref/Vertices"], 
          "InscribedRadius" :> 
          Documentation`HelpLookup["paclet:Polytopes/ref/InscribedRadius"], 
          "CircumscribedRadius" :> 
          Documentation`HelpLookup[
           "paclet:Polytopes/ref/CircumscribedRadius"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NumberOfFaces\"\>", 2->"\<\"Area\"\>", 
       3->"\<\"NumberOfVertices\"\>", 4->"\<\"NumberOfEdges\"\>", 
       5->"\<\"Vertices\"\>", 6->"\<\"InscribedRadius\"\>", 
       7->"\<\"CircumscribedRadius\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Faces", "ObjectName",
 CellID->22001],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Faces", "[", 
       StyleBox["polytope", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a list of the faces of ",
     Cell[BoxData[
      StyleBox["polytope", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27646]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Each face is a list of the numbers of the vertices that comprise that face.\
\>", "Notes",
 CellID->30186],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NumberOfFaces",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/NumberOfFaces"], "[", 
   StyleBox["polytope", "TI"], "]"}]], "InlineFormula"],
 " gives the number of faces of ",
 Cell[BoxData[
  StyleBox["polytope", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->3297]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26021],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberOfFaces",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/NumberOfFaces"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Area",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/Area"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberOfVertices",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/NumberOfVertices"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberOfEdges",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/NumberOfEdges"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Vertices",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/Vertices"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InscribedRadius",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/InscribedRadius"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CircumscribedRadius",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/CircumscribedRadius"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->688202114]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7928],

Cell[TextData[ButtonBox["Polytopes Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Polytopes/tutorial/Polytopes"]], "Tutorials",
 CellID->17452]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Faces - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 23.6434082}", "context" -> "Polytopes`", 
    "keywords" -> {}, "index" -> True, "label" -> "Polytopes Package Symbol", 
    "language" -> "en", "paclet" -> "Polytopes Package", "status" -> "None", 
    "summary" -> "Faces[polytope] gives a list of the faces of polytope. ", 
    "synonyms" -> {}, "title" -> "Faces", "type" -> "Symbol", "uri" -> 
    "Polytopes/ref/Faces"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1983, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2606, 72, 43, 1, 70, "ObjectName",
 CellID->22001],
Cell[2652, 75, 470, 15, 70, "Usage",
 CellID->27646]
}, Open  ]],
Cell[CellGroupData[{
Cell[3159, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3637, 112, 116, 3, 70, "Notes",
 CellID->30186],
Cell[3756, 117, 344, 12, 70, "Notes",
 CellID->3297]
}, Closed]],
Cell[CellGroupData[{
Cell[4137, 134, 311, 9, 70, "SeeAlsoSection",
 CellID->26021],
Cell[4451, 145, 1814, 62, 70, "SeeAlso",
 CellID->688202114]
}, Open  ]],
Cell[CellGroupData[{
Cell[6302, 212, 313, 9, 70, "TutorialsSection",
 CellID->7928],
Cell[6618, 223, 147, 3, 70, "Tutorials",
 CellID->17452]
}, Open  ]],
Cell[6780, 229, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

