(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7278,        239]
NotebookOptionsPosition[      5796,        192]
NotebookOutlinePosition[      6824,        221]
CellTagsIndexPosition[      6781,        218]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["POLYTOPES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polytopes Package" :> 
          Documentation`HelpLookup["paclet:Polytopes/tutorial/Polytopes"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Polytopes Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NumberOfFaces" :> 
          Documentation`HelpLookup["paclet:Polytopes/ref/NumberOfFaces"], 
          "NumberOfVertices" :> 
          Documentation`HelpLookup["paclet:Polytopes/ref/NumberOfVertices"], 
          "Vertices" :> 
          Documentation`HelpLookup["paclet:Polytopes/ref/Vertices"], "Area" :> 
          Documentation`HelpLookup["paclet:Polytopes/ref/Area"], 
          "InscribedRadius" :> 
          Documentation`HelpLookup["paclet:Polytopes/ref/InscribedRadius"], 
          "CircumscribedRadius" :> 
          Documentation`HelpLookup[
           "paclet:Polytopes/ref/CircumscribedRadius"], "Faces" :> 
          Documentation`HelpLookup["paclet:Polytopes/ref/Faces"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NumberOfFaces\"\>", 
       2->"\<\"NumberOfVertices\"\>", 3->"\<\"Vertices\"\>", 
       4->"\<\"Area\"\>", 5->"\<\"InscribedRadius\"\>", 
       6->"\<\"CircumscribedRadius\"\>", 
       7->"\<\"Faces\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NumberOfEdges", "ObjectName",
 CellID->23130],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NumberOfEdges", "[", 
       StyleBox["polytope", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the number of edges of ",
     Cell[BoxData[
      StyleBox["polytope", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22996]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22381],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberOfFaces",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/NumberOfFaces"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberOfVertices",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/NumberOfVertices"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Vertices",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/Vertices"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Area",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/Area"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InscribedRadius",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/InscribedRadius"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CircumscribedRadius",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/CircumscribedRadius"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Faces",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/Faces"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9335]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1446],

Cell[TextData[ButtonBox["Polytopes Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Polytopes/tutorial/Polytopes"]], "Tutorials",
 CellID->12954]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumberOfEdges - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 26.9716184}", "context" -> "Polytopes`", 
    "keywords" -> {}, "index" -> True, "label" -> "Polytopes Package Symbol", 
    "language" -> "en", "paclet" -> "Polytopes Package", "status" -> "None", 
    "summary" -> 
    "NumberOfEdges[polytope] gives the number of edges of polytope.", 
    "synonyms" -> {}, "title" -> "NumberOfEdges", "type" -> "Symbol", "uri" -> 
    "Polytopes/ref/NumberOfEdges"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1956, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2579, 72, 51, 1, 70, "ObjectName",
 CellID->23130],
Cell[2633, 75, 477, 15, 70, "Usage",
 CellID->22996]
}, Open  ]],
Cell[CellGroupData[{
Cell[3147, 95, 311, 9, 70, "SeeAlsoSection",
 CellID->22381],
Cell[3461, 106, 1793, 62, 70, "SeeAlso",
 CellID->9335]
}, Open  ]],
Cell[CellGroupData[{
Cell[5291, 173, 313, 9, 70, "TutorialsSection",
 CellID->1446],
Cell[5607, 184, 147, 3, 70, "Tutorials",
 CellID->12954]
}, Open  ]],
Cell[5769, 190, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

