(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7289,        238]
NotebookOptionsPosition[      5787,        191]
NotebookOutlinePosition[      6830,        220]
CellTagsIndexPosition[      6787,        217]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["POLYTOPES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polytopes Package" :> 
          Documentation`HelpLookup["paclet:Polytopes/tutorial/Polytopes"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Polytopes Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vertices" :> 
          Documentation`HelpLookup["paclet:Polytopes/ref/Vertices"], 
          "NumberOfEdges" :> 
          Documentation`HelpLookup["paclet:Polytopes/ref/NumberOfEdges"], 
          "NumberOfFaces" :> 
          Documentation`HelpLookup["paclet:Polytopes/ref/NumberOfFaces"], 
          "Area" :> Documentation`HelpLookup["paclet:Polytopes/ref/Area"], 
          "Faces" :> Documentation`HelpLookup["paclet:Polytopes/ref/Faces"], 
          "InscribedRadius" :> 
          Documentation`HelpLookup["paclet:Polytopes/ref/InscribedRadius"], 
          "CircumscribedRadius" :> 
          Documentation`HelpLookup[
           "paclet:Polytopes/ref/CircumscribedRadius"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Vertices\"\>", 2->"\<\"NumberOfEdges\"\>", 
       3->"\<\"NumberOfFaces\"\>", 4->"\<\"Area\"\>", 5->"\<\"Faces\"\>", 
       6->"\<\"InscribedRadius\"\>", 
       7->"\<\"CircumscribedRadius\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NumberOfVertices", "ObjectName",
 CellID->20056],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NumberOfVertices", "[", 
       StyleBox["polytope", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the number of vertices of ",
     Cell[BoxData[
      StyleBox["polytope", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32703]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27145],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Vertices",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/Vertices"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberOfEdges",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/NumberOfEdges"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberOfFaces",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/NumberOfFaces"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Area",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/Area"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Faces",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/Faces"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InscribedRadius",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/InscribedRadius"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CircumscribedRadius",
    BaseStyle->"Link",
    ButtonData->"paclet:Polytopes/ref/CircumscribedRadius"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->40616535]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13781],

Cell[TextData[ButtonBox["Polytopes Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Polytopes/tutorial/Polytopes"]], "Tutorials",
 CellID->17758]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumberOfVertices - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 27.3153772}", "context" -> "Polytopes`", 
    "keywords" -> {}, "index" -> True, "label" -> "Polytopes Package Symbol", 
    "language" -> "en", "paclet" -> "Polytopes Package", "status" -> "None", 
    "summary" -> 
    "NumberOfVertices[polytope] gives the number of vertices of polytope.", 
    "synonyms" -> {}, "title" -> "NumberOfVertices", "type" -> "Symbol", 
    "uri" -> "Polytopes/ref/NumberOfVertices"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1939, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2562, 71, 54, 1, 70, "ObjectName",
 CellID->20056],
Cell[2619, 74, 483, 15, 70, "Usage",
 CellID->32703]
}, Open  ]],
Cell[CellGroupData[{
Cell[3139, 94, 311, 9, 70, "SeeAlsoSection",
 CellID->27145],
Cell[3453, 105, 1791, 62, 70, "SeeAlso",
 CellID->40616535]
}, Open  ]],
Cell[CellGroupData[{
Cell[5281, 172, 314, 9, 70, "TutorialsSection",
 CellID->13781],
Cell[5598, 183, 147, 3, 70, "Tutorials",
 CellID->17758]
}, Open  ]],
Cell[5760, 189, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

