(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      4317,        152]
NotebookOptionsPosition[      2292,         93]
NotebookOutlinePosition[      3623,        127]
CellTagsIndexPosition[      3580,        124]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Primality Proving Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["ProvablePrimeQ",
  BaseStyle->"Link",
  ButtonData->"paclet:PrimalityProving/ref/ProvablePrimeQ"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " whether a number is prime or composite"
}], "GuideText",
 CellID->203374175],

Cell["\t", "GuideDelimiter",
 CellID->1703340162],

Cell[TextData[{
 Cell[TextData[ButtonBox["PrimeQCertificate",
  BaseStyle->"Link",
  ButtonData->"paclet:PrimalityProving/ref/PrimeQCertificate"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " give a certificate for primality or compositeness"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["PrimeQCertificateCheck",
  BaseStyle->"Link",
  ButtonData->"paclet:PrimalityProving/ref/PrimeQCertificateCheck"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " check whether a certificate is correct"
}], "GuideText",
 CellID->2081088224]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Primality Proving Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PrimalityProving/tutorial/PrimalityProving"]], "GuideTutorial",
 CellID->304247878]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Prime Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrimeNumbers"]], "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Primality Proving Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 34.8311946}", "context" -> "", 
    "keywords" -> {
     "primality testing", "provable prime", "prime certificate", 
      "prime certificate check"}, "index" -> True, "label" -> 
    "Primality Proving Package Guide", "language" -> "en", "paclet" -> 
    "PrimalityProving Package", "status" -> "None", "summary" -> 
    "ProvablePrimeQ -- whether a number is prime or composite, \
PrimeQCertificate -- give a certificate for primality or compositeness, \
PrimeQCertificateCheck -- check whether a certificate is correct", 
    "synonyms" -> {"PrimalityProving"}, "title" -> 
    "Primality Proving Package", "type" -> "Guide", "uri" -> 
    "PrimalityProving/guide/PrimalityProvingPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 67, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[689, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[748, 31, 294, 9, 70, "GuideText",
 CellID->203374175],
Cell[1045, 42, 49, 1, 70, "GuideDelimiter",
 CellID->1703340162],
Cell[1097, 45, 312, 9, 70, "GuideText",
 CellID->1463276848],
Cell[1412, 56, 311, 9, 70, "GuideText",
 CellID->2081088224]
}, Open  ]],
Cell[CellGroupData[{
Cell[1760, 70, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[1825, 73, 180, 4, 70, "GuideTutorial",
 CellID->304247878]
}, Open  ]],
Cell[CellGroupData[{
Cell[2042, 82, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[2107, 85, 143, 3, 70, "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],
Cell[2265, 91, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

