(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17058,        640]
NotebookOptionsPosition[     13612,        522]
NotebookOutlinePosition[     14888,        558]
CellTagsIndexPosition[     14803,        553]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PRIMALITY PROVING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Primality Proving Package" :> 
          Documentation`HelpLookup[
           "paclet:PrimalityProving/tutorial/PrimalityProving"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Primality Proving Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ProvablePrimeQ" :> 
          Documentation`HelpLookup[
           "paclet:PrimalityProving/ref/ProvablePrimeQ"], 
          "PrimeQCertificateCheck" :> 
          Documentation`HelpLookup[
           "paclet:PrimalityProving/ref/PrimeQCertificateCheck"], "PrimeQ" :> 
          Documentation`HelpLookup["paclet:ref/PrimeQ"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ProvablePrimeQ\"\>", 
       2->"\<\"PrimeQCertificateCheck\"\>", 
       3->"\<\"PrimeQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PrimeQCertificate", "ObjectName",
 CellID->19069],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PrimeQCertificate", "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a certificate that ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " is prime or that ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " is composite."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11599]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["PrimeQCertificate"], "InlineFormula"],
 " uses the Pratt certificate and the Atkin-Morain certificate for \
primality."
}], "Notes",
 CellID->1113415164],

Cell[TextData[{
 "A certificate of compositeness is a list of 3 integers, either ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    RowBox[{
     StyleBox["n", "TI"], "-", "1"}], ",", 
    StyleBox["n", "TI"]}], "}"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["a", "TI"], ",", "2", ",", 
    StyleBox["n", "TI"]}], "}"}]], "InlineFormula"],
 ", with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[LeftBracketingBar]", 
     StyleBox["a", "TI"], "\[RightBracketingBar]"}], "\[NotEqual]", "1"}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->20887],

Cell[TextData[{
 "A prime ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " always satisfies ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    StyleBox["a", "TI"], 
    RowBox[{
     StyleBox["p", "TI"], "-", "1"}]], "\[Congruent]", 
   RowBox[{"1", " ", 
    StyleBox["mod", "TR"], " ", 
    StyleBox["p", "TI"]}]}]], "InlineFormula"],
 ". The certificate ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    RowBox[{
     StyleBox["n", "TI"], "-", "1"}], ",", 
    StyleBox["n", "TI"]}], "}"}]], "InlineFormula"],
 " can be used to show that ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is composite by demonstrating that ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    StyleBox["a", "TI"], 
    RowBox[{
     StyleBox["n", "TI"], "-", "1"}]], "\[NotCongruent]", 
   RowBox[{"1", " ", 
    StyleBox["mod", "TR"], " ", 
    StyleBox["n", "TI"]}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9592],

Cell[TextData[{
 "Any number ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " whose square is ",
 Cell[BoxData[
  RowBox[{"1", 
   StyleBox["mod", "TR"], 
   StyleBox["  ", "TI"], 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " prime must satisfy ",
 Cell[BoxData[
  RowBox[{
   StyleBox["a", "TI"], "\[Congruent]", 
   RowBox[{
    RowBox[{"\[PlusMinus]", "1"}], " ", 
    StyleBox["mod", "TR"], " ", 
    StyleBox["n", "TI"]}]}]], "InlineFormula"],
 ". The certificate ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["a", "TI"], ",", "2", ",", 
    StyleBox["n", "TI"]}], "}"}]], "InlineFormula"],
 " can be used to show that ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is composite by demonstrating that ",
 Cell[BoxData[
  RowBox[{
   StyleBox["a", "TI"], "\[NotCongruent]", 
   RowBox[{
    RowBox[{"\[PlusMinus]", "1"}], 
    StyleBox["mod", "TR"], " ", 
    StyleBox["n", "TI"]}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    StyleBox["a", "TI"], "2"], "\[Congruent]", 
   RowBox[{"1", " ", 
    StyleBox["mod", "TR"], " ", 
    StyleBox["n", "TI"]}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->13017],

Cell[TextData[{
 "A certificate of primality consists of a recursive list of certificates \
which prove that ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is a prime if one or more smaller numbers are prime as well."
}], "Notes",
 CellID->19992],

Cell[TextData[{
 Cell[BoxData["PrimeQCertificate"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["ProvablePrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:PrimalityProving/ref/ProvablePrimeQ"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->2664]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->273616488],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->424133792],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PrimalityProving`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->656053081],

Cell["\<\
A certificate that can be used to prove that 1093 is a prime:\
\>", "ExampleText",
 CellID->17151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQCertificate", "[", "1093", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29761],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1093", ",", "5", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", 
       RowBox[{"{", "2", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "3", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "2", ",", 
           RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13", ",", "2", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "2", ",", 
           RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{517, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29308]
}, Open  ]],

Cell[TextData[{
 "The same certificate can be obtained by using ",
 Cell[BoxData["ProvablePrimeQ"], "InlineFormula"],
 " with the option ",
 Cell[BoxData[
  RowBox[{"\"\<Certificate\>\"", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->19514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProvablePrimeQ", "[", 
  RowBox[{"1093", ",", 
   RowBox[{"\"\<Certificate\>\"", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25184],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", 
   RowBox[{"{", 
    RowBox[{"1093", ",", "5", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2", ",", 
         RowBox[{"{", "2", "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "3", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "2", ",", 
             RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "2", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "2", ",", 
             RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{570, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->5057]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19028],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PrimalityProving`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->260340292],

Cell[TextData[{
 "A certificate that can be used to prove that ",
 Cell[BoxData[
  RowBox[{"1093", " ", "3511"}]], "InlineFormula"],
 " is composite:"
}], "ExampleText",
 CellID->5101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQCertificate", "[", 
  RowBox[{"1093", " ", "3511"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18138],

Cell[OutputFormData["\<\
{2, 3837522, 3837523}\
\>", "\<\
{2, 3837522, 3837523}\
\>"], "Output",
 ImageSize->{147, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14293]
}, Open  ]],

Cell[TextData[{
 "The output is a list of 3 integers indicate ",
 Cell[BoxData[
  RowBox[{"1093", " ", "3511"}]], "InlineFormula"],
 " is composite, and that it violates Fermat's little theorem for primes, ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{
     StyleBox["p", "TI"], "-", "1"}]], "\[Congruent]", 
   RowBox[{"1", " ", 
    StyleBox["mod", "TR"], " ", 
    StyleBox["p", "TI"]}]}]], "InlineFormula"],
 " if ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " is prime:"
}], "ExampleText",
 CellID->23755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerMod", "@@", "%"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1706],

Cell[OutputFormData["\<\
3134697\
\>", "\<\
3134697\
\>"], "Output",
 ImageSize->{49, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->32124]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25201],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ProvablePrimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:PrimalityProving/ref/ProvablePrimeQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrimeQCertificateCheck",
    BaseStyle->"Link",
    ButtonData->"paclet:PrimalityProving/ref/PrimeQCertificateCheck"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimeQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7457]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16160],

Cell[TextData[ButtonBox["Primality Proving Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PrimalityProving/tutorial/PrimalityProving"]], "Tutorials",
 CellID->13808]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PrimeQCertificate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 35.2687058}", "context" -> 
    "PrimalityProving`", "keywords" -> {}, "index" -> True, "label" -> 
    "Primality Proving Package Symbol", "language" -> "en", "paclet" -> 
    "PrimalityProving Package", "status" -> "None", "summary" -> 
    "PrimeQCertificate[n] gives a certificate that n is prime or that n is \
composite.", "synonyms" -> {}, "title" -> "PrimeQCertificate", "type" -> 
    "Symbol", "uri" -> "PrimalityProving/ref/PrimeQCertificate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6950, 255, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->273616488]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14660, 546}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1531, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2154, 66, 55, 1, 70, "ObjectName",
 CellID->19069],
Cell[2212, 69, 568, 18, 70, "Usage",
 CellID->11599]
}, Open  ]],
Cell[CellGroupData[{
Cell[2817, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3295, 109, 184, 5, 70, "Notes",
 CellID->1113415164],
Cell[3482, 116, 648, 24, 70, "Notes",
 CellID->20887],
Cell[4133, 142, 966, 37, 70, "Notes",
 CellID->9592],
Cell[5102, 181, 1260, 48, 70, "Notes",
 CellID->13017],
Cell[6365, 231, 262, 7, 70, "Notes",
 CellID->19992],
Cell[6630, 240, 283, 10, 70, "Notes",
 CellID->2664]
}, Closed]],
Cell[CellGroupData[{
Cell[6950, 255, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->273616488],
Cell[CellGroupData[{
Cell[7335, 269, 148, 5, 70, "ExampleSection",
 CellID->424133792],
Cell[7486, 276, 141, 4, 70, "Input",
 CellID->656053081],
Cell[7630, 282, 108, 3, 70, "ExampleText",
 CellID->17151],
Cell[CellGroupData[{
Cell[7763, 289, 112, 3, 28, "Input",
 CellID->29761],
Cell[7878, 294, 823, 27, 36, "Output",
 CellID->29308]
}, Open  ]],
Cell[8716, 324, 335, 11, 70, "ExampleText",
 CellID->19514],
Cell[CellGroupData[{
Cell[9076, 339, 178, 5, 70, "Input",
 CellID->25184],
Cell[9257, 346, 914, 29, 36, "Output",
 CellID->5057]
}, Open  ]],
Cell[10186, 378, 121, 3, 70, "ExampleDelimiter",
 CellID->19028],
Cell[10310, 383, 141, 4, 70, "Input",
 CellID->260340292],
Cell[10454, 389, 184, 6, 70, "ExampleText",
 CellID->5101],
Cell[CellGroupData[{
Cell[10663, 399, 138, 4, 70, "Input",
 CellID->18138],
Cell[10804, 405, 223, 9, 41, "Output",
 CellID->14293]
}, Open  ]],
Cell[11042, 417, 545, 18, 70, "ExampleText",
 CellID->23755],
Cell[CellGroupData[{
Cell[11612, 439, 95, 3, 70, "Input",
 CellID->1706],
Cell[11710, 444, 194, 9, 41, "Output",
 CellID->32124]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11965, 460, 311, 9, 70, "SeeAlsoSection",
 CellID->25201],
Cell[12279, 471, 765, 26, 70, "SeeAlso",
 CellID->7457]
}, Open  ]],
Cell[CellGroupData[{
Cell[13081, 502, 314, 9, 70, "TutorialsSection",
 CellID->16160],
Cell[13398, 513, 172, 4, 70, "Tutorials",
 CellID->13808]
}, Open  ]],
Cell[13585, 520, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

