(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34808,       1199]
NotebookOptionsPosition[     27637,        942]
NotebookOutlinePosition[     29176,        988]
CellTagsIndexPosition[     29039,        981]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PRIMALITY PROVING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Primality Proving Package" :> 
          Documentation`HelpLookup[
           "paclet:PrimalityProving/tutorial/PrimalityProving"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Primality Proving Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PrimeQCertificate" :> 
          Documentation`HelpLookup[
           "paclet:PrimalityProving/ref/PrimeQCertificate"], "PrimeQ" :> 
          Documentation`HelpLookup["paclet:ref/PrimeQ"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"PrimeQCertificate\"\>", 
       2->"\<\"PrimeQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ProvablePrimeQ", "ObjectName",
 CellID->3311],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ProvablePrimeQ", "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " is provably prime, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3107]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  RowBox[{"ProvablePrimeQ", "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is prime based on the Pratt certificate of primality or the Atkin-Morain \
certificate of primality."
}], "Notes",
 CellID->5187],

Cell[TextData[{
 Cell[BoxData["ProvablePrimeQ"], "InlineFormula"],
 " should not be used as a replacement for ",
 Cell[BoxData[
  ButtonBox["PrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimeQ"]], "InlineFormula"],
 ", as ",
 Cell[BoxData[
  ButtonBox["PrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimeQ"]], "InlineFormula"],
 " is several orders of magnitude faster. Instead, use ",
 Cell[BoxData["ProvablePrimeQ"], "InlineFormula"],
 " to certify the results of ",
 Cell[BoxData[
  ButtonBox["PrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimeQ"]], "InlineFormula"],
 " when needed."
}], "Notes",
 CellID->22432],

Cell["The following options can be given:", "Notes",
 Background->Dynamic[
   If[CurrentValue[] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellTags->{"S0.1651", "NDSolve"},
 CellID->306876545],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<SmallPrime\>\"", 
    SuperscriptBox["10", "50"], Cell[
    "lower bound for using Atkin-Morain test", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Certificate\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to print a certificate", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PollardPTest\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "whether to use the Pollard ",
     Cell[BoxData[
      RowBox[{
       StyleBox["p", "TI"], "-", "1"}]], "InlineFormula"],
     " method"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PollardRhoTest\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
whether to use the Pollard \[Rho] method\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TrialDivisionLimit\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "number of primes to use in trial division", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PrimeQMessages\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether progress is to be monitored", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->13701]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->52155860],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->151331529],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PrimalityProving`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->184575893],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimeQ"]], "InlineFormula"],
 " indicates that 1093 is prime:"
}], "ExampleText",
 CellID->7697],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQ", "[", "1093", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9656],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14622]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["ProvablePrimeQ"], "InlineFormula"],
 " gives the same result, but it has generated a certificate:"
}], "ExampleText",
 CellID->15885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProvablePrimeQ", "[", "1093", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->30538],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->9001]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16336],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PrimalityProving`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->460089692],

Cell[TextData[{
 Cell[BoxData["ProvablePrimeQ"], "InlineFormula"],
 " works on arbitrarily large numbers:"
}], "ExampleText",
 CellID->721612558],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProvablePrimeQ", "[", 
  RowBox[{
   SuperscriptBox["10", "300"], "+", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1302107697],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->832304751]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1818196257],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PrimalityProving`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->974666933],

Cell[TextData[{
 Cell[BoxData["ProvablePrimeQ"], "InlineFormula"],
 " automatically threads over lists:"
}], "ExampleText",
 CellID->1984957146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProvablePrimeQ", "[", 
  RowBox[{"{", 
   RowBox[{"3", ",", "7", ",", "9", ",", "13"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16296677],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "False", ",", "True"}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1167827170]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8638],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Certificate",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->32017],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PrimalityProving`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->67465386],

Cell[TextData[{
 "Use the option ",
 Cell[BoxData[
  RowBox[{"\"\<Certificate\>\"", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " to view the certificate directly:"
}], "ExampleText",
 CellID->8187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProvablePrimeQ", "[", 
  RowBox[{"1093", ",", 
   RowBox[{"\"\<Certificate\>\"", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1757],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", 
   RowBox[{"{", 
    RowBox[{"1093", ",", "5", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2", ",", 
         RowBox[{"{", "2", "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "3", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "2", ",", 
             RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "2", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "2", ",", 
             RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{570, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18870]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PrimeQMessages",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->655808573],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PrimalityProving`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->313174890],

Cell["A random prime:", "ExampleText",
 CellID->3787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{"RandomPrime", "[", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["10", "60"], ",", 
     SuperscriptBox["10", "61"]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18307],

Cell[BoxData["7146330773479944228428207205564989096279426988634539762839671"],\
 "Output",
 ImageSize->{474, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->87734683]
}, Open  ]],

Cell[TextData[{
 "Progress messages are printed with ",
 Cell[BoxData["\"\<PrimeQMessages\>\""], "InlineFormula"],
 " -> ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->7469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProvablePrimeQ", "[", 
  RowBox[{"p", ",", 
   RowBox[{"\"\<PrimeQMessages\>\"", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2079],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox["\<\"Prime candidate p = \
\\!\\(\\*StyleBox[\\\"\
7146330773479944228428207205564989096279426988634539762839671\\\", \
Rule[ShowStringCharacters, True], Rule[NumberMarks, True]]\\) .\"\>",
  StringForm["Prime candidate p = `` .", 
   InputForm[7146330773479944228428207205564989096279426988634539762839671]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->42791538],

Cell[BoxData[
 InterpretationBox["\<\"Trial division vector has length \\!\\(10000\\).\"\>",
  
  StringForm["Trial division vector has length ``.", 10000],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->399432693],

Cell[BoxData[
 InterpretationBox["\<\"Class table index = \\!\\(\\*StyleBox[\\\"2\\\", \
Rule[ShowStringCharacters, True], Rule[NumberMarks, True]]\\), discriminant = \
\\!\\(\\*StyleBox[\\\"-11\\\", Rule[ShowStringCharacters, True], \
Rule[NumberMarks, True]]\\) .\"\>",
  StringForm["Class table index = ``, discriminant = `` .", 
   InputForm[2], 
   InputForm[-11]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->74054096],

Cell[BoxData[
 InterpretationBox["\<\"4*p = u^2 + \\!\\(\\*StyleBox[\\\"11\\\", \
Rule[ShowStringCharacters, True], Rule[NumberMarks, True]]\\)*v^2.  Trying \
trial division.\"\>",
  StringForm["4*p = u^2 + ``*v^2.  Trying trial division.", 
   InputForm[11]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->414682124],

Cell[BoxData[
 InterpretationBox["\<\"Trial division successful.\"\>",
  StringForm["Trial division successful."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->75784915],

Cell[BoxData[
 InterpretationBox["\<\"Finding root of a polynomial of order \
\\!\\(\\*StyleBox[\\\"1\\\", Rule[ShowStringCharacters, True], \
Rule[NumberMarks, True]]\\) mod p.\"\>",
  StringForm["Finding root of a polynomial of order `` mod p.", 
   InputForm[1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->842484100],

Cell[BoxData[
 InterpretationBox["\<\"Prime candidate p = \
\\!\\(\\*StyleBox[\\\"\
10192561134679267567916180128088389927110688089848260241\\\", \
Rule[ShowStringCharacters, True], Rule[NumberMarks, True]]\\) .\"\>",
  StringForm["Prime candidate p = `` .", 
   InputForm[10192561134679267567916180128088389927110688089848260241]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->693926324],

Cell[BoxData[
 InterpretationBox["\<\"Trial division vector has length \\!\\(5000\\).\"\>",
  StringForm["Trial division vector has length ``.", 5000],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->451084707],

Cell[BoxData[
 InterpretationBox["\<\"Class table index = \\!\\(\\*StyleBox[\\\"1\\\", \
Rule[ShowStringCharacters, True], Rule[NumberMarks, True]]\\), discriminant = \
\\!\\(\\*StyleBox[\\\"-7\\\", Rule[ShowStringCharacters, True], \
Rule[NumberMarks, True]]\\) .\"\>",
  StringForm["Class table index = ``, discriminant = `` .", 
   InputForm[1], 
   InputForm[-7]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->643809857],

Cell[BoxData[
 InterpretationBox["\<\"4*p = u^2 + \\!\\(\\*StyleBox[\\\"7\\\", \
Rule[ShowStringCharacters, True], Rule[NumberMarks, True]]\\)*v^2.  Trying \
trial division.\"\>",
  StringForm["4*p = u^2 + ``*v^2.  Trying trial division.", 
   InputForm[7]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->6697680],

Cell[BoxData[
 InterpretationBox["\<\"Class table index = \\!\\(\\*StyleBox[\\\"2\\\", \
Rule[ShowStringCharacters, True], Rule[NumberMarks, True]]\\), discriminant = \
\\!\\(\\*StyleBox[\\\"-11\\\", Rule[ShowStringCharacters, True], \
Rule[NumberMarks, True]]\\) .\"\>",
  StringForm["Class table index = ``, discriminant = `` .", 
   InputForm[2], 
   InputForm[-11]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->466342466],

Cell[BoxData[
 InterpretationBox["\<\"Class table index = \\!\\(\\*StyleBox[\\\"3\\\", \
Rule[ShowStringCharacters, True], Rule[NumberMarks, True]]\\), discriminant = \
\\!\\(\\*StyleBox[\\\"-19\\\", Rule[ShowStringCharacters, True], \
Rule[NumberMarks, True]]\\) .\"\>",
  StringForm["Class table index = ``, discriminant = `` .", 
   InputForm[3], 
   InputForm[-19]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->333721914],

Cell[BoxData[
 InterpretationBox["\<\"4*p = u^2 + \\!\\(\\*StyleBox[\\\"19\\\", \
Rule[ShowStringCharacters, True], Rule[NumberMarks, True]]\\)*v^2.  Trying \
trial division.\"\>",
  StringForm["4*p = u^2 + ``*v^2.  Trying trial division.", 
   InputForm[19]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->23785177],

Cell[BoxData[
 InterpretationBox["\<\"Trial division successful.\"\>",
  StringForm["Trial division successful."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->396226908],

Cell[BoxData[
 InterpretationBox["\<\"Finding root of a polynomial of order \
\\!\\(\\*StyleBox[\\\"1\\\", Rule[ShowStringCharacters, True], \
Rule[NumberMarks, True]]\\) mod p.\"\>",
  StringForm["Finding root of a polynomial of order `` mod p.", 
   InputForm[1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->194242056]
}, Open  ]],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->353964669]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24148],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PrimalityProving`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->234357031],

Cell["Here is a random prime:", "ExampleText",
 CellID->26162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{"RandomPrime", "[", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["10", "9"], ",", 
     SuperscriptBox["10", "12"]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5460],

Cell[BoxData["53275270987"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->291567515]
}, Open  ]],

Cell[TextData[{
 "If ",
 Cell[BoxData["ProvablePrimeQ"], "InlineFormula"],
 " has returned a result, use ",
 Cell[BoxData["PrimeQCertificate"], "InlineFormula"],
 " to print the certificate:"
}], "ExampleText",
 CellID->135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProvablePrimeQ", "[", "p", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17866],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1965025798]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQCertificate", "[", "p", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->29523],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXMFy0zAQVWMnKS1tWmaAnqDfwInhA+DUI9wzHWbaAwNTeqYcgN82kW2l
zstKq7Uk23GTmcZZebXS7molWc/bq+X9zddvy/vb6+Xlp7vlj5vb65+XH7/f
rYqyA6Um75VS7y7U6nex+lX+mc+H1d8jWVEv9He25lJvgF4AfQT0M+F9qbzj
yPLyQBrlv2b6w/U/tr24+2cd2ys2XdpbnUPp29XXZEWe1VfU6ogp5+qhF7l6
yC/VMrPIvYB2bf1qq6et/DyRnqnpVwU1WrR1Namv0/qq6Skj7VB4f1LLl8pB
em7pn297GNM2fWee/bW1E0pjO9O6n3l9rSqYz8zTSqj9ULyCfDavzHv2Sjcx
qXuvpmu6qBwtKaXa1XMWtaJR5XapNimU1LlIirtNnG3d3LFaDvU11RrGKrXe
UeufWyeZffrwoIz7MJKsIUU7Hf24C81IXahRsc2F8yXumE+YHiE/jlXs63NG
HvLPmfrYPsrjYoejUX9txdnavNUnH6AdUR7aEfuT2o6p6ZelO/zWRaxLc3Ee
PRV6AOWhR7kRgvzoEalHQ2mUL9lt6ODRUYP+6tqmXNRhf1LbtL/do/YGaq/L
M6KciwT0is9983zt4qOsb56vJe3hyhg68kt5+SOtiBI6DhYWDVJZkIovXQ/P
MVNbsMenpAZ9uOUlTi9uVefmZC6SOH70S6g8tEhoJDTv6/GNNB0FXPymtip3
n1tVYlu1n+jwe16QrPInZKnfvsGPK6QF9Gr8FmLvsNpFF62Bn/bpveDHddqj
F7qJRlyBm6fsmXo8xTWn7if1lfJjZubUvGmLaW3H9V2iFvbClC+YeqE2QLlm
XzKtr8YKph+2frbT2lZ+lljr1HSF9hlLUPh1HAq9waG6exR8k8YY7hsFTz0u
H/TXVlQhOjtWFNqgwbFR6NRostHnN+k9RIU5abHxv9Tt7SoKbNqxtWfrb1vc
d6h24ehfBTWq2+8oU2NhXbQ5HgQ1jsfCENPdsJ6PlR7K9vxQSJTBndhLca2x
443cW1V4Vob6cPbrW1+O/qO/Ws7LsdGhsSN4Un7pWOtbX47+W9jGGoXwx8Jg
xoaGcfzc0y5nL7PD7FrP9qPHFQOpsYsxI0wUHYol4SjBs62+sR96lGGvcezv
8RmKq+v1MyYSgx4fMkJSjVkXwjGpe+F9Wr+zyMak2EQ2DMbgRDSI3Qinb2qf
/it9ajyQDlvAdj8DPfQMr6eGZQwtoy9Uv+o1X5xtvxT9ZITZMIVdw0BSZeLF
6m9ZTr4RY+bWrJ7DqbPqTHAfr67ejSVnao/d+NnFtIPvgqTO3Ruqfcrd61ZU
irPcWuYDhNSlT/dJTUD/p5FTtUe4JLSPtfxyWrrIFNwdm1Z7PYxCREjIHSLM
kk2aO4eckTqRXM531ZEeesaY9K3rsSF59FjGVo9JLq7vQ0P5ynWEjRROCofA
kPxeebE6sPxmzKFnmD11zNKdb+h3Aiv1Ydc2KFdF69OpOVnknrLMSSHJ57dX
JbkyYhYbWn6aD+Y4JgxWmrVD5eb6+qpr3e3R4FoBybVnyxbkeZJzFyax9K7l
rXHz4NixZnHuW6MuzmCpcfxQW/hFleOdP8F/AuD3bOFnPMPKW0yJ1u6R+biR
jLOU37uI6b0QZxdJWSZXmzu5TG3+tz/zNhyWN/lzuN9XDt543hZoWpWziq08
df/Lk8K1qaVYvzr4D62Jugo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{568, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->6479397]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"\"\<Certificate\>\"", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData["ProvablePrimeQ"], "InlineFormula"],
 " repeats the Atkin-Morain primality test:"
}], "ExampleText",
 CellID->27170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProvablePrimeQ", "[", 
  RowBox[{"p", ",", 
   RowBox[{"\"\<Certificate\>\"", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->5575],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXM1y0zAQduP8lJb+cSFwoOUZeACGYQZOHOGe6TDTHhiY0jPlALx2iGxv
4nxeaSVLshU3mWncldcr7a5WWuuT8mlxf/P12+L+9npx9fFu8ePm9vrn1Yfv
d6ui/CDLRm+zLHs/z1b/L1f/FX/0ebf625Al9UJ952uu7BXQZ0AfAf3E8b6r
vOPA8saeNMp/LrRHan9oe0n3zzu2V2y60CebQ+nl6mu0Is+rK2p5JJRLz6FX
peeQ31XLXCN3DvXq2tVWT135RSQ9u6aL6Gr0HmVtRarrpLoqeiJIO3S8P6rk
u8pBeqZpn219GPM6faeW7dXV40tjPZOqnePqWj5An6mllVD7VLyCfDqvzHr2
Sj8xqrTJJmt6WTrepZSrV41p3AzIleul6qRwUmdOUsx14mhs5g5Vs6+vudow
drn5kJsfzTq52acPD7pxHwaSlVK0240GmHXnrG5cL2ly4XiKGfeJTYsMfRcz
7qeCPOSfCc9j/ShPiiWJRv2VFadr85afcYJ2RHloR2xPbDt2TZ8W7rGbN/FZ
nkvy8KmjR1AeeljqMciPHnL1cJCxqWWOooJJRdFFzzaVohDbE9um6WSbyjto
DVWeM+VSZKCXbO7T+7qJj/MGva+71Iczp28kFPLGGzpjSvi4ONNoEMuCXLyp
5551bMF0+n2dLjLOph8degKOP9KYLUWWxI9+8pWHFvGNjPp91d+R5qNCiufY
VpXuS7NOaKumES127xsuWcEJW2qXZ9hx+dSAXg5fQ+iMrF208RrYaR/fC3Zc
pz16oZ/oRGSzvqqfZ5tVY1rlP6munF9zGnPHddtMKruu7zJPYd5A5WfCc742
QLmUx0yqK1mB2qFrZzutdeXnkbXumi7RR7IMh6+HobAvS6jzHqVn/GRoT9co
fex++aC+GvkJosVDRcUJnQ6NisdGt0mf36z3EJWWpIXGH2PXt6soNNWjq0/X
3ra4c6p2kehfS65Xt884Y2NvXdQ5HMQ2jMf8ENrdsJ6NlR6K+uxQTpQhIQCu
uNnQ8UxpVxeuraE+kv361lei/6ivluNyaLRp6IigK79rX+tbX4n+u9T1NW4H
QSgMZ2homtWqhEOUYfspw+xaz/a9xxQDsbGOISNSHO2LPWEvwZXHvrEivpdh
q7Hv7/Ebjqvr+TMkUoMeTxlBKfusCfEYVa2wXr3fWaRjtNxGOghzMCIcTDYi
6Rvbp/8Kn5IH4mELuKr5GejUT6A9NiwjtROHvvqV24ixli/Lfk6o6TCFXcNA
Yp0MDNXeorwhHbF5NYZza9W5w328mlo3lDNbe+zGzi5UD+4NiX12MFX7FNmr
5Sq8IdNteb7A51l+dR9zeO7d8XGc4dojXC60jbXszsh0cTJxd2xa5npYJyIk
bIYIo2SdltYhp6xOLJdxbzvSqZ9Ic92lPTQkj+/LWOsxyyW1PTWUr5hHGuOI
q1QJgWH5rc7dqsCyGzFTP7H22DFL8/lFuxVYVx92bYNihtK+ndLKovSWRSuF
LJ9drspy5cwoltr5NhvMcUgYrOupHu6sr62vutZdHw2mGZCdexq2YNeTjFmY
i6V37ZybNA4OHWt2PhtXexZHsNg4vq8t7KLKsOfP4ZcF5JzNf40nrXONMdHa
PTIfNpJxlOIQ1z72R4TJInGGI3y5nsnl2favDdJuOCyv84/hfl9n8oazW6Bu
VckquvLY7S/mi7Wp4+0KwHrxd4GJu9hz0phjLiurEtdLlov7nU31VP2XpSha
sD0kec5KllYQGzkljU0w39d1KDVFLinXNvwGAKPN6/basHXUCy+tZa/xWcvx
260GirjyRlYJIA/UzyaT3KuNXL5FW+8LdPfNkuvHswYHUa4Rkh38B3KhB7Q=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{575, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->533722146]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4915],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PrimalityProving`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->32824973],

Cell[TextData[{
 "A certificate cannot be generated for ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"-", "1"}], ",", "0"}]], "InlineFormula"],
 " or 1:"
}], "ExampleText",
 CellID->363422622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProvablePrimeQ", "[", "0", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->600515886],

Cell[BoxData[
 RowBox[{
  RowBox[{"PrimeQCertificate", "::", "\<\"zero\"\>"}], ":", 
  " ", "\<\"The number 0 is considered neither prime nor composite, so no \
certificate for the primality or compositeness exists.\"\>"}]], "Message", \
"MSG",
 CellID->466203981],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->311158730]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24814],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrimeQCertificate",
    BaseStyle->"Link",
    ButtonData->"paclet:PrimalityProving/ref/PrimeQCertificate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 " ",
 "\[EmptyVerySmallSquare]",
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimeQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31612]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21540],

Cell[TextData[ButtonBox["Primality Proving Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PrimalityProving/tutorial/PrimalityProving"]], "Tutorials",
 CellID->11483]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ProvablePrimeQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 35.5187122}", "context" -> 
    "PrimalityProving`", "keywords" -> {}, "index" -> True, "label" -> 
    "Primality Proving Package Symbol", "language" -> "en", "paclet" -> 
    "PrimalityProving Package", "status" -> "None", "summary" -> 
    "ProvablePrimeQ[n] gives True if n is provably prime, and False \
otherwise.", "synonyms" -> {}, "title" -> "ProvablePrimeQ", "type" -> 
    "Symbol", "uri" -> "PrimalityProving/ref/ProvablePrimeQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S0.1651"->{
  Cell[4408, 153, 198, 5, 70, "Notes",
   CellTags->{"S0.1651", "NDSolve"},
   CellID->306876545]},
 "NDSolve"->{
  Cell[4408, 153, 198, 5, 70, "Notes",
   CellTags->{"S0.1651", "NDSolve"},
   CellID->306876545]},
 "PrimaryExamplesSection"->{
  Cell[6322, 206, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->52155860]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S0.1651", 28654, 966},
 {"NDSolve", 28768, 970},
 {"PrimaryExamplesSection", 28897, 974}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1353, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1976, 62, 51, 1, 70, "ObjectName",
 CellID->3311],
Cell[2030, 65, 752, 25, 70, "Usage",
 CellID->3107]
}, Open  ]],
Cell[CellGroupData[{
Cell[2819, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3297, 112, 451, 16, 70, "Notes",
 CellID->5187],
Cell[3751, 130, 654, 21, 70, "Notes",
 CellID->22432],
Cell[4408, 153, 198, 5, 70, "Notes",
 CellTags->{"S0.1651", "NDSolve"},
 CellID->306876545],
Cell[4609, 160, 1676, 41, 70, "3ColumnTableMod",
 CellID->13701]
}, Closed]],
Cell[CellGroupData[{
Cell[6322, 206, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->52155860],
Cell[CellGroupData[{
Cell[6706, 220, 148, 5, 70, "ExampleSection",
 CellID->151331529],
Cell[6857, 227, 141, 4, 70, "Input",
 CellID->184575893],
Cell[7001, 233, 198, 7, 70, "ExampleText",
 CellID->7697],
Cell[CellGroupData[{
Cell[7224, 244, 100, 3, 28, "Input",
 CellID->9656],
Cell[7327, 249, 157, 5, 36, "Output",
 CellID->14622]
}, Open  ]],
Cell[7499, 257, 164, 4, 70, "ExampleText",
 CellID->15885],
Cell[CellGroupData[{
Cell[7688, 265, 109, 3, 70, "Input",
 CellID->30538],
Cell[7800, 270, 156, 5, 36, "Output",
 CellID->9001]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8005, 281, 216, 7, 70, "ExampleSection",
 CellID->16336],
Cell[8224, 290, 141, 4, 70, "Input",
 CellID->460089692],
Cell[8368, 296, 145, 4, 70, "ExampleText",
 CellID->721612558],
Cell[CellGroupData[{
Cell[8538, 304, 162, 5, 70, "Input",
 CellID->1302107697],
Cell[8703, 311, 162, 5, 36, "Output",
 CellID->832304751]
}, Open  ]],
Cell[8880, 319, 126, 3, 70, "ExampleDelimiter",
 CellID->1818196257],
Cell[9009, 324, 141, 4, 70, "Input",
 CellID->974666933],
Cell[9153, 330, 144, 4, 70, "ExampleText",
 CellID->1984957146],
Cell[CellGroupData[{
Cell[9322, 338, 177, 5, 70, "Input",
 CellID->16296677],
Cell[9502, 345, 238, 7, 36, "Output",
 CellID->1167827170]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9789, 358, 217, 7, 70, "ExampleSection",
 CellID->8638],
Cell[CellGroupData[{
Cell[10031, 369, 228, 7, 70, "ExampleSubsection",
 CellID->32017],
Cell[10262, 378, 140, 4, 70, "Input",
 CellID->67465386],
Cell[10405, 384, 263, 9, 70, "ExampleText",
 CellID->8187],
Cell[CellGroupData[{
Cell[10693, 397, 177, 5, 70, "Input",
 CellID->1757],
Cell[10873, 404, 915, 29, 36, "Output",
 CellID->18870]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11837, 439, 235, 7, 70, "ExampleSubsection",
 CellID->655808573],
Cell[12075, 448, 141, 4, 70, "Input",
 CellID->313174890],
Cell[12219, 454, 53, 1, 70, "ExampleText",
 CellID->3787],
Cell[CellGroupData[{
Cell[12297, 459, 233, 8, 70, "Input",
 CellID->18307],
Cell[12533, 469, 220, 6, 36, "Output",
 CellID->87734683]
}, Open  ]],
Cell[12768, 478, 273, 10, 70, "ExampleText",
 CellID->7469],
Cell[CellGroupData[{
Cell[13066, 492, 177, 5, 70, "Input",
 CellID->2079],
Cell[CellGroupData[{
Cell[13268, 501, 435, 9, 70, "Print",
 CellID->42791538],
Cell[13706, 512, 250, 6, 70, "Print",
 CellID->399432693],
Cell[13959, 520, 463, 10, 70, "Print",
 CellID->74054096],
Cell[14425, 532, 354, 8, 70, "Print",
 CellID->414682124],
Cell[14782, 542, 207, 5, 70, "Print",
 CellID->75784915],
Cell[14992, 549, 360, 8, 70, "Print",
 CellID->842484100],
Cell[15355, 559, 426, 9, 70, "Print",
 CellID->693926324],
Cell[15784, 570, 245, 5, 70, "Print",
 CellID->451084707],
Cell[16032, 577, 462, 10, 70, "Print",
 CellID->643809857],
Cell[16497, 589, 350, 8, 70, "Print",
 CellID->6697680],
Cell[16850, 599, 464, 10, 70, "Print",
 CellID->466342466],
Cell[17317, 611, 464, 10, 70, "Print",
 CellID->333721914],
Cell[17784, 623, 353, 8, 70, "Print",
 CellID->23785177],
Cell[18140, 633, 208, 5, 70, "Print",
 CellID->396226908],
Cell[18351, 640, 360, 8, 70, "Print",
 CellID->194242056]
}, Open  ]],
Cell[18726, 651, 161, 5, 36, "Output",
 CellID->353964669]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[18948, 663, 233, 7, 70, "ExampleSection",
 CellID->24148],
Cell[19184, 672, 141, 4, 70, "Input",
 CellID->234357031],
Cell[19328, 678, 62, 1, 70, "ExampleText",
 CellID->26162],
Cell[CellGroupData[{
Cell[19415, 683, 231, 8, 70, "Input",
 CellID->5460],
Cell[19649, 693, 168, 5, 36, "Output",
 CellID->291567515]
}, Open  ]],
Cell[19832, 701, 224, 7, 70, "ExampleText",
 CellID->135],
Cell[CellGroupData[{
Cell[20081, 712, 106, 3, 70, "Input",
 CellID->17866],
Cell[20190, 717, 162, 5, 36, "Output",
 CellID->1965025798]
}, Open  ]],
Cell[CellGroupData[{
Cell[20389, 727, 109, 3, 70, "Input",
 CellID->29523],
Cell[20501, 732, 1942, 36, 70, "Output",
 Evaluatable->False,
 CellID->6479397]
}, Open  ]],
Cell[22458, 771, 319, 11, 70, "ExampleText",
 CellID->27170],
Cell[CellGroupData[{
Cell[22802, 786, 174, 5, 70, "Input",
 CellID->5575],
Cell[22979, 793, 2103, 39, 70, "Output",
 Evaluatable->False,
 CellID->533722146]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25131, 838, 225, 7, 70, "ExampleSection",
 CellID->4915],
Cell[25359, 847, 140, 4, 70, "Input",
 CellID->32824973],
Cell[25502, 853, 187, 7, 70, "ExampleText",
 CellID->363422622],
Cell[CellGroupData[{
Cell[25714, 864, 110, 3, 70, "Input",
 CellID->600515886],
Cell[25827, 869, 264, 6, 70, "Message",
 CellID->466203981],
Cell[26094, 877, 162, 5, 36, "Output",
 CellID->311158730]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26317, 889, 311, 9, 70, "SeeAlsoSection",
 CellID->24814],
Cell[26631, 900, 438, 17, 70, "SeeAlso",
 CellID->31612]
}, Open  ]],
Cell[CellGroupData[{
Cell[27106, 922, 314, 9, 70, "TutorialsSection",
 CellID->21540],
Cell[27423, 933, 172, 4, 70, "Tutorials",
 CellID->11483]
}, Open  ]],
Cell[27610, 940, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

