(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31517,        986]
NotebookOptionsPosition[     26093,        821]
NotebookOutlinePosition[     28544,        873]
CellTagsIndexPosition[     28501,        870]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PRIMALITY PROVING PACKAGE TUTORIAL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"False" :> Documentation`HelpLookup["paclet:ref/False"], 
         "PrimeQCertificate" :> 
         Documentation`HelpLookup[
          "paclet:PrimalityProving/ref/PrimeQCertificate"], 
         "PrimeQCertificateCheck" :> 
         Documentation`HelpLookup[
          "paclet:PrimalityProving/ref/PrimeQCertificateCheck"], 
         "ProvablePrimeQ" :> 
         Documentation`HelpLookup[
          "paclet:PrimalityProving/ref/ProvablePrimeQ"], "True" :> 
         Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"False\"\>", 2->"\<\"PrimeQCertificate\"\>", 
      3->"\<\"PrimeQCertificateCheck\"\>", 4->"\<\"ProvablePrimeQ\"\>", 
      5->"\<\"True\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Primality Proving Package", "Title",
 CellID->26315],

Cell[TextData[{
 "This package implements primality proving. If ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ProvablePrimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:PrimalityProving/ref/ProvablePrimeQ"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", then the number ",
 Cell[BoxData[
  FormBox[
   StyleBox["n", "TI"], TraditionalForm]], "InlineFormula"],
 " can be mathematically proven to be prime. In addition, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PrimeQCertificate",
    BaseStyle->"Link",
    ButtonData->"paclet:PrimalityProving/ref/PrimeQCertificate"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " prints a certificate that can be used to verify that ",
 Cell[BoxData[
  FormBox[
   StyleBox["n", "TI"], TraditionalForm]], "InlineFormula"],
 " is prime or composite."
}], "Text",
 CellID->3642],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ProvablePrimeQ",
      BaseStyle->"Link",
      ButtonData->"paclet:PrimalityProving/ref/ProvablePrimeQ"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " can be proved to be prime, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " can be proved to be composite"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ProvablePrimeQ",
      BaseStyle->"Link",
      ButtonData->"paclet:PrimalityProving/ref/ProvablePrimeQ"], "[", 
     StyleBox["n", "TI"], 
     RowBox[{",", " ", "\"\<Certificate\>\""}], "\[Rule]", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], "]"}], Cell[
    "print a certificate that can be used to verify the result", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["PrimeQCertificate",
      BaseStyle->"Link",
      ButtonData->"paclet:PrimalityProving/ref/PrimeQCertificate"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "print a certificate that ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " is prime or that ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " is composite"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PrimeQCertificateCheck",
      BaseStyle->"Link",
      ButtonData->"paclet:PrimalityProving/ref/PrimeQCertificateCheck"], "[", 
     
     StyleBox["cert", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "verify that the certificate ",
     Cell[BoxData[
      StyleBox["cert", "TI"]], "InlineFormula"],
     " proves the primality or compositeness of ",
     StyleBox["n", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->32586],

Cell["Proving primality or compositeness. ", "Caption",
 CellID->5423],

Cell[TextData[{
 "The functions provided in this package not only prove primality, but they \
also generate a ",
 StyleBox["certificate",
  FontSlant->"Italic"],
 " of primality. A certificate of primality is a relatively short set of data \
that can be easily used to prove primality. The word easily means that using \
the data to prove primality is much easier and faster than generating the \
data in the first place. As a simple example of a certificate, the factors of \
a composite number provide a certificate of compositeness. Multiplying the \
numbers together to show that they are the factors is much easier than \
finding the factors. The advantage of providing certificates is that the user \
does not have to trust the internal mechanism of the algorithm that generated \
the certificate. It is fairly easy to write a program (in any system) that \
checks that the certificate provides a proof of primality. "
}], "Text",
 CellID->31406],

Cell["This loads the package. ", "MathCaption",
 CellID->27991],

Cell[BoxData[
 RowBox[{"<<", "PrimalityProving`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8670],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimeQ"]], "InlineFormula"],
 " indicates that the number 1093 is prime. "
}], "MathCaption",
 CellID->15602],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQ", "[", "1093", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26407],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32758021]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ProvablePrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:PrimalityProving/ref/ProvablePrimeQ"]], 
  "InlineFormula"],
 " gives the same result, but it has generated a certificate. "
}], "MathCaption",
 CellID->25204],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProvablePrimeQ", "[", "1093", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->12174],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->197435337]
}, Open  ]],

Cell["This prints the certificate. ", "MathCaption",
 CellID->927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQCertificate", "[", "1093", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->3150],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1093", ",", "5", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", 
       RowBox[{"{", "2", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "3", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "2", ",", 
           RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13", ",", "2", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "2", ",", 
           RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{517, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->606500221]
}, Open  ]],

Cell["This prints the certificate directly. ", "MathCaption",
 CellID->21931],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProvablePrimeQ", "[", 
  RowBox[{"1093", ",", 
   RowBox[{"\"\<Certificate\>\"", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->12084],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", 
   RowBox[{"{", 
    RowBox[{"1093", ",", "5", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2", ",", 
         RowBox[{"{", "2", "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "3", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "2", ",", 
             RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "2", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "2", ",", 
             RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{570, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->217196162]
}, Open  ]],

Cell[TextData[{
 "The certificate of primality used in this package for large ",
 StyleBox["n", "TI"],
 " is based on the theory of elliptic curves."
}], "Text",
 CellID->29137],

Cell[TextData[{
 "This package can also be used to generate certificates of compositeness for \
composite numbers. These certificates are based on showing that simple \
properties that are true of prime numbers are not true for the given number. \
For example, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PrimeQCertificate",
    BaseStyle->"Link",
    ButtonData->"paclet:PrimalityProving/ref/PrimeQCertificate"], "[", 
   "3837523", "]"}]], "InlineFormula"],
 " returns the certificate ",
 StyleBox["{2,", "MR"],
 " ",
 StyleBox["3837522,", "MR"],
 " ",
 StyleBox["3837523}", "MR"],
 ", which is intended to show that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["2", "3837522"], " ", 
    RowBox[{"(", 
     RowBox[{"mod", " ", "3837523"}], ")"}]}], TraditionalForm]], 
  "InlineFormula"],
 " is not equal to 1. "
}], "Text",
 CellID->30110],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ProvablePrimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:PrimalityProving/ref/ProvablePrimeQ"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " depending on whether ",
 StyleBox["n", "MR"],
 " is prime or not. The certificate for primality or compositeness is \
generated by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PrimeQCertificate",
    BaseStyle->"Link",
    ButtonData->"paclet:PrimalityProving/ref/PrimeQCertificate"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["ProvablePrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:PrimalityProving/ref/ProvablePrimeQ"]], 
  "InlineFormula"],
 " calls ",
 Cell[BoxData[
  ButtonBox["PrimeQCertificate",
   BaseStyle->"Link",
   ButtonData->"paclet:PrimalityProving/ref/PrimeQCertificate"]], 
  "InlineFormula"],
 " and stores the result, so it does not take any extra time to create a \
certificate once ",
 Cell[BoxData[
  ButtonBox["ProvablePrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:PrimalityProving/ref/ProvablePrimeQ"]], 
  "InlineFormula"],
 " has returned an answer. The certificate generated by ",
 Cell[BoxData[
  ButtonBox["PrimeQCertificate",
   BaseStyle->"Link",
   ButtonData->"paclet:PrimalityProving/ref/PrimeQCertificate"]], 
  "InlineFormula"],
 " can be checked by ",
 Cell[BoxData[
  ButtonBox["PrimeQCertificateCheck",
   BaseStyle->"Link",
   ButtonData->"paclet:PrimalityProving/ref/PrimeQCertificateCheck"]], 
  "InlineFormula"],
 ". This function recognizes whether the certificate asserts primality or \
compositeness and then uses the certificate to verify the assertion. "
}], "Text",
 CellID->11422],

Cell["This prints the certificate of the prime number. ", "MathCaption",
 CellID->5877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProvablePrimeQ", "[", 
  RowBox[{"1093", ",", 
   RowBox[{"\"\<Certificate\>\"", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->15197],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", 
   RowBox[{"{", 
    RowBox[{"1093", ",", "5", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2", ",", 
         RowBox[{"{", "2", "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "3", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "2", ",", 
             RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "2", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "2", ",", 
             RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{570, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->198777825]
}, Open  ]],

Cell["This verifies primality using the certificate. ", "MathCaption",
 CellID->19406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQCertificateCheck", "[", 
  RowBox[{
   RowBox[{"Last", "[", "%", "]"}], ",", "1093"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->30164],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->347879334]
}, Open  ]],

Cell["\<\
Here is the certificate for a composite number. You can recognize a \
certificate of compositeness because it will always be a list of three \
integers. \
\>", "MathCaption",
 CellID->32003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQCertificate", "[", 
  RowBox[{"1093", " ", "3511"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->23615],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3837522", ",", "3837523"}], "}"}]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->262905187]
}, Open  ]],

Cell["This verifies the compositeness. ", "MathCaption",
 CellID->12855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQCertificateCheck", "[", 
  RowBox[{"%", ",", "3837523"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->18809],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->327875650]
}, Open  ]],

Cell[TextData[{
 "This package is not meant to replace the built\[Hyphen]in primality tester \
",
 Cell[BoxData[
  ButtonBox["PrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimeQ"]], "InlineFormula"],
 " but rather to allow one to be completely secure that a number is truly \
prime. The package should be used only to certify results after all the \
number theoretical work has been done. For example, it would be a mistake to \
use ",
 Cell[BoxData[
  ButtonBox["ProvablePrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:PrimalityProving/ref/ProvablePrimeQ"]], 
  "InlineFormula"],
 " as a primality test for an integer factoring algorithm. Rather, only when \
the complete factorization has been achieved (using ",
 Cell[BoxData[
  ButtonBox["PrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimeQ"]], "InlineFormula"],
 " for primality testing) would one use ",
 Cell[BoxData[
  ButtonBox["ProvablePrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:PrimalityProving/ref/ProvablePrimeQ"]], 
  "InlineFormula"],
 " to certify the primality of the prime factors given by the algorithm. The \
reason for this is that ",
 Cell[BoxData[
  ButtonBox["PrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimeQ"]], "InlineFormula"],
 " will be, in general, several orders of magnitude faster than ",
 Cell[BoxData[
  ButtonBox["ProvablePrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:PrimalityProving/ref/ProvablePrimeQ"]], 
  "InlineFormula"],
 ". "
}], "Text",
 CellID->28708],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {"\"\<SmallPrime\>\"", 
    RowBox[{"10", "^", "50"}], Cell["\<\
lower bound for using the Atkin\[Hyphen]Morain primality test\
\>", "TableText"]},
   {"\"\<Certificate\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to print a certificate", "TableText"]},
   {"\"\<PollardPTest\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "whether to apply the Pollard ",
     Cell[BoxData[
      RowBox[{
       StyleBox["p", "TI"], "-", "1"}]], "InlineFormula"],
     " factoring algorithm in the search for the next prime in the recursive \
certificate"
    }], "TableText"]},
   {"\"\<PollardRhoTest\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "whether to apply the Pollard ",
     Cell[BoxData["\[Rho]"], "InlineFormula"],
     " factoring algorithm in the search for the next prime in the recursive \
certificate"
    }], "TableText"]},
   {"\"\<TrialDivisionLimit\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "number of primes to be used in the trial division part of ",
     StyleBox[ButtonBox["PrimeQCertificate",
      BaseStyle->"Link",
      ButtonData->"paclet:PrimalityProving/ref/PrimeQCertificate"], 
      "InlineCode"]
    }], "TableText"]},
   {"\"\<PrimeQMessages\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to print out the progress of the algorithm", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->11780],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["ProvablePrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:PrimalityProving/ref/ProvablePrimeQ"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PrimeQCertificate",
   BaseStyle->"Link",
   ButtonData->"paclet:PrimalityProving/ref/PrimeQCertificate"]], 
  "InlineFormula"],
 "."
}], "Caption",
 CellID->30807],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  FormBox[
   StyleBox["n", "TI"], TraditionalForm]], "InlineFormula"],
 " is larger than the value of the option ",
 Cell[BoxData["\"\<SmallPrime\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ProvablePrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:PrimalityProving/ref/ProvablePrimeQ"]], 
  "InlineFormula"],
 " uses the Atkin\[Hyphen]Morain test as described above."
}], "Text",
 CellID->23992],

Cell[TextData[{
 "Note that you must use the same value of ",
 Cell[BoxData["\"\<SmallPrime\>\""], "InlineFormula"],
 " when you check a certificate using ",
 Cell[BoxData[
  ButtonBox["PrimeQCertificate",
   BaseStyle->"Link",
   ButtonData->"paclet:PrimalityProving/ref/PrimeQCertificate"]], 
  "InlineFormula"],
 " that you used when you generated it using ",
 Cell[BoxData[
  ButtonBox["ProvablePrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:PrimalityProving/ref/ProvablePrimeQ"]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["PrimeQCertificate",
   BaseStyle->"Link",
   ButtonData->"paclet:PrimalityProving/ref/PrimeQCertificate"]], 
  "InlineFormula"],
 ". "
}], "Text",
 CellID->3890],

Cell[TextData[{
 "Since the default value of ",
 Cell[BoxData["\"\<SmallPrime\>\""], "InlineFormula"],
 " is larger than the given number, Pratt\[CloseCurlyQuote]s certificate of \
primality is returned. "
}], "MathCaption",
 CellID->2528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQCertificate", "[", "3511", "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->4275],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3511", ",", "7", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", 
       RowBox[{"{", "2", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "2", ",", 
       RowBox[{"{", "2", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13", ",", "2", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "2", ",", 
           RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{434, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->211292674]
}, Open  ]],

Cell["\<\
For large numbers, the certificate can be quite long and involved. \
\>", "MathCaption",
 CellID->21798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQCertificate", "[", 
  RowBox[{
   SuperscriptBox["10", "20"], "+", "39"}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->6731],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{580, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->635484930]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Primality Proving Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 35.8312202}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Primality Proving Package Tutorial", "language" -> "en", "paclet" -> 
    "PrimalityProving Package", "status" -> "None", "summary" -> 
    "This package implements primality proving. If ProvablePrimeQ[n] returns \
True, then the number n can be mathematically proven to be prime. In \
addition, PrimeQCertificate[n] prints a certificate that can be used to \
verify that n is prime or composite. Proving primality or compositeness. The \
functions provided in this package not only prove primality, but they also \
generate a certificate of primality. A certificate of primality is a \
relatively short set of data that can be easily used to prove primality. The \
word easily means that using the data to prove primality is much easier and \
faster than generating the data in the first place. As a simple example of a \
certificate, the factors of a composite number provide a certificate of \
compositeness. Multiplying the numbers together to show that they are the \
factors is much easier than finding the factors. The advantage of providing \
certificates is that the user does not have to trust the internal mechanism \
of the algorithm that generated the certificate. It is fairly easy to write a \
program (in any system) that checks that the certificate provides a proof of \
primality. ", "synonyms" -> {}, "title" -> "Primality Proving Package", 
    "type" -> "Tutorial", "uri" -> 
    "PrimalityProving/tutorial/PrimalityProving"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1135, 25, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1760, 52, 58, 1, 70, "Title",
 CellID->26315],
Cell[1821, 55, 966, 30, 70, "Text",
 CellID->3642],
Cell[2790, 87, 2235, 70, 70, "DefinitionBox",
 CellID->32586],
Cell[5028, 159, 70, 1, 70, "Caption",
 CellID->5423],
Cell[5101, 162, 952, 16, 70, "Text",
 CellID->31406],
Cell[6056, 180, 63, 1, 70, "MathCaption",
 CellID->27991],
Cell[6122, 183, 99, 3, 70, "Input",
 CellID->8670],
Cell[6224, 188, 211, 7, 70, "MathCaption",
 CellID->15602],
Cell[CellGroupData[{
Cell[6460, 199, 101, 3, 28, "Input",
 CellID->26407],
Cell[6564, 204, 160, 5, 36, "Output",
 CellID->32758021]
}, Open  ]],
Cell[6739, 212, 265, 8, 70, "MathCaption",
 CellID->25204],
Cell[CellGroupData[{
Cell[7029, 224, 109, 3, 70, "Input",
 CellID->12174],
Cell[7141, 229, 161, 5, 36, "Output",
 CellID->197435337]
}, Open  ]],
Cell[7317, 237, 66, 1, 70, "MathCaption",
 CellID->927],
Cell[CellGroupData[{
Cell[7408, 242, 111, 3, 70, "Input",
 CellID->3150],
Cell[7522, 247, 827, 27, 36, "Output",
 CellID->606500221]
}, Open  ]],
Cell[8364, 277, 77, 1, 70, "MathCaption",
 CellID->21931],
Cell[CellGroupData[{
Cell[8466, 282, 183, 5, 70, "Input",
 CellID->12084],
Cell[8652, 289, 919, 29, 36, "Output",
 CellID->217196162]
}, Open  ]],
Cell[9586, 321, 177, 5, 70, "Text",
 CellID->29137],
Cell[9766, 328, 857, 27, 70, "Text",
 CellID->30110],
Cell[10626, 357, 1958, 61, 70, "Text",
 CellID->11422],
Cell[12587, 420, 87, 1, 70, "MathCaption",
 CellID->5877],
Cell[CellGroupData[{
Cell[12699, 425, 183, 5, 70, "Input",
 CellID->15197],
Cell[12885, 432, 919, 29, 36, "Output",
 CellID->198777825]
}, Open  ]],
Cell[13819, 464, 86, 1, 70, "MathCaption",
 CellID->19406],
Cell[CellGroupData[{
Cell[13930, 469, 172, 5, 70, "Input",
 CellID->30164],
Cell[14105, 476, 161, 5, 36, "Output",
 CellID->347879334]
}, Open  ]],
Cell[14281, 484, 200, 5, 70, "MathCaption",
 CellID->32003],
Cell[CellGroupData[{
Cell[14506, 493, 138, 4, 70, "Input",
 CellID->23615],
Cell[14647, 499, 226, 7, 36, "Output",
 CellID->262905187]
}, Open  ]],
Cell[14888, 509, 72, 1, 70, "MathCaption",
 CellID->12855],
Cell[CellGroupData[{
Cell[14985, 514, 143, 4, 70, "Input",
 CellID->18809],
Cell[15131, 520, 161, 5, 36, "Output",
 CellID->327875650]
}, Open  ]],
Cell[15307, 528, 1515, 42, 70, "Text",
 CellID->28708],
Cell[16825, 572, 1946, 52, 70, "DefinitionBox3Col",
 CellID->11780],
Cell[18774, 626, 386, 15, 70, "Caption",
 CellID->30807],
Cell[19163, 643, 457, 15, 70, "Text",
 CellID->23992],
Cell[19623, 660, 712, 23, 70, "Text",
 CellID->3890],
Cell[20338, 685, 239, 6, 70, "MathCaption",
 CellID->2528],
Cell[CellGroupData[{
Cell[20602, 695, 112, 3, 70, "Input",
 CellID->4275],
Cell[20717, 700, 696, 23, 36, "Output",
 CellID->211292674]
}, Open  ]],
Cell[21428, 726, 114, 3, 70, "MathCaption",
 CellID->21798],
Cell[CellGroupData[{
Cell[21567, 733, 160, 5, 30, "Input",
 CellID->6731],
Cell[21730, 740, 4309, 75, 173, "Output",
 Evaluatable->False,
 CellID->635484930]
}, Open  ]]
}, Open  ]],
Cell[26066, 819, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

