(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5699,        193]
NotebookOptionsPosition[      4177,        146]
NotebookOutlinePosition[      5246,        175]
CellTagsIndexPosition[      5203,        172]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["QUATERNIONS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Quaternions Package" :> 
          Documentation`HelpLookup[
           "paclet:Quaternions/tutorial/Quaternions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Quaternions Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"QuaternionQ" :> 
          Documentation`HelpLookup["paclet:Quaternions/ref/QuaternionQ"], 
          "UnitQuaternionQ" :> 
          Documentation`HelpLookup[
           "paclet:Quaternions/ref/UnitQuaternionQ"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"QuaternionQ\"\>", 
       2->"\<\"UnitQuaternionQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["IntegerQuaternionQ", "ObjectName",
 CellID->31647],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"IntegerQuaternionQ", "[", 
       StyleBox["q", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     " is an integer quaternion and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3181]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20493],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["QuaternionQ",
    BaseStyle->"Link",
    ButtonData->"paclet:Quaternions/ref/QuaternionQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UnitQuaternionQ",
    BaseStyle->"Link",
    ButtonData->"paclet:Quaternions/ref/UnitQuaternionQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8217]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13093],

Cell[TextData[ButtonBox["Quaternions Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Quaternions/tutorial/Quaternions"]], "Tutorials",
 CellID->16584]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IntegerQuaternionQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 42.7845232}", "context" -> "Quaternions`",
     "keywords" -> {}, "index" -> True, "label" -> 
    "Quaternions Package Symbol", "language" -> "en", "paclet" -> 
    "Quaternions Package", "status" -> "None", "summary" -> 
    "IntegerQuaternionQ[q] gives True if q is an integer quaternion and False \
otherwise.", "synonyms" -> {}, "title" -> "IntegerQuaternionQ", "type" -> 
    "Symbol", "uri" -> "Quaternions/ref/IntegerQuaternionQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1339, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1962, 61, 56, 1, 70, "ObjectName",
 CellID->31647],
Cell[2021, 64, 762, 25, 70, "Usage",
 CellID->3181]
}, Open  ]],
Cell[CellGroupData[{
Cell[2820, 94, 311, 9, 70, "SeeAlsoSection",
 CellID->20493],
Cell[3134, 105, 494, 17, 70, "SeeAlso",
 CellID->8217]
}, Open  ]],
Cell[CellGroupData[{
Cell[3665, 127, 314, 9, 70, "TutorialsSection",
 CellID->13093],
Cell[3982, 138, 153, 3, 70, "Tutorials",
 CellID->16584]
}, Open  ]],
Cell[4150, 144, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

