(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     58290,       2092]
NotebookOptionsPosition[     49191,       1783]
NotebookOutlinePosition[     51289,       1830]
CellTagsIndexPosition[     51246,       1827]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["QUATERNIONS PACKAGE TUTORIAL", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Abs" :> Documentation`HelpLookup["paclet:ref/Abs"], "AbsIJK" :> 
         Documentation`HelpLookup["paclet:Quaternions/ref/AbsIJK"], 
         "AdjustedSignIJK" :> 
         Documentation`HelpLookup["paclet:Quaternions/ref/AdjustedSignIJK"], 
         "Conjugate" :> Documentation`HelpLookup["paclet:ref/Conjugate"], 
         "EvenQ" :> Documentation`HelpLookup["paclet:ref/EvenQ"], 
         "FromQuaternion" :> 
         Documentation`HelpLookup["paclet:Quaternions/ref/FromQuaternion"], 
         "IntegerQuaternionQ" :> 
         Documentation`HelpLookup[
          "paclet:Quaternions/ref/IntegerQuaternionQ"], "LeftAssociates" :> 
         Documentation`HelpLookup["paclet:Quaternions/ref/LeftAssociates"], 
         "LeftGCD" :> 
         Documentation`HelpLookup["paclet:Quaternions/ref/LeftGCD"], "Mod" :> 
         Documentation`HelpLookup["paclet:ref/Mod"], "Norm" :> 
         Documentation`HelpLookup["paclet:ref/Norm"], "OddQ" :> 
         Documentation`HelpLookup["paclet:ref/OddQ"], "PrimaryLeftAssociate" :> 
         Documentation`HelpLookup[
          "paclet:Quaternions/ref/PrimaryLeftAssociate"], 
         "PrimaryRightAssociate" :> 
         Documentation`HelpLookup[
          "paclet:Quaternions/ref/PrimaryRightAssociate"], "PrimeQ" :> 
         Documentation`HelpLookup["paclet:ref/PrimeQ"], "Quaternion" :> 
         Documentation`HelpLookup["paclet:Quaternions/ref/Quaternion"], 
         "QuaternionQ" :> 
         Documentation`HelpLookup["paclet:Quaternions/ref/QuaternionQ"], 
         "Quaternions" :> 
         Documentation`HelpLookup["paclet:Quaternions/ref/Quaternions"], "Re" :> 
         Documentation`HelpLookup["paclet:ref/Re"], "RightAssociates" :> 
         Documentation`HelpLookup["paclet:Quaternions/ref/RightAssociates"], 
         "RightGCD" :> 
         Documentation`HelpLookup["paclet:Quaternions/ref/RightGCD"], "Round" :> 
         Documentation`HelpLookup["paclet:ref/Round"], "Sign" :> 
         Documentation`HelpLookup["paclet:ref/Sign"], "ToQuaternion" :> 
         Documentation`HelpLookup["paclet:Quaternions/ref/ToQuaternion"], 
         "True" :> Documentation`HelpLookup["paclet:ref/True"], 
         "UnitQuaternionQ" :> 
         Documentation`HelpLookup["paclet:Quaternions/ref/UnitQuaternionQ"], 
         "UnitQuaternions" :> 
         Documentation`HelpLookup[
          "paclet:Quaternions/ref/UnitQuaternions"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Abs\"\>", 2->"\<\"AbsIJK\"\>", 
      3->"\<\"AdjustedSignIJK\"\>", 4->"\<\"Conjugate\"\>", 
      5->"\<\"EvenQ\"\>", 6->"\<\"FromQuaternion\"\>", 
      7->"\<\"IntegerQuaternionQ\"\>", 8->"\<\"LeftAssociates\"\>", 
      9->"\<\"LeftGCD\"\>", 10->"\<\"Mod\"\>", 11->"\<\"Norm\"\>", 
      12->"\<\"OddQ\"\>", 13->"\<\"PrimaryLeftAssociate\"\>", 
      14->"\<\"PrimaryRightAssociate\"\>", 15->"\<\"PrimeQ\"\>", 
      16->"\<\"Quaternion\"\>", 17->"\<\"QuaternionQ\"\>", 
      18->"\<\"Quaternions\"\>", 19->"\<\"Re\"\>", 
      20->"\<\"RightAssociates\"\>", 21->"\<\"RightGCD\"\>", 
      22->"\<\"Round\"\>", 23->"\<\"Sign\"\>", 24->"\<\"ToQuaternion\"\>", 
      25->"\<\"True\"\>", 26->"\<\"UnitQuaternionQ\"\>", 
      27->"\<\"UnitQuaternions\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Quaternions Package", "Title",
 CellID->29624],

Cell[TextData[{
 "This package implements Hamilton\[CloseCurlyQuote]s quaternion algebra. \
Quaternions have the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a", "TI"], "+", 
    StyleBox["b", "TI"], 
    StyleBox["i", "TI"], "+", 
    StyleBox["c", "TI"], 
    StyleBox["j", "TI"], "+", 
    StyleBox["d", "TI"], 
    StyleBox["k", "TI"]}], TraditionalForm]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TI"], TraditionalForm]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b", "TI"], TraditionalForm]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["c", "TI"], TraditionalForm]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox["d", "TI"], TraditionalForm]], "InlineFormula"],
 " are real numbers. The symbols ",
 Cell[BoxData[
  FormBox[
   StyleBox["i", "TI"], TraditionalForm]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["j", "TI"], TraditionalForm]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox["k", "TI"], TraditionalForm]], "InlineFormula"],
 " are multiplied according to the rules ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["i", "TI"], "2"], "=", 
    SuperscriptBox[
     StyleBox["j", "TI"], "2"], "=", 
    SuperscriptBox[
     StyleBox["k", "TI"], "2"], "=", 
    StyleBox["i", "TI"], 
    StyleBox["j", "TI"], 
    StyleBox["k", "TI"], "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineFormula"],
 ". Quaternions are an extension of the complex numbers, and work much the \
same except that their multiplication is not commutative. For instance, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["i", "TI"], 
    StyleBox["j", "TI"], "=", "-", 
    StyleBox["j", "TI"], 
    StyleBox["i", "TI"]}], TraditionalForm]], "InlineFormula"],
 ". "
}], "Text",
 CellID->32082],

Cell[TextData[{
 "Because of the similarities between quaternions and complex numbers, this \
package imitates ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s treatment of complex numbers in many ways. To provide a \
clear distinction between quaternions and complex numbers, all quaternions \
should be entered using the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quaternion",
    BaseStyle->"Link",
    ButtonData->"paclet:Quaternions/ref/Quaternion"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", " ", 
    StyleBox["b", "TI"], ",", " ", 
    StyleBox["c", "TI"], ",", " ", 
    StyleBox["d", "TI"]}], "]"}]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TI"], TraditionalForm]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b", "TI"], TraditionalForm]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["c", "TI"], TraditionalForm]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox["d", "TI"], TraditionalForm]], "InlineFormula"],
 " are real numbers. Only limited support is offered to the symbolic form ",
 StyleBox["a", "TI"],
 " ",
 StyleBox["+", "MR"],
 " ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 " ",
 StyleBox["b", "TI"],
 " ",
 StyleBox["+", "MR"],
 " ",
 Cell[BoxData["J"], "InlineFormula"],
 " ",
 StyleBox["c", "TI"],
 " ",
 StyleBox["+", "MR"],
 " ",
 Cell[BoxData["K"], "InlineFormula"],
 " ",
 StyleBox["d", "TI"],
 ". "
}], "Text",
 CellID->9378],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Quaternion",
      BaseStyle->"Link",
      ButtonData->"paclet:Quaternions/ref/Quaternion"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["c", "TI"], ",", 
     StyleBox["d", "TI"], "]"}], Cell[TextData[{
     "the quaternion number ",
     Cell[BoxData[
      RowBox[{
       StyleBox["a", "TI"], "+", 
       StyleBox["b", "TI"], 
       StyleBox["i", "TI"], "+", 
       StyleBox["c", "TI"], 
       StyleBox["j", "TI"], "+", 
       StyleBox["d", "TI"], 
       StyleBox["k", "TI"]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["QuaternionQ",
      BaseStyle->"Link",
      ButtonData->"paclet:Quaternions/ref/QuaternionQ"], "[", 
     StyleBox["w", "TI"], "]"}], Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     " is a quaternion number"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FromQuaternion",
      BaseStyle->"Link",
      ButtonData->"paclet:Quaternions/ref/FromQuaternion"], "[", 
     StyleBox["w", "TI"], "]"}], Cell[TextData[{
     "transform the ",
     StyleBox[ButtonBox["Quaternion",
      BaseStyle->"Link",
      ButtonData->"paclet:Quaternions/ref/Quaternion"], "InlineCode"],
     " object ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     " to the symbolic form ",
     Cell[BoxData[
      RowBox[{
       StyleBox["a", "TI"], "+", 
       RowBox[{"I", " ", 
        StyleBox["b", "TI"]}], "+", 
       RowBox[{"J", " ", 
        StyleBox["c", "TI"]}], "+", 
       RowBox[{"K", " ", 
        StyleBox["d", "TI"]}]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ToQuaternion",
      BaseStyle->"Link",
      ButtonData->"paclet:Quaternions/ref/ToQuaternion"], "[", 
     StyleBox["w", "TI"], "]"}], Cell[TextData[{
     "transform ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     " to a ",
     StyleBox[ButtonBox["Quaternion",
      BaseStyle->"Link",
      ButtonData->"paclet:Quaternions/ref/Quaternion"], "InlineCode"],
     " object if possible "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->12425],

Cell["Defining, testing, and transforming quaternions. ", "Caption",
 CellID->23744],

Cell["This loads the package. ", "MathCaption",
 CellID->10245],

Cell[BoxData[
 RowBox[{"<<", "Quaternions`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22373],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Quaternion",
   BaseStyle->"Link",
   ButtonData->"paclet:Quaternions/ref/Quaternion"]], "InlineFormula"],
 " objects will not automatically simplify to ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " numbers. "
}], "MathCaption",
 CellID->21228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"3", "+", 
  RowBox[{"2", " ", "\[ImaginaryI]"}], "+", 
  RowBox[{"Quaternion", "[", 
   RowBox[{"2", ",", "0", ",", 
    RowBox[{"-", "6"}], ",", "0"}], "]"}], "-", 
  RowBox[{"3", " ", 
   RowBox[{"Quaternion", "[", 
    RowBox[{"1", ",", "3", ",", 
     RowBox[{"-", "2"}], ",", "0"}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19409],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{"2", ",", 
   RowBox[{"-", "7"}], ",", "0", ",", "0"}], "]"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18571319]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FromQuaternion",
   BaseStyle->"Link",
   ButtonData->"paclet:Quaternions/ref/FromQuaternion"]], "InlineFormula"],
 " transforms this ",
 Cell[BoxData[
  ButtonBox["Quaternion",
   BaseStyle->"Link",
   ButtonData->"paclet:Quaternions/ref/Quaternion"]], "InlineFormula"],
 " object to an object with head ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromQuaternion", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->24371],

Cell[BoxData[
 RowBox[{"2", "-", 
  RowBox[{"7", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->89883634]
}, Open  ]],

Cell[TextData[{
 "The primary purpose of this package is to define arithmetic for \
quaternions. It adds rules to ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Minus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minus"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Divide",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Divide"]], "InlineFormula"],
 ", and, most importantly, ",
 Cell[BoxData[
  ButtonBox["NonCommutativeMultiply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NonCommutativeMultiply"]], "InlineFormula"],
 ". It is only legal to use ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " when multiplying two nonquaternions or a quaternion by a ",
 StyleBox["scalar",
  FontSlant->"Italic"],
 " (",
 StyleBox["i.e.",
  FontSlant->"Italic"],
 ", real) number. When multiplying two quaternions, you must use ",
 Cell[BoxData[
  ButtonBox["NonCommutativeMultiply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NonCommutativeMultiply"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->7275],

Cell["Addition is done component by component. ", "MathCaption",
 CellID->18508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Quaternion", "[", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "]"}], "+", 
  RowBox[{"Quaternion", "[", 
   RowBox[{"2", ",", "3", ",", "4", ",", "5"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->2151],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{"3", ",", "5", ",", "7", ",", "9"}], "]"}]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->474988667]
}, Open  ]],

Cell["\<\
Be sure to use ** rather than * when multiplying quaternions. \
\>", "MathCaption",
 CellID->19865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Quaternion", "[", 
   RowBox[{"2", ",", "0", ",", 
    RowBox[{"-", "6"}], ",", "3"}], "]"}], "**", 
  RowBox[{"Quaternion", "[", 
   RowBox[{"1", ",", "3", ",", 
    RowBox[{"-", "2"}], ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->18340],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{
   RowBox[{"-", "16"}], ",", "0", ",", 
   RowBox[{"-", "1"}], ",", "25"}], "]"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->616834159]
}, Open  ]],

Cell["This multiplication is noncommutative. ", "MathCaption",
 CellID->28624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Quaternion", "[", 
   RowBox[{"1", ",", "3", ",", 
    RowBox[{"-", "2"}], ",", "2"}], "]"}], "**", 
  RowBox[{"Quaternion", "[", 
   RowBox[{"2", ",", "0", ",", 
    RowBox[{"-", "6"}], ",", "3"}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->32345],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{
   RowBox[{"-", "16"}], ",", "12", ",", 
   RowBox[{"-", "19"}], ",", 
   RowBox[{"-", "11"}]}], "]"}]], "Output",
 ImageSize->{201, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->501321158]
}, Open  ]],

Cell[TextData[{
 "Be careful with ",
 Cell[BoxData[
  ButtonBox["Divide",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Divide"]], "InlineFormula"],
 " since ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s internal rules quickly turn it into ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->20999],

Cell[CellGroupData[{

Cell[BoxData[
 FractionBox[
  RowBox[{"Quaternion", "[", 
   RowBox[{"1", ",", "3", ",", 
    RowBox[{"-", "2"}], ",", "0"}], "]"}], 
  RowBox[{"Quaternion", "[", 
   RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "]"}]]], "Input",
 CellLabel->"In[7]:=",
 CellID->3780],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quaternion", "[", 
   RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "]"}], " ", 
  RowBox[{"Quaternion", "[", 
   RowBox[{"1", ",", "3", ",", 
    RowBox[{"-", "2"}], ",", "0"}], "]"}]}]], "Output",
 ImageSize->{306, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->700683737]
}, Open  ]],

Cell[TextData[{
 "Although quaternions are whole algebraic objects, just as with complex \
numbers, it is sometimes useful to look at their component parts. These \
objects form a vector space over the real numbers, with their standard basis \
being ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"1", ",", 
     StyleBox["i", "TI"], ",", 
     StyleBox["j", "TI"], ",", 
     StyleBox["k", "TI"]}], "}"}], TraditionalForm]], "InlineFormula"],
 ". You may use standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " techniques for extracting the individual components. However, there are \
other vector\[Hyphen]type parameters such as length and direction which you \
may want to look at as well. "
}], "Text",
 CellID->21020],

Cell[TextData[{
 "The projection of a quaternion onto ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"i", "j", "k"}], "TI"], TraditionalForm]], "InlineFormula"],
 " space, the nonreal part of the quaternion, is called the ",
 StyleBox["pure quaternion part",
  FontSlant->"Italic"],
 ". This plays a role similar to the pure imaginary part of a complex number. \
"
}], "Text",
 CellID->6216],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Re",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Re"], "[", 
     StyleBox["w", "TI"], "]"}], Cell[TextData[{
     "the real part Re ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Conjugate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Conjugate"], "[", 
     StyleBox["w", "TI"], "]"}], Cell[TextData[{
     "the quaternion conjugate ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["w", "TI"], "*"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Abs",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Abs"], "[", 
     StyleBox["w", "TI"], "]"}], Cell[TextData[{
     "the absolute value ",
     Cell[BoxData[
      RowBox[{"\[VerticalSeparator]", 
       StyleBox["w", "TI"], "\[VerticalSeparator]"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AbsIJK",
      BaseStyle->"Link",
      ButtonData->"paclet:Quaternions/ref/AbsIJK"], "[", 
     StyleBox["w", "TI"], "]"}], Cell[TextData[{
     "the magnitude of the pure quaternion part of ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Norm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Norm"], "[", 
     StyleBox["w", "TI"], "]"}], Cell[TextData[{
     "the sum of the squares of the components of ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Sign",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sign"], "[", 
     StyleBox["w", "TI"], "]"}], Cell[TextData[{
     "the sign of the quaternion ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AdjustedSignIJK",
      BaseStyle->"Link",
      ButtonData->"paclet:Quaternions/ref/AdjustedSignIJK"], "[", 
     StyleBox["w", "TI"], "]"}], Cell[TextData[{
     "the sign of the pure quaternion part of ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     ", adjusted so its first nonzero component is positive"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->18040],

Cell["Component functions of quaternions.", "Caption",
 CellID->13182],

Cell["\<\
In the conjugate of a quaternion, all the signs of the nonreal components are \
reversed. \
\>", "MathCaption",
 CellID->22677],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"q", "=", 
  RowBox[{"Conjugate", "[", 
   RowBox[{"Quaternion", "[", 
    RowBox[{"4", ",", 
     RowBox[{"-", "3"}], ",", "1", ",", 
     RowBox[{"-", "2"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->27658],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{"4", ",", "3", ",", 
   RowBox[{"-", "1"}], ",", "2"}], "]"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->158014937]
}, Open  ]],

Cell["\<\
The sign of a quaternion is defined in the same way as the sign of a complex \
number. It is the \[OpenCurlyDoubleQuote]direction\[CloseCurlyDoubleQuote] of \
the quaternion. \
\>", "MathCaption",
 CellID->30223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sign", "[", "q", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->37],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{
   RowBox[{"2", " ", 
    SqrtBox[
     FractionBox["2", "15"]]}], ",", 
   SqrtBox[
    FractionBox["3", "10"]], ",", 
   RowBox[{"-", 
    FractionBox["1", 
     SqrtBox["30"]]}], ",", 
   SqrtBox[
    FractionBox["2", "15"]]}], "]"}]], "Output",
 ImageSize->{289, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->83677184]
}, Open  ]],

Cell["This returns a quaternion with norm 1 and real part 0. ", "MathCaption",
 CellID->8568],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AdjustedSignIJK", "[", "q", "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->3378],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{"0", ",", 
   FractionBox["3", 
    SqrtBox["14"]], ",", 
   RowBox[{"-", 
    FractionBox["1", 
     SqrtBox["14"]]}], ",", 
   SqrtBox[
    FractionBox["2", "7"]]}], "]"}]], "Output",
 ImageSize->{238, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->116120319]
}, Open  ]],

Cell["This gives the standard Euclidean length. ", "MathCaption",
 CellID->31603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "[", "q", "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->28243],

Cell[BoxData[
 SqrtBox["30"]], "Output",
 ImageSize->{35, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->661948297]
}, Open  ]],

Cell[TextData[{
 "A quaternion with a zero ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 " component will still have a nonzero pure quaternion part. "
}], "MathCaption",
 CellID->24055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsIJK", "[", 
  RowBox[{"Quaternion", "[", 
   RowBox[{"1", ",", "0", ",", "2", ",", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->5234],

Cell[BoxData[
 SqrtBox["13"]], "Output",
 ImageSize->{35, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->180371158]
}, Open  ]],

Cell[TextData[{
 "For a complex number ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["z", "TI"], "=", 
    StyleBox["x", "TI"], "+", 
    StyleBox["i", "TI"], 
    StyleBox["y", "TI"]}], TraditionalForm]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["e", "TI"], 
    StyleBox["z", "TI"]], TraditionalForm]], "InlineFormula"],
 " is defined by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["x", "TI"]], 
    RowBox[{"(", 
     RowBox[{"cos", 
      StyleBox["y", "TI"], "+", 
      StyleBox["i", "TI"], "sin", 
      StyleBox["y", "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
 ". The package defines ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["e", "TI"], 
    StyleBox["q", "TI"]], TraditionalForm]], "InlineFormula"],
 " in a similar way, using the pure quaternion part of ",
 Cell[BoxData[
  FormBox[
   StyleBox["q", "TI"], TraditionalForm]], "InlineFormula"],
 " instead of the pure imaginary part of a complex number. Indeed, it makes \
analogous definitions for the following elementary functions: ",
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Cos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cos"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Tan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tan"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Sec",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sec"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Csc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Csc"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Cot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ArcCos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCos"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ArcSin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSin"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ArcTan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTan"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ArcSec",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSec"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ArcCsc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCsc"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ArcCot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Cosh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cosh"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Sinh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sinh"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Tanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tanh"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Sech",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sech"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Csch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Csch"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Coth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Coth"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ArcCosh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCosh"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ArcSinh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSinh"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ArcTanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTanh"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ArcSech",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSech"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ArcCsch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCsch"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["ArcCoth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCoth"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->4845],

Cell["The exponential of a quaternion can be quite complicated. ", \
"MathCaption",
 CellID->3289],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"Quaternion", "[", 
   RowBox[{"2", ",", "3", ",", "1", ",", "6"}], "]"}]]], "Input",
 CellLabel->"In[13]:=",
 CellID->11401],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "2"], " ", 
    RowBox[{"Cos", "[", 
     SqrtBox["46"], "]"}]}], ",", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["\[ExponentialE]", "2"], " ", 
     RowBox[{"Sin", "[", 
      SqrtBox["46"], "]"}]}], 
    SqrtBox["46"]], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "2"], " ", 
     RowBox[{"Sin", "[", 
      SqrtBox["46"], "]"}]}], 
    SqrtBox["46"]], ",", 
   RowBox[{"3", " ", 
    SqrtBox[
     FractionBox["2", "23"]], " ", 
    SuperscriptBox["\[ExponentialE]", "2"], " ", 
    RowBox[{"Sin", "[", 
     SqrtBox["46"], "]"}]}]}], "]"}]], "Output",
 ImageSize->{517, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->46458000]
}, Open  ]],

Cell["\<\
Just as with complex numbers, it is important to beware of branch cuts. \
\>", "MathCaption",
 CellID->16611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"Cos", "[", 
   RowBox[{"Quaternion", "[", 
    RowBox[{".3", ",", ".1", ",", ".5", ",", ".5"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->25502],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{
  "0.9601629306397524`", ",", "0.01145767911787049`", ",", 
   "0.057288395589352455`", ",", "0.057288395589352455`"}], "]"}]], "Output",
 ImageSize->{367, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->430608160]
}, Open  ]],

Cell["\<\
A four\[Hyphen]dimensional analog of deMoivre\[CloseCurlyQuote]s theorem is \
used for calculating powers of quaternions. \
\>", "MathCaption",
 CellID->23290],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"Quaternion", "[", 
   RowBox[{"1", ",", "2", ",", "0", ",", "1"}], "]"}], "2.5"]], "Input",
 CellLabel->"In[15]:=",
 CellID->23758],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{
   RowBox[{"-", "9.060398190482424`"}], ",", "2.2074085023116488`", ",", "0", 
   ",", "1.1037042511558244`"}], "]"}]], "Output",
 ImageSize->{270, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->42623838]
}, Open  ]],

Cell[TextData[{
 "The functions so far have been intended to work with quaternions whose \
components are arbitrary real numbers. Just as the integers and Gaussian \
integers are interesting subsets of the reals and complexes, there is a \
special subset of the quaternions called the quaternion integers. This subset \
is a little broader than one might expect. It includes not only those \
quaternions that have all integer components, but also those quaternions that \
have all components being odd multiples of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "2"}], TraditionalForm]], "InlineFormula"],
 ". In this subset there are 24 quaternions that have multiplicative \
inverses. These are the ",
 StyleBox["units",
  FontSlant->"Italic"],
 " of the algebra. They correspond roughly to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     StyleBox["i", "TI"], ",", "-", 
     StyleBox["i", "TI"]}], "}"}], TraditionalForm]], "InlineFormula"],
 " in the Gaussian integers. "
}], "Text",
 CellID->24918],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Round",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Round"], "[", 
     StyleBox["w", "TI"], "]"}], Cell[TextData[{
     "the closest integer quaternion to ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["OddQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OddQ"], "[", 
     StyleBox["w", "TI"], "]"}], Cell[TextData[{
     "test whether the quaternion ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     " is odd"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["EvenQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EvenQ"], "[", 
     StyleBox["w", "TI"], "]"}], Cell[TextData[{
     "test whether the quaternion ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     " is even"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["IntegerQuaternionQ",
      BaseStyle->"Link",
      ButtonData->"paclet:Quaternions/ref/IntegerQuaternionQ"], "[", 
     StyleBox["w", "TI"], "]"}], Cell[TextData[{
     "test whether the quaternion ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     " is an integer quaternion"
    }], "TableText"]},
   {
    ButtonBox["UnitQuaternions",
     BaseStyle->"Link",
     ButtonData->"paclet:Quaternions/ref/UnitQuaternions"], Cell["\<\
the list of 24 units of Hamilton\[CloseCurlyQuote]s division algebra\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["UnitQuaternionQ",
      BaseStyle->"Link",
      ButtonData->"paclet:Quaternions/ref/UnitQuaternionQ"], "[", 
     StyleBox["w", "TI"], "]"}], Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     " is a unit quaternion"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->2061],

Cell["Integer quaternion functions.", "Caption",
 CellID->28996],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Round",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Round"]], "InlineFormula"],
 " for quaternions returns a ",
 Cell[BoxData[
  ButtonBox["Quaternion",
   BaseStyle->"Link",
   ButtonData->"paclet:Quaternions/ref/Quaternion"]], "InlineFormula"],
 " in which either all components are integers, or all components are odd \
multiples of 1/2. "
}], "MathCaption",
 CellID->3453],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Round", "[", 
  RowBox[{"Quaternion", "[", 
   RowBox[{
    FractionBox["1", "2"], ",", "3", ",", "4", ",", 
    FractionBox["5", "2"]}], "]"}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->8550],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{"0", ",", "3", ",", "4", ",", "2"}], "]"}]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->618322298]
}, Open  ]],

Cell["A quaternion is even if its norm is even. ", "MathCaption",
 CellID->32277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EvenQ", "[", 
  RowBox[{"Quaternion", "[", 
   RowBox[{"2", ",", "3", ",", "4", ",", "5"}], "]"}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->20226],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->718195043]
}, Open  ]],

Cell["\<\
A quaternion integer has components that are either all integers or all \
halves of odd integers. \
\>", "MathCaption",
 CellID->4955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerQuaternionQ", "[", 
  RowBox[{"Quaternion", "[", 
   RowBox[{
    FractionBox["3", "2"], ",", 
    FractionBox["1", "2"], ",", 
    RowBox[{"-", 
     FractionBox["1", "2"]}], ",", 
    FractionBox["5", "2"]}], "]"}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->3713],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->212606639]
}, Open  ]],

Cell[TextData[{
 "Given a quaternion ",
 Cell[BoxData[
  FormBox[
   StyleBox["q", "TI"], TraditionalForm]], "InlineFormula"],
 " and a unit quaternion ",
 Cell[BoxData[
  FormBox[
   StyleBox["e", "TI"], TraditionalForm]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"q", "e"}], "TI"], TraditionalForm]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"e", "q"}], "TI"], TraditionalForm]], "InlineFormula"],
 " are, respectively, right and left ",
 StyleBox["associates",
  FontSlant->"Italic"],
 " of ",
 Cell[BoxData[
  FormBox[
   StyleBox["q", "TI"], TraditionalForm]], "InlineFormula"],
 ". It is useful to choose an arbitrary associate and call it the ",
 StyleBox["primary",
  FontSlant->"Italic"],
 " associate. This package chooses the associate with the largest real \
component. "
}], "Text",
 CellID->26870],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LeftAssociates",
      BaseStyle->"Link",
      ButtonData->"paclet:Quaternions/ref/LeftAssociates"], "[", 
     StyleBox["w", "TI"], "]"}], Cell[TextData[{
     "the list of 24 left associates of the quaternion ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RightAssociates",
      BaseStyle->"Link",
      ButtonData->"paclet:Quaternions/ref/RightAssociates"], "[", 
     StyleBox["w", "TI"], "]"}], Cell[TextData[{
     "the list of 24 right associates of the quaternion ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PrimaryLeftAssociate",
      BaseStyle->"Link",
      ButtonData->"paclet:Quaternions/ref/PrimaryLeftAssociate"], "[", 
     StyleBox["w", "TI"], ",", 
     StyleBox["side", "TI"], "]"}], Cell[TextData[{
     "the primary left associate of the quaternion ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PrimaryRightAssociate",
      BaseStyle->"Link",
      ButtonData->"paclet:Quaternions/ref/PrimaryRightAssociate"], "[", 
     StyleBox["w", "TI"], ",", 
     StyleBox["side", "TI"], "]"}], Cell[TextData[{
     "the primary right associate of the quaternion ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->11479],

Cell["The associates of an integer quaternion. ", "Caption",
 CellID->32681],

Cell["This is the primary left associate of the quaternion. ", "MathCaption",
 CellID->23741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimaryLeftAssociate", "[", 
  RowBox[{"Quaternion", "[", 
   RowBox[{"1", ",", "4", ",", "5", ",", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->29205],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{
   FractionBox["13", "2"], ",", 
   FractionBox["5", "2"], ",", 
   FractionBox["3", "2"], ",", 
   FractionBox["1", "2"]}], "]"}]], "Output",
 ImageSize->{174, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->549727144]
}, Open  ]],

Cell["The primary right associate is often very similar. ", "MathCaption",
 CellID->2884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimaryRightAssociate", "[", 
  RowBox[{"Quaternion", "[", 
   RowBox[{"1", ",", "4", ",", "5", ",", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->6154],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{
   FractionBox["13", "2"], ",", 
   FractionBox["1", "2"], ",", 
   FractionBox["5", "2"], ",", 
   FractionBox["3", "2"]}], "]"}]], "Output",
 ImageSize->{174, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->487073204]
}, Open  ]],

Cell[TextData[{
 "Quaternion multiplication is noncommutative, so there are two greatest \
common denominators, one for the left side and one for the right. Since this \
function depends on the value returned by ",
 StyleBox[ButtonBox["PrimaryLeftAssociate",
  BaseStyle->"Link",
  ButtonData->"paclet:Quaternions/ref/PrimaryLeftAssociate"], "MR"],
 " and ",
 StyleBox[ButtonBox["PrimaryRightAssociate",
  BaseStyle->"Link",
  ButtonData->"paclet:Quaternions/ref/PrimaryRightAssociate"], "MR"],
 ", the ",
 Cell[BoxData[
  ButtonBox["RightGCD",
   BaseStyle->"Link",
   ButtonData->"paclet:Quaternions/ref/RightGCD"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LeftGCD",
   BaseStyle->"Link",
   ButtonData->"paclet:Quaternions/ref/LeftGCD"]], "InlineFormula"],
 " are not unique. "
}], "Text",
 CellID->18236],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LeftGCD",
      BaseStyle->"Link",
      ButtonData->"paclet:Quaternions/ref/LeftGCD"], "[", 
     StyleBox["w", "TI"], ",", 
     StyleBox["u", "TI"], "]"}], Cell[TextData[{
     "the greatest common left divisor of ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RightGCD",
      BaseStyle->"Link",
      ButtonData->"paclet:Quaternions/ref/RightGCD"], "[", 
     StyleBox["w", "TI"], ",", 
     StyleBox["u", "TI"], "]"}], Cell[TextData[{
     "the greatest common right divisor of ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Mod",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Mod"], "[", 
     StyleBox["w", "TI"], ",", 
     StyleBox["u", "TI"], "]"}], 
    RowBox[{
     StyleBox["w", "TI"], Cell[" modulo ", "TableText"], 
     StyleBox["u", "TI"], Cell[" (remainder on division of ", "TableText"], 
     StyleBox["w", "TI"], Cell[" by ", "TableText"], 
     StyleBox["u", "TI"], Cell[")", "TableText"]}]}
  }]], "DefinitionBox",
 CellID->27283],

Cell["Some integer division functions.", "Caption",
 CellID->29242],

Cell[TextData[{
 "The largest quaternion that divides both of these is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quaternion",
    BaseStyle->"Link",
    ButtonData->"paclet:Quaternions/ref/Quaternion"], "[", 
   RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->8559],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeftGCD", "[", 
  RowBox[{
   RowBox[{"Quaternion", "[", 
    RowBox[{"1", ",", "3", ",", "4", ",", "1"}], "]"}], ",", 
   RowBox[{"Quaternion", "[", 
    RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->12228],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "]"}]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->224576698]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["LeftGCD",
   BaseStyle->"Link",
   ButtonData->"paclet:Quaternions/ref/LeftGCD"]], "InlineFormula"],
 " and the ",
 Cell[BoxData[
  ButtonBox["RightGCD",
   BaseStyle->"Link",
   ButtonData->"paclet:Quaternions/ref/RightGCD"]], "InlineFormula"],
 " can be quite different. "
}], "MathCaption",
 CellID->17309],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RightGCD", "[", 
  RowBox[{
   RowBox[{"Quaternion", "[", 
    RowBox[{"1", ",", "3", ",", "4", ",", "1"}], "]"}], ",", 
   RowBox[{"Quaternion", "[", 
    RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->1336],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{
   FractionBox["3", "2"], ",", 
   FractionBox["1", "2"], ",", 
   FractionBox["1", "2"], ",", 
   RowBox[{"-", 
    FractionBox["1", "2"]}]}], "]"}]], "Output",
 ImageSize->{174, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->146347549]
}, Open  ]],

Cell[TextData[{
 "Just as with complex numbers, the quaternion ",
 Cell[BoxData[
  ButtonBox["Mod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mod"]], "InlineFormula"],
 " works. "
}], "MathCaption",
 CellID->25217],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{
   RowBox[{"Quaternion", "[", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "4", ",", "1", ",", "2"}], "]"}], ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->8943],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{"0", ",", "1", ",", "1", ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->197242236]
}, Open  ]],

Cell["You can specify a quaternion as the modulus. ", "MathCaption",
 CellID->2186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{
   RowBox[{"Quaternion", "[", 
    RowBox[{"1", ",", "3", ",", "4", ",", "1"}], "]"}], ",", 
   RowBox[{"Quaternion", "[", 
    RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->18794],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{"1", ",", "1", ",", 
   RowBox[{"-", "1"}], ",", "0"}], "]"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->986166746]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimeQ"]], "InlineFormula"],
 " has the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GaussianIntegers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GaussianIntegers"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " that checks to see if a number is prime with respect to the Gaussian \
integers. This package extends ",
 Cell[BoxData[
  ButtonBox["PrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimeQ"]], "InlineFormula"],
 " farther to check if a number is prime with respect to the quaternions. "
}], "Text",
 CellID->26047],

Cell[TextData[{
 "Lagrange proved that every integer can be expressed as a sum of squares of, \
at most, four integers. Therefore, given an integer ",
 Cell[BoxData[
  FormBox[
   StyleBox["n", "TI"], TraditionalForm]], "InlineFormula"],
 ", there is a quaternion ",
 Cell[BoxData[
  FormBox[
   StyleBox["q", "TI"], TraditionalForm]], "InlineFormula"],
 " with integer components such that ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["q", "TI"], " ", "**", " ", 
    RowBox[{
     ButtonBox["Conjugate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Conjugate"], "[", 
     StyleBox["q", "TI"], "]"}]}], " ", "==", " ", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 ". So no integer is prime with respect to the quaternions. In fact, a \
quaternion integer is prime, if and only if, its norm is prime in the usual \
sense. "
}], "Text",
 CellID->16591],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PrimeQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PrimeQ"], "[", 
     StyleBox["n", "TI"], ",", 
     ButtonBox["Quaternions",
      BaseStyle->"Link",
      ButtonData->"paclet:Quaternions/ref/Quaternions"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], "]"}], Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " is a prime with respect to the quaternions "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->20548],

Cell[TextData[{
 "An extension of ",
 Cell[BoxData[
  ButtonBox["PrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimeQ"]], "InlineFormula"],
 "."
}], "Caption",
 CellID->17128],

Cell["19 is a prime with respect to the Gaussian integers. ", "MathCaption",
 CellID->16161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQ", "[", 
  RowBox[{"19", ",", 
   RowBox[{"GaussianIntegers", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->26746],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->113946998]
}, Open  ]],

Cell[TextData[{
 "It is not a prime with respect to the quaternions. It can be factored into \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quaternion",
    BaseStyle->"Link",
    ButtonData->"paclet:Quaternions/ref/Quaternion"], "[", 
   RowBox[{"1", ",", "4", ",", "1", ",", "1"}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quaternion",
    BaseStyle->"Link",
    ButtonData->"paclet:Quaternions/ref/Quaternion"], "[", 
   RowBox[{"1", ",", 
    RowBox[{"-", "4"}], ",", 
    RowBox[{"-", "1"}], ",", 
    RowBox[{"-", "1"}]}], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQ", "[", 
  RowBox[{"19", ",", 
   RowBox[{"Quaternions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->18080],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->7668252]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quaternion",
    BaseStyle->"Link",
    ButtonData->"paclet:Quaternions/ref/Quaternion"], "[", 
   RowBox[{"1", ",", "3", ",", "0", ",", "1"}], "]"}]], "InlineFormula"],
 " is a prime quaternion. "
}], "MathCaption",
 CellID->7251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQ", "[", 
  RowBox[{
   RowBox[{"Quaternion", "[", 
    RowBox[{"1", ",", "3", ",", "0", ",", "1"}], "]"}], ",", 
   RowBox[{"Quaternions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->14148],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->994765762]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Quaternions Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 51.8472552}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Quaternions Package Tutorial", "language" -> "en", "paclet" -> 
    "Quaternions Package", "status" -> "None", "summary" -> 
    "This package implements Hamilton's quaternion algebra. Quaternions have \
the form a+bi+cj+dk where a, b, c, and d are real numbers. The symbols i, j, \
and k are multiplied according to the rules i^2=j^2=k^2=ijk=-1. Quaternions \
are an extension of the complex numbers, and work much the same except that \
their multiplication is not commutative. For instance, ij=-ji. Because of the \
similarities between quaternions and complex numbers, this package imitates \
Mathematica's treatment of complex numbers in many ways. To provide a clear \
distinction between quaternions and complex numbers, all quaternions should \
be entered using the form Quaternion[a, b, c, d] where a, b, c, and d are \
real numbers. Only limited support is offered to the symbolic form a + I b + \
J c + K d. Defining, testing, and transforming quaternions. ", 
    "synonyms" -> {}, "title" -> "Quaternions Package", "type" -> "Tutorial", 
    "uri" -> "Quaternions/tutorial/Quaternions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3620, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4245, 92, 52, 1, 70, "Title",
 CellID->29624],
Cell[4300, 95, 1871, 66, 70, "Text",
 CellID->32082],
Cell[6174, 163, 1548, 59, 70, "Text",
 CellID->9378],
Cell[7725, 224, 2217, 72, 70, "DefinitionBox",
 CellID->12425],
Cell[9945, 298, 84, 1, 70, "Caption",
 CellID->23744],
Cell[10032, 301, 63, 1, 70, "MathCaption",
 CellID->10245],
Cell[10098, 304, 95, 3, 70, "Input",
 CellID->22373],
Cell[10196, 309, 485, 17, 70, "MathCaption",
 CellID->21228],
Cell[CellGroupData[{
Cell[10706, 330, 371, 11, 28, "Input",
 CellID->19409],
Cell[11080, 343, 256, 8, 36, "Output",
 CellID->18571319]
}, Open  ]],
Cell[11351, 354, 509, 17, 70, "MathCaption",
 CellID->30678],
Cell[CellGroupData[{
Cell[11885, 375, 106, 3, 70, "Input",
 CellID->24371],
Cell[11994, 380, 214, 7, 36, "Output",
 CellID->89883634]
}, Open  ]],
Cell[12223, 390, 1314, 45, 70, "Text",
 CellID->7275],
Cell[13540, 437, 80, 1, 70, "MathCaption",
 CellID->18508],
Cell[CellGroupData[{
Cell[13645, 442, 249, 7, 70, "Input",
 CellID->2151],
Cell[13897, 451, 238, 7, 36, "Output",
 CellID->474988667]
}, Open  ]],
Cell[14150, 461, 109, 3, 70, "MathCaption",
 CellID->19865],
Cell[CellGroupData[{
Cell[14284, 468, 291, 9, 70, "Input",
 CellID->18340],
Cell[14578, 479, 278, 9, 36, "Output",
 CellID->616834159]
}, Open  ]],
Cell[14871, 491, 78, 1, 70, "MathCaption",
 CellID->28624],
Cell[CellGroupData[{
Cell[14974, 496, 291, 9, 70, "Input",
 CellID->32345],
Cell[15268, 507, 299, 10, 36, "Output",
 CellID->501321158]
}, Open  ]],
Cell[15582, 520, 427, 16, 70, "MathCaption",
 CellID->20999],
Cell[CellGroupData[{
Cell[16034, 540, 267, 8, 70, "Input",
 CellID->3780],
Cell[16304, 550, 363, 11, 36, "Output",
 CellID->700683737]
}, Open  ]],
Cell[16682, 564, 745, 19, 70, "Text",
 CellID->21020],
Cell[17430, 585, 398, 12, 70, "Text",
 CellID->6216],
Cell[17831, 599, 2274, 75, 70, "DefinitionBox",
 CellID->18040],
Cell[20108, 676, 70, 1, 70, "Caption",
 CellID->13182],
Cell[20181, 679, 137, 4, 70, "MathCaption",
 CellID->22677],
Cell[CellGroupData[{
Cell[20343, 687, 249, 8, 70, "Input",
 CellID->27658],
Cell[20595, 697, 257, 8, 36, "Output",
 CellID->158014937]
}, Open  ]],
Cell[20867, 708, 222, 5, 70, "MathCaption",
 CellID->30223],
Cell[CellGroupData[{
Cell[21114, 717, 93, 3, 70, "Input",
 CellID->37],
Cell[21210, 722, 432, 17, 62, "Output",
 CellID->83677184]
}, Open  ]],
Cell[21657, 742, 93, 1, 70, "MathCaption",
 CellID->8568],
Cell[CellGroupData[{
Cell[21775, 747, 107, 3, 70, "Input",
 CellID->3378],
Cell[21885, 752, 370, 14, 62, "Output",
 CellID->116120319]
}, Open  ]],
Cell[22270, 769, 81, 1, 70, "MathCaption",
 CellID->31603],
Cell[CellGroupData[{
Cell[22376, 774, 96, 3, 70, "Input",
 CellID->28243],
Cell[22475, 779, 171, 6, 38, "Output",
 CellID->661948297]
}, Open  ]],
Cell[22661, 788, 248, 8, 70, "MathCaption",
 CellID->24055],
Cell[CellGroupData[{
Cell[22934, 800, 179, 5, 70, "Input",
 CellID->5234],
Cell[23116, 807, 171, 6, 38, "Output",
 CellID->180371158]
}, Open  ]],
Cell[23302, 816, 4278, 170, 70, "Text",
 CellID->4845],
Cell[27583, 988, 98, 2, 70, "MathCaption",
 CellID->3289],
Cell[CellGroupData[{
Cell[27706, 994, 185, 5, 70, "Input",
 CellID->11401],
Cell[27894, 1001, 837, 29, 64, "Output",
 CellID->46458000]
}, Open  ]],
Cell[28746, 1033, 119, 3, 70, "MathCaption",
 CellID->16611],
Cell[CellGroupData[{
Cell[28890, 1040, 216, 7, 70, "Input",
 CellID->25502],
Cell[29109, 1049, 323, 9, 36, "Output",
 CellID->430608160]
}, Open  ]],
Cell[29447, 1061, 169, 4, 70, "MathCaption",
 CellID->23290],
Cell[CellGroupData[{
Cell[29641, 1069, 173, 5, 70, "Input",
 CellID->23758],
Cell[29817, 1076, 314, 9, 36, "Output",
 CellID->42623838]
}, Open  ]],
Cell[30146, 1088, 1063, 25, 70, "Text",
 CellID->24918],
Cell[31212, 1115, 1863, 62, 70, "DefinitionBox",
 CellID->2061],
Cell[33078, 1179, 64, 1, 70, "Caption",
 CellID->28996],
Cell[33145, 1182, 425, 13, 70, "MathCaption",
 CellID->3453],
Cell[CellGroupData[{
Cell[33595, 1199, 224, 7, 70, "Input",
 CellID->8550],
Cell[33822, 1208, 239, 7, 36, "Output",
 CellID->618322298]
}, Open  ]],
Cell[34076, 1218, 81, 1, 70, "MathCaption",
 CellID->32277],
Cell[CellGroupData[{
Cell[34182, 1223, 179, 5, 70, "Input",
 CellID->20226],
Cell[34364, 1230, 162, 5, 36, "Output",
 CellID->718195043]
}, Open  ]],
Cell[34541, 1238, 144, 4, 70, "MathCaption",
 CellID->4955],
Cell[CellGroupData[{
Cell[34710, 1246, 304, 10, 70, "Input",
 CellID->3713],
Cell[35017, 1258, 162, 5, 36, "Output",
 CellID->212606639]
}, Open  ]],
Cell[35194, 1266, 889, 32, 70, "Text",
 CellID->26870],
Cell[36086, 1300, 1497, 44, 70, "DefinitionBox",
 CellID->11479],
Cell[37586, 1346, 76, 1, 70, "Caption",
 CellID->32681],
Cell[37665, 1349, 93, 1, 70, "MathCaption",
 CellID->23741],
Cell[CellGroupData[{
Cell[37783, 1354, 194, 5, 70, "Input",
 CellID->29205],
Cell[37980, 1361, 328, 11, 51, "Output",
 CellID->549727144]
}, Open  ]],
Cell[38323, 1375, 89, 1, 70, "MathCaption",
 CellID->2884],
Cell[CellGroupData[{
Cell[38437, 1380, 194, 5, 70, "Input",
 CellID->6154],
Cell[38634, 1387, 328, 11, 51, "Output",
 CellID->487073204]
}, Open  ]],
Cell[38977, 1401, 824, 23, 70, "Text",
 CellID->18236],
Cell[39804, 1426, 1333, 42, 70, "DefinitionBox",
 CellID->27283],
Cell[41140, 1470, 67, 1, 70, "Caption",
 CellID->29242],
Cell[41210, 1473, 323, 10, 70, "MathCaption",
 CellID->8559],
Cell[CellGroupData[{
Cell[41558, 1487, 289, 8, 70, "Input",
 CellID->12228],
Cell[41850, 1497, 239, 7, 36, "Output",
 CellID->224576698]
}, Open  ]],
Cell[42104, 1507, 362, 13, 70, "MathCaption",
 CellID->17309],
Cell[CellGroupData[{
Cell[42491, 1524, 289, 8, 70, "Input",
 CellID->1336],
Cell[42783, 1534, 347, 12, 51, "Output",
 CellID->146347549]
}, Open  ]],
Cell[43145, 1549, 221, 8, 70, "MathCaption",
 CellID->25217],
Cell[CellGroupData[{
Cell[43391, 1561, 225, 8, 70, "Input",
 CellID->8943],
Cell[43619, 1571, 258, 8, 36, "Output",
 CellID->197242236]
}, Open  ]],
Cell[43892, 1582, 83, 1, 70, "MathCaption",
 CellID->2186],
Cell[CellGroupData[{
Cell[44000, 1587, 285, 8, 70, "Input",
 CellID->18794],
Cell[44288, 1597, 258, 8, 36, "Output",
 CellID->986166746]
}, Open  ]],
Cell[44561, 1608, 716, 22, 70, "Text",
 CellID->26047],
Cell[45280, 1632, 873, 25, 70, "Text",
 CellID->16591],
Cell[46156, 1659, 597, 19, 70, "DefinitionBox",
 CellID->20548],
Cell[46756, 1680, 187, 8, 70, "Caption",
 CellID->17128],
Cell[46946, 1690, 92, 1, 70, "MathCaption",
 CellID->16161],
Cell[CellGroupData[{
Cell[47063, 1695, 171, 5, 70, "Input",
 CellID->26746],
Cell[47237, 1702, 162, 5, 36, "Output",
 CellID->113946998]
}, Open  ]],
Cell[47414, 1710, 628, 21, 70, "MathCaption",
 CellID->23893],
Cell[CellGroupData[{
Cell[48067, 1735, 166, 5, 70, "Input",
 CellID->18080],
Cell[48236, 1742, 161, 5, 36, "Output",
 CellID->7668252]
}, Open  ]],
Cell[48412, 1750, 287, 9, 70, "MathCaption",
 CellID->7251],
Cell[CellGroupData[{
Cell[48724, 1763, 248, 7, 70, "Input",
 CellID->14148],
Cell[48975, 1772, 162, 5, 36, "Output",
 CellID->994765762]
}, Open  ]]
}, Open  ]],
Cell[49164, 1781, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

