(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16245,        525]
NotebookOptionsPosition[     12623,        422]
NotebookOutlinePosition[     14211,        458]
CellTagsIndexPosition[     14168,        455]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Regression Common Functions Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["RegressionReportValues",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/RegressionReportValues"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " obtain a list of possible report values"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Ellipsoid",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/Ellipsoid"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " primitive for ellipsoidal values"
}], "GuideText",
 CellID->178428758],

Cell["\t", "GuideDelimiterSubsection",
 CellID->311258892],

Cell[CellGroupData[{

Cell["Options", "GuideFunctionsSubsection",
 CellID->557424193],

Cell[TextData[{
 Cell[TextData[ButtonBox["RegressionReport",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " values to include in output"
}], "GuideText",
 CellID->1304743537],

Cell[TextData[{
 Cell[TextData[ButtonBox["Weights",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/Weights"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " weight values for data"
}], "GuideText",
 CellID->869106842],

Cell["\t", "GuideDelimiterSubsection",
 CellID->598479832]
}, Open  ]],

Cell[CellGroupData[{

Cell["Linear and Nonlinear Report Values", "GuideFunctionsSubsection",
 CellID->30667144],

Cell[TextData[{
 Cell[TextData[ButtonBox["BestFitParameters",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/BestFitParameters"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " parameter estimates"
}], "GuideText",
 CellID->310298155],

Cell[TextData[{
 Cell[TextData[ButtonBox["FitResiduals",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/FitResiduals"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " residual error in fitted values"
}], "GuideText",
 CellID->149768139],

Cell[TextData[{
 Cell[TextData[ButtonBox["ANOVATable",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/ANOVATable"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BestFit",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/BestFit"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EstimatedVariance",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/EstimatedVariance"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HatDiagonal",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/HatDiagonal"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MeanPredictionCITable",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/MeanPredictionCITable"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ParameterCITable",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/ParameterCITable"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ParameterConfidenceRegion",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/ParameterConfidenceRegion"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ParameterTable",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/ParameterTable"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PredictedResponse",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/PredictedResponse"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SinglePredictionCITable",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/SinglePredictionCITable"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StandardizedResiduals",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/StandardizedResiduals"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SummaryReport",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/SummaryReport"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->300474130]
}, Open  ]],

Cell[CellGroupData[{

Cell["Linear Report Values", "GuideFunctionsSubsection",
 CellID->831656221],

Cell[TextData[{
 Cell[TextData[ButtonBox["CovarianceMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/CovarianceMatrix"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " covariances between fitted parameters"
}], "GuideText",
 CellID->64938684],

Cell[TextData[{
 Cell[TextData[ButtonBox["RSquared",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/RSquared"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " squared multiple correlation coefficient"
}], "GuideText",
 CellID->33447121],

Cell[TextData[{
 Cell[TextData[ButtonBox["AdjustedRSquared",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/AdjustedRSquared"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BestFitParametersDelta",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/BestFitParametersDelta"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CatcherMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/CatcherMatrix"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CoefficientOfVariation",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/CoefficientOfVariation"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CookD",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/CookD"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CorrelationMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/CorrelationMatrix"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CovarianceMatrixDetRatio",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/CovarianceMatrixDetRatio"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DurbinWatsonD",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/DurbinWatsonD"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EigenstructureTable",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/EigenstructureTable"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["JackknifedVariance",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/JackknifedVariance"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PartialSumOfSquares",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/PartialSumOfSquares"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PredictedResponseDelta",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/PredictedResponseDelta"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SequentialSumOfSquares",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/SequentialSumOfSquares"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StudentizedResiduals",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/StudentizedResiduals"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["VarianceInflation",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/VarianceInflation"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->515393489]
}, Open  ]],

Cell[CellGroupData[{

Cell["Nonlinear Report Values", "GuideFunctionsSubsection",
 CellID->983691906],

Cell[TextData[{
 Cell[TextData[ButtonBox["AsymptoticCovarianceMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/AsymptoticCovarianceMatrix"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " approximate covariances between fitted parameters"
}], "GuideText",
 CellID->171101874],

Cell[TextData[{
 Cell[TextData[ButtonBox["FitCurvatureTable",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/FitCurvatureTable"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " curvature diagnostics"
}], "GuideText",
 CellID->268586406],

Cell[TextData[{
 Cell[TextData[ButtonBox["AsymptoticCorrelationMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/AsymptoticCorrelationMatrix"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ParameterBias",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/ParameterBias"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StartingParameters",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/StartingParameters"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->570798942]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Regression Common Functions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/tutorial/RegressionCommon"]], "GuideTutorial",
 CellID->823733758]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Linear Regression Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:LinearRegression/guide/LinearRegressionPackage"]], "GuideMoreAbout",\

 CellID->1567025153],

Cell[TextData[ButtonBox["Nonlinear Regression Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NonlinearRegression/guide/NonlinearRegressionPackage"]], \
"GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Curve Fitting and Approximate Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CurveFittingAndApproximateFunctions"]], "GuideMoreAbout",
 CellID->1029892024]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Regression Common Functions Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 58.5036756}", "context" -> 
    "RegressionCommon`", "keywords" -> {}, "index" -> True, "label" -> 
    "Regression Common Package Guide", "language" -> "en", "paclet" -> 
    "RegressionCommon Package", "status" -> "None", "summary" -> 
    "RegressionReportValues -- obtain a list of possible report values, \
Ellipsoid -- primitive for ellipsoidal values, RegressionReport -- values to \
include in output, Weights -- weight values for data, BestFitParameters -- \
parameter estimates, FitResiduals -- residual error in fitted values, \
CovarianceMatrix -- covariances between fitted parameters, RSquared -- \
squared multiple correlation coefficient, AsymptoticCovarianceMatrix -- \
approximate covariances between fitted parameters, FitCurvatureTable -- \
curvature diagnostics", "synonyms" -> {}, "title" -> 
    "Regression Common Functions Package", "type" -> "Guide", "uri" -> 
    "RegressionCommon/guide/RegressionCommonPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 77, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[699, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[758, 31, 311, 9, 70, "GuideText",
 CellID->203374175],
Cell[1072, 42, 278, 9, 70, "GuideText",
 CellID->178428758],
Cell[1353, 53, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->311258892],
Cell[CellGroupData[{
Cell[1436, 58, 63, 1, 70, "GuideFunctionsSubsection",
 CellID->557424193],
Cell[1502, 61, 288, 9, 70, "GuideText",
 CellID->1304743537],
Cell[1793, 72, 261, 8, 70, "GuideText",
 CellID->869106842],
Cell[2057, 82, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->598479832]
}, Open  ]],
Cell[CellGroupData[{
Cell[2152, 88, 89, 1, 70, "GuideFunctionsSubsection",
 CellID->30667144],
Cell[2244, 91, 281, 9, 70, "GuideText",
 CellID->310298155],
Cell[2528, 102, 283, 9, 70, "GuideText",
 CellID->149768139],
Cell[2814, 113, 2911, 82, 70, "InlineGuideFunctionListing",
 CellID->300474130]
}, Open  ]],
Cell[CellGroupData[{
Cell[5762, 200, 76, 1, 70, "GuideFunctionsSubsection",
 CellID->831656221],
Cell[5841, 203, 296, 9, 70, "GuideText",
 CellID->64938684],
Cell[6140, 214, 283, 9, 70, "GuideText",
 CellID->33447121],
Cell[6426, 225, 3695, 103, 70, "InlineGuideFunctionListing",
 CellID->515393489]
}, Open  ]],
Cell[CellGroupData[{
Cell[10158, 333, 79, 1, 70, "GuideFunctionsSubsection",
 CellID->983691906],
Cell[10240, 336, 329, 9, 70, "GuideText",
 CellID->171101874],
Cell[10572, 347, 283, 9, 70, "GuideText",
 CellID->268586406],
Cell[10858, 358, 732, 20, 70, "InlineGuideFunctionListing",
 CellID->570798942]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11639, 384, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[11704, 387, 190, 4, 70, "GuideTutorial",
 CellID->823733758]
}, Open  ]],
Cell[CellGroupData[{
Cell[11931, 396, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[11996, 399, 188, 5, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[12187, 406, 196, 5, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[12386, 413, 195, 4, 70, "GuideMoreAbout",
 CellID->1029892024]
}, Open  ]],
Cell[12596, 420, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

