(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10656,        372]
NotebookOptionsPosition[      7980,        285]
NotebookOutlinePosition[      9301,        322]
CellTagsIndexPosition[      9217,        317]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["REGRESSION COMMON PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regression Common Functions Package" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/tutorial/RegressionCommon"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Regression Common Functions Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"HatDiagonal" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/HatDiagonal"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"HatDiagonal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CatcherMatrix", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["CatcherMatrix"], "InlineFormula"],
     "\[LineSeparator]is a possible value for the ",
     Cell[BoxData[
      ButtonBox["RegressionReport",
       BaseStyle->"Link",
       ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
      "InlineFormula"],
     " option for ",
     Cell[BoxData[
      ButtonBox["Regress",
       BaseStyle->"Link",
       ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["DesignedRegress",
       BaseStyle->"Link",
       ButtonData->"paclet:LinearRegression/ref/DesignedRegress"]], 
      "InlineFormula"],
     " which represents the catcher matrix."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["CatcherMatrix"], "InlineFormula"],
 " is the matrix C such that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BestFitParmeters",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/BestFitParameters"], "=", 
   RowBox[{"C", ".", 
    StyleBox["y", "TI"]}]}]], "InlineFormula"],
 " where y is the vector of response values from the data."
}], "Notes",
 CellID->667165077],

Cell[TextData[{
 "In the regression report, ",
 Cell[BoxData["CatcherMatrix"], "InlineFormula"],
 " has the ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 " wrapper."
}], "Notes",
 CellID->19912]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->67766871],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->233187932],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->455158924],

Cell["Sample data:", "ExampleText",
 CellID->3902],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.05", ",", " ", "90"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.09", ",", " ", "95"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.14", ",", " ", "110"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.17", ",", " ", "125"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26500],

Cell[TextData[{
 Cell[BoxData["CatcherMatrix"], "InlineFormula"],
 " for a linear regression:"
}], "ExampleText",
 CellID->153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Regress", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"x", "^", "2"}]}], "}"}], ",", "x", ",", 
   RowBox[{"RegressionReport", "\[Rule]", 
    RowBox[{"{", "CatcherMatrix", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->26645265],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"CatcherMatrix", "\[Rule]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.6838545311014227`", "0.48592496905107924`", "0.07946247555483801`",
         
        RowBox[{"-", "0.2492419757073398`"}]},
       {
        RowBox[{"-", "29.364096859656353`"}], 
        RowBox[{"-", "15.967849005149185`"}], "11.542302838928057`", 
        "33.78964302587748`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[0.7]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 ImageSize->{410, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->305334986]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["HatDiagonal",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/HatDiagonal"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Regression Common Functions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/tutorial/RegressionCommon"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CatcherMatrix - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 6, 59.8787108}", "context" -> 
    "RegressionCommon`", "keywords" -> {}, "index" -> True, "label" -> 
    "Regression Common Package Symbol", "language" -> "en", "paclet" -> 
    "RegressionCommon Package", "status" -> "None", "summary" -> 
    "CatcherMatrix is a possible value for the RegressionReport option for \
Regress and DesignedRegress which represents the catcher matrix.", 
    "synonyms" -> {}, "title" -> "CatcherMatrix", "type" -> "Symbol", "uri" -> 
    "RegressionCommon/ref/CatcherMatrix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4103, 142, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->67766871]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9075, 310}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1264, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1887, 61, 56, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[1946, 64, 913, 27, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2896, 96, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3374, 113, 414, 12, 70, "Notes",
 CellID->667165077],
Cell[3791, 127, 275, 10, 70, "Notes",
 CellID->19912]
}, Closed]],
Cell[CellGroupData[{
Cell[4103, 142, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->67766871],
Cell[CellGroupData[{
Cell[4487, 156, 148, 5, 70, "ExampleSection",
 CellID->233187932],
Cell[4638, 163, 141, 4, 70, "Input",
 CellID->455158924],
Cell[4782, 169, 50, 1, 70, "ExampleText",
 CellID->3902],
Cell[4835, 172, 459, 14, 70, "Input",
 CellID->26500],
Cell[5297, 188, 127, 4, 70, "ExampleText",
 CellID->153],
Cell[CellGroupData[{
Cell[5449, 196, 305, 9, 70, "Input",
 CellID->26645265],
Cell[5757, 207, 1034, 29, 49, "Output",
 CellID->305334986]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6852, 243, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7171, 254, 223, 6, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[7431, 265, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[7752, 276, 186, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[7953, 283, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

