(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12531,        426]
NotebookOptionsPosition[      9818,        337]
NotebookOutlinePosition[     11116,        374]
CellTagsIndexPosition[     11031,        369]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["REGRESSION COMMON PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regression Common Functions Package" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/tutorial/RegressionCommon"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Regression Common Functions Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PredictedResponseDelta" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/PredictedResponseDelta"], 
          "BestFitParametersDelta" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/BestFitParametersDelta"], 
          "HatDiagonal" :> 
          Documentation`HelpLookup["paclet:RegressionCommon/ref/HatDiagonal"],
           "CovarianceMatrixDetRatio" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/CovarianceMatrixDetRatio"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PredictedResponseDelta\"\>", 
       2->"\<\"BestFitParametersDelta\"\>", 3->"\<\"HatDiagonal\"\>", 
       4->"\<\"CovarianceMatrixDetRatio\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CookD", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["CookD"], "InlineFormula"],
     "\[LineSeparator]is a possible value for the ",
     Cell[BoxData[
      ButtonBox["RegressionReport",
       BaseStyle->"Link",
       ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
      "InlineFormula"],
     " option for ",
     Cell[BoxData[
      ButtonBox["Regress",
       BaseStyle->"Link",
       ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["DesignedRegress",
       BaseStyle->"Link",
       ButtonData->"paclet:LinearRegression/ref/DesignedRegress"]], 
      "InlineFormula"],
     " which represents a list of Cook's distances."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["CookD"], "InlineFormula"],
 " is a diagnostic for identifying highly influential points. "
}], "Notes",
 CellID->23281],

Cell[TextData[{
 Cell[BoxData["CookD"], "InlineFormula"],
 " gives a list Cook's distances for the data points. "
}], "Notes",
 CellID->158486308],

Cell[TextData[{
 Cell[BoxData["CookD"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["HatDiagonal",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/HatDiagonal"], "/", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      ButtonBox["HatDiagonal",
       BaseStyle->"Link",
       ButtonData->"paclet:RegressionCommon/ref/HatDiagonal"]}], ")"}]}], " ",
    
   RowBox[{
    SuperscriptBox[
     ButtonBox["StandardizedResiduals",
      BaseStyle->"Link",
      ButtonData->"paclet:RegressionCommon/ref/StandardizedResiduals"], "2"], 
    "/", 
    StyleBox["p", "TI"]}]}]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " is the number of parameters in the model."
}], "Notes",
 CellID->222139075]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->299457484],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->188411374],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->455158924],

Cell["Sample data:", "ExampleText",
 CellID->3902],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.05", ",", " ", "90"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.09", ",", " ", "95"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.14", ",", " ", "110"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.17", ",", " ", "125"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", " ", "140"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.21", ",", " ", "150"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.23", ",", " ", "175"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "190"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.3", ",", " ", "210"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.35", ",", " ", "255"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26500],

Cell[TextData[{
 Cell[BoxData["CookD"], "InlineFormula"],
 " for a linear regression:"
}], "ExampleText",
 CellID->153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Regress", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"x", "^", "2"}]}], "}"}], ",", "x", ",", 
   RowBox[{"RegressionReport", "\[Rule]", 
    RowBox[{"{", "CookD", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->26645265],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"CookD", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{
    "0.0014067562461820488`", ",", "0.038220914663439215`", ",", 
     "0.045071105841311125`", ",", "0.013273780430102732`", ",", 
     "0.016155042419385122`", ",", "0.00007892057991379122`", ",", 
     "0.17084841007966578`", ",", "0.25137864187841974`", ",", 
     "0.08824203608113076`", ",", "0.8762444913718415`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{459, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->352328185]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PredictedResponseDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/PredictedResponseDelta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BestFitParametersDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/BestFitParametersDelta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HatDiagonal",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/HatDiagonal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CovarianceMatrixDetRatio",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/CovarianceMatrixDetRatio"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Regression Common Functions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/tutorial/RegressionCommon"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CookD - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 6.7382614}", "context" -> 
    "RegressionCommon`", "keywords" -> {}, "index" -> True, "label" -> 
    "Regression Common Package Symbol", "language" -> "en", "paclet" -> 
    "RegressionCommon Package", "status" -> "None", "summary" -> 
    "CookD is a possible value for the RegressionReport option for Regress \
and DesignedRegress which represents a list of Cook's distances.", 
    "synonyms" -> {}, "title" -> "CookD", "type" -> "Symbol", "uri" -> 
    "RegressionCommon/ref/CookD"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5055, 167, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->299457484]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10888, 362}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1811, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2434, 71, 48, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2485, 74, 913, 27, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3435, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3913, 123, 150, 4, 70, "Notes",
 CellID->23281],
Cell[4066, 129, 146, 4, 70, "Notes",
 CellID->158486308],
Cell[4215, 135, 803, 27, 70, "Notes",
 CellID->222139075]
}, Closed]],
Cell[CellGroupData[{
Cell[5055, 167, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->299457484],
Cell[CellGroupData[{
Cell[5440, 181, 148, 5, 70, "ExampleSection",
 CellID->188411374],
Cell[5591, 188, 141, 4, 70, "Input",
 CellID->455158924],
Cell[5735, 194, 50, 1, 70, "ExampleText",
 CellID->3902],
Cell[5788, 197, 937, 26, 70, "Input",
 CellID->26500],
Cell[6728, 225, 119, 4, 70, "ExampleText",
 CellID->153],
Cell[CellGroupData[{
Cell[6872, 233, 297, 9, 70, "Input",
 CellID->26645265],
Cell[7172, 244, 573, 15, 54, "Output",
 CellID->352328185]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7806, 266, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[8125, 277, 1107, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[9269, 317, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[9590, 328, 186, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[9791, 335, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

