(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12262,        394]
NotebookOptionsPosition[      9477,        305]
NotebookOutlinePosition[     10887,        343]
CellTagsIndexPosition[     10802,        338]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["REGRESSION COMMON PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regression Common Functions Package" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/tutorial/RegressionCommon"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Regression Common Functions Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CorrelationMatrix" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/CorrelationMatrix"], "Eigenvalues" :> 
          Documentation`HelpLookup["paclet:ref/Eigenvalues"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CorrelationMatrix\"\>", 
       2->"\<\"Eigenvalues\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EigenstructureTable", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["EigenstructureTable"], "InlineFormula"],
     "\[LineSeparator]is a possible value for the ",
     Cell[BoxData[
      ButtonBox["RegressionReport",
       BaseStyle->"Link",
       ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
      "InlineFormula"],
     " option for ",
     Cell[BoxData[
      ButtonBox["Regress",
       BaseStyle->"Link",
       ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["DesignedRegress",
       BaseStyle->"Link",
       ButtonData->"paclet:LinearRegression/ref/DesignedRegress"]], 
      "InlineFormula"],
     " which represents tabular information about the eigenstructure of the \
parameter correlation matrix."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["EigenstructureTable"], "InlineFormula"],
 " includes eigenvalues and ",
 "associated condition indices",
 " listed from largest to smallest"
}], "Notes",
 CellID->35472667],

Cell["\<\
The table also includes the proportion of the variance attributable to each \
eigenvalue for each nonconstant basis functions.\
\>", "Notes",
 CellID->44319867]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->272987080],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->56865083],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->455158924],

Cell["Sample data:", "ExampleText",
 CellID->3902],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.05", ",", " ", "90"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.09", ",", " ", "95"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.14", ",", " ", "110"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.17", ",", " ", "125"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", " ", "140"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.21", ",", " ", "150"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.23", ",", " ", "175"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "190"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.3", ",", " ", "210"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.35", ",", " ", "255"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26500],

Cell[TextData[{
 Cell[BoxData["EigenstructureTable"], "InlineFormula"],
 " for a linear regression:"
}], "ExampleText",
 CellID->153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Regress", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"x", "^", "2"}], ",", 
     SuperscriptBox["x", "3"]}], "}"}], ",", "x", ",", 
   RowBox[{"RegressionReport", "\[Rule]", 
    RowBox[{"{", "EigenstructureTable", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->117885620],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWs1u1DAQzibZ7c9uxY/ozwKClgMXDgWp1RauIDhx5AFWFVJ7QKDSJ+At
kFDbJ6jgCg8X4sTeOF8+x/Ym2W5XahyP7fF4/jwz6cfp+cnnL9Pz0+Pp7oez
6beT0+Pvu++/nqWgqBcEvb9BELzYCdL3JH3L/sTvX/qXv+LbVfqM0mlx2oZp
25f9KG37so0kPIgUvmQGj6EdynWhtj6U4zoc2yHQgXhxvYmucUt4tjPuXIpn
fwbNYOUzVUdjwBQ2mOUDHQFG3MGPajf61mv5s8Jw0tmVnbz5t7M0lNRpzpoT
hgH0IzO1cTGrSj/iXfccR5tgGqX3h5TODSfeo4Q4r6mVLnTHreS2SndoGbf1
ua0LaCypi+f2I25y7Wav5hJVdwhKNkyKu1TRG5n0U+ujJ7dJHk/EqeZQNx5R
zzinFBdPRzsS1vuZ76haZwmC/sUmdRzH28fmR1Ybc5vpr53buGprSejYTNqW
OvfUnBqbzdq0wY3CJlGaj0Taj2F5vHazNOWR21VSZDKYGcUBzxx0Lz/U5ot2
RPDomdaI7Icty8zGc67LTynOnGeAap6AXGtrqjosHr8Zf5ds5j15YtH55bTi
AfR/JNXsVZf1QLY5ovwXabqxA+tfGmSi42URBdMxXfeYbrWBF9dpXCvuuPQ3
AHvQozOpRPKnEOoc0ynGekFpHqE2nBm7Qo80KD6sw/nEOMbKa4RPs7zRzbfX
xup4gz007Ldv3M+cuTfxg33z+SzRDZ6QRx+3gXIaXVSg/O73uG1QX3ziCCvG
ypnq8a0AVMMaEg5hn8ZnTaRbExetsvFaeQ4If9Cfof0dUFq9MxXvKJBrAnqj
5pF9l9Qhll5SiCVXLeS+h/5YqRmYoW6Re42W1FRmbsg6BO41IgNVGWmyF/YX
aiOlqCImEmScWJiNNKZO8LaXdoVt5PZR58GZBpsl2zeeSI+C6iTdtXX0CQ0q
EnO3AzEJa5h4O3B5l/hQujts9aWObABOpmJazofQ4M9CxY8logfhua6ziCsi
syuRWK1Hm41WowF6H/jGoW7Vnza+BZZOY4tMeXWnJpfx0QadXqMX6tQ+sh09
I3jfLxktVUo7ppLnJXXZi5KgypVNeXRIxsQ6vbo1m1PKscOgnCXoK3Cn0LCT
7T8KdE7mK0wztwHeRNPd7qH29X0ZoF3VhxcLpfbj+MXoOcwaQz/TtJJ12yI+
7D9OqtVgdQcqa1Jw0X8k20nCq7xYsWPVX701VZl98fhUBlEin9KHKD2sJEV1
TVWeD5ykJx5uNeCfUk6bRFbdVaLNtfTrpKhJZ/YW/CFYs3pjcJHMU1lFKp/K
1Xy27ucznMR7bydlLz6SayYA35BnO8pQXCbO1jlnzo+49txxu+1YsvRxBbJB
MR05zpsUXJqvamDlD+aSz1rkj4orlH+6A+NvJPw+wA8rpxbY28py2zyt/hVC
nfIu4HxtPWWL+Y2hWsvOyXOi0gjnhEXjeW0EzzdxXKd0SPMXLUSwPD/bK9NE
1sUAU7zU9zF5RP02FCiwHnE4x3yTB31iPp+GAevn+9DnXHrrNCv3XOp2Qi+8
JXmmZQySaoFoJDnwClYpab8zwHMdEaD8a3XQ+w807zrc\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{442, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->149151047]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CorrelationMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/CorrelationMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eigenvalues",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigenvalues"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16934]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Regression Common Functions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/tutorial/RegressionCommon"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EigenstructureTable - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 7.6132838}", "context" -> 
    "RegressionCommon`", "keywords" -> {}, "index" -> True, "label" -> 
    "Regression Common Package Symbol", "language" -> "en", "paclet" -> 
    "RegressionCommon Package", "status" -> "None", "summary" -> 
    "EigenstructureTable is a possible value for the RegressionReport option \
for Regress and DesignedRegress which represents tabular information about \
the eigenstructure of the parameter correlation matrix.", "synonyms" -> {}, 
    "title" -> "EigenstructureTable", "type" -> "Symbol", "uri" -> 
    "RegressionCommon/ref/EigenstructureTable"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3995, 133, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->272987080]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10659, 331}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1396, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2019, 63, 62, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2084, 66, 983, 28, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3104, 99, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3582, 116, 203, 6, 70, "Notes",
 CellID->35472667],
Cell[3788, 124, 170, 4, 70, "Notes",
 CellID->44319867]
}, Closed]],
Cell[CellGroupData[{
Cell[3995, 133, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->272987080],
Cell[CellGroupData[{
Cell[4380, 147, 147, 5, 70, "ExampleSection",
 CellID->56865083],
Cell[4530, 154, 141, 4, 70, "Input",
 CellID->455158924],
Cell[4674, 160, 50, 1, 70, "ExampleText",
 CellID->3902],
Cell[4727, 163, 937, 26, 70, "Input",
 CellID->26500],
Cell[5667, 191, 133, 4, 70, "ExampleText",
 CellID->153],
Cell[CellGroupData[{
Cell[5825, 199, 349, 10, 30, "Input",
 CellID->117885620],
Cell[6177, 211, 1842, 34, 64, "Output",
 Evaluatable->False,
 CellID->149151047]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8080, 252, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[8399, 263, 492, 17, 70, "SeeAlso",
 CellID->16934]
}, Open  ]],
Cell[CellGroupData[{
Cell[8928, 285, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[9249, 296, 186, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[9450, 303, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

