(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6859,        232]
NotebookOptionsPosition[      4952,        173]
NotebookOutlinePosition[      6102,        203]
CellTagsIndexPosition[      6059,        200]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["REGRESSION COMMON PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regression Common Functions Package" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/tutorial/RegressionCommon"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Regression Common Functions Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ParameterBias" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/ParameterBias"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ParameterBias\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FitCurvatureTable", "ObjectName",
 CellID->20676],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["FitCurvatureTable"], "InlineFormula"],
     " \[LineSeparator]is a possible value for the ",
     Cell[BoxData[
      ButtonBox["RegressionReport",
       BaseStyle->"Link",
       ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
      "InlineFormula"],
     " option for ",
     Cell[BoxData[
      ButtonBox["NonlinearRegress",
       BaseStyle->"Link",
       ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"]], 
      "InlineFormula"],
     " which represents a table of curvature diagnostics."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14183]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["FitCurvatureTable"], "InlineFormula"],
 " includes the maximum relative intrinsic curvature, the maximum relative \
parameter-effects curvature, and the relative curvature of the least-squares \
solution confidence region."
}], "Notes",
 CellID->6868],

Cell["\<\
Diagnostics in the fit curvature table give information about the validity of \
other diagnostics.\
\>", "Notes",
 CellID->321940929],

Cell["\<\
If curvatures are high, diagnostics based on linear approximations may give \
poor results.\
\>", "Notes",
 CellID->100902724]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2050],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ParameterBias",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/ParameterBias"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->16934]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17852],

Cell[TextData[ButtonBox["Regression Common Functions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/tutorial/RegressionCommon"]], "Tutorials",
 CellID->3781]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FitCurvatureTable - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 14.5197106}", "context" -> 
    "RegressionCommon`", "keywords" -> {}, "index" -> True, "label" -> 
    "Regression Common Package Symbol", "language" -> "en", "paclet" -> 
    "RegressionCommon Package", "status" -> "None", "summary" -> 
    "FitCurvatureTable is a possible value for the RegressionReport option \
for NonlinearRegress which represents a table of curvature diagnostics.", 
    "synonyms" -> {}, "title" -> "FitCurvatureTable", "type" -> "Symbol", 
    "uri" -> "RegressionCommon/ref/FitCurvatureTable"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1270, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1893, 61, 55, 1, 70, "ObjectName",
 CellID->20676],
Cell[1951, 64, 769, 22, 70, "Usage",
 CellID->14183]
}, Open  ]],
Cell[CellGroupData[{
Cell[2757, 91, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3235, 108, 282, 6, 70, "Notes",
 CellID->6868],
Cell[3520, 116, 143, 4, 70, "Notes",
 CellID->321940929],
Cell[3666, 122, 136, 4, 70, "Notes",
 CellID->100902724]
}, Closed]],
Cell[CellGroupData[{
Cell[3839, 131, 310, 9, 70, "SeeAlsoSection",
 CellID->2050],
Cell[4152, 142, 223, 6, 70, "SeeAlso",
 CellID->16934]
}, Open  ]],
Cell[CellGroupData[{
Cell[4412, 153, 314, 9, 70, "TutorialsSection",
 CellID->17852],
Cell[4729, 164, 181, 4, 70, "Tutorials",
 CellID->3781]
}, Open  ]],
Cell[4925, 171, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

