(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11841,        409]
NotebookOptionsPosition[      9137,        320]
NotebookOutlinePosition[     10431,        357]
CellTagsIndexPosition[     10346,        352]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["REGRESSION COMMON PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regression Common Functions Package" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/tutorial/RegressionCommon"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Regression Common Functions Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StandardizedResiduals" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/StandardizedResiduals"], 
          "PredictedResponseDelta" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/PredictedResponseDelta"], "CookD" :> 
          Documentation`HelpLookup["paclet:RegressionCommon/ref/CookD"], 
          "CatcherMatrix" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/CatcherMatrix"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"StandardizedResiduals\"\>", 
       2->"\<\"PredictedResponseDelta\"\>", 3->"\<\"CookD\"\>", 
       4->"\<\"CatcherMatrix\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HatDiagonal", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["HatDiagonal"], "InlineFormula"],
     "\[LineSeparator]is a possible value for the ",
     Cell[BoxData[
      ButtonBox["RegressionReport",
       BaseStyle->"Link",
       ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
      "InlineFormula"],
     " option which represents the diagonal of the hat matrix."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["HatDiagonal"], "InlineFormula"],
 " is used in diagnostics for influence of data points."
}], "Notes",
 CellID->9332293],

Cell[TextData[{
 "The hat matrix ",
 Cell[BoxData["H"], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  RowBox[{"H", "=", 
   RowBox[{
    RowBox[{"X", ".", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"X", "\[Transpose]"}], ".", "X"}], ")"}], 
      RowBox[{"-", "1"}]]}], 
    RowBox[{"X", "\[Transpose]"}]}]}]], "InlineFormula"],
 " where X is the design matrix."
}], "Notes",
 CellID->6334],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is the response vector, then ",
 Cell[BoxData[
  RowBox[{"H", ".", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " yields the predicted response vector."
}], "Notes",
 CellID->787529831]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->60969419],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->179730392],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->455158924],

Cell["Sample data:", "ExampleText",
 CellID->3902],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.05", ",", " ", "90"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.09", ",", " ", "95"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.14", ",", " ", "110"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.17", ",", " ", "125"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", " ", "140"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.21", ",", " ", "150"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.23", ",", " ", "175"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "190"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.3", ",", " ", "210"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.35", ",", " ", "255"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26500],

Cell[TextData[{
 Cell[BoxData["HatDiagonal"], "InlineFormula"],
 " for a linear regression:"
}], "ExampleText",
 CellID->153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Regress", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"x", "^", "2"}]}], "}"}], ",", "x", ",", 
   RowBox[{"RegressionReport", "\[Rule]", 
    RowBox[{"{", "HatDiagonal", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->26645265],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HatDiagonal", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{
    "0.2597995299126048`", ",", "0.22219767744289542`", ",", 
     "0.16077041913516343`", ",", "0.1266275336696423`", ",", 
     "0.10405929162160879`", ",", "0.10072751850112925`", ",", 
     "0.10269195737174074`", ",", "0.11901902680779725`", ",", 
     "0.2477145049769023`", ",", "0.5563925405605151`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{431, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->57099743]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StandardizedResiduals",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/StandardizedResiduals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PredictedResponseDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/PredictedResponseDelta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CookD",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/CookD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CatcherMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/CatcherMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Regression Common Functions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/tutorial/RegressionCommon"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HatDiagonal - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 14.8634694}", "context" -> 
    "RegressionCommon`", "keywords" -> {}, "index" -> True, "label" -> 
    "Regression Common Package Symbol", "language" -> "en", "paclet" -> 
    "RegressionCommon Package", "status" -> "None", "summary" -> 
    "HatDiagonal is a possible value for the RegressionReport option which \
represents the diagonal of the hat matrix.", "synonyms" -> {}, "title" -> 
    "HatDiagonal", "type" -> "Symbol", "uri" -> 
    "RegressionCommon/ref/HatDiagonal"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4406, 150, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->60969419]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10204, 345}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1746, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2369, 70, 54, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2426, 73, 572, 16, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3035, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3513, 111, 151, 4, 70, "Notes",
 CellID->9332293],
Cell[3667, 117, 428, 16, 70, "Notes",
 CellID->6334],
Cell[4098, 135, 271, 10, 70, "Notes",
 CellID->787529831]
}, Closed]],
Cell[CellGroupData[{
Cell[4406, 150, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->60969419],
Cell[CellGroupData[{
Cell[4790, 164, 148, 5, 70, "ExampleSection",
 CellID->179730392],
Cell[4941, 171, 141, 4, 70, "Input",
 CellID->455158924],
Cell[5085, 177, 50, 1, 70, "ExampleText",
 CellID->3902],
Cell[5138, 180, 937, 26, 70, "Input",
 CellID->26500],
Cell[6078, 208, 125, 4, 70, "ExampleText",
 CellID->153],
Cell[CellGroupData[{
Cell[6228, 216, 303, 9, 70, "Input",
 CellID->26645265],
Cell[6534, 227, 566, 15, 54, "Output",
 CellID->57099743]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7161, 249, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7480, 260, 1071, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[8588, 300, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[8909, 311, 186, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[9110, 318, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

