(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13413,        435]
NotebookOptionsPosition[     10632,        345]
NotebookOutlinePosition[     12002,        383]
CellTagsIndexPosition[     11917,        378]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["REGRESSION COMMON PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regression Common Functions Package" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/tutorial/RegressionCommon"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Regression Common Functions Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PredictedResponse" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/PredictedResponse"], 
          "SinglePredictionCITable" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/SinglePredictionCITable"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PredictedResponse\"\>", 
       2->"\<\"SinglePredictionCITable\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MeanPredictionCITable", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["MeanPredictionCITable"], "InlineFormula"],
     "\[LineSeparator]is a possible value for the ",
     Cell[BoxData[
      ButtonBox["RegressionReport",
       BaseStyle->"Link",
       ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
      "InlineFormula"],
     " option which represents a table of confidence intervals for the mean \
predicted responses."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["MeanPredictionCITable"], "InlineFormula"],
 " includes the observed response value, the fitted response value, standard \
error and confidence interval for each data point."
}], "Notes",
 CellID->82101380],

Cell[TextData[{
 "The confidence level for the intervals can be specified via the ",
 Cell[BoxData[
  ButtonBox["ConfidenceLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/ConfidenceLevel"]], 
  "InlineFormula"],
 " option."
}], "Notes",
 CellID->22704],

Cell[TextData[{
 "In the regression report, ",
 Cell[BoxData["MeanPredictionCITable"], "InlineFormula"],
 " has the ",
 Cell[BoxData[
  ButtonBox["TableForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
 " wrapper."
}], "Notes",
 CellID->19912]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->15594284],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->443937996],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->455158924],

Cell["Sample data:", "ExampleText",
 CellID->3902],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.05", ",", " ", "90"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.09", ",", " ", "95"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.14", ",", " ", "110"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.17", ",", " ", "125"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", " ", "140"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.21", ",", " ", "150"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.23", ",", " ", "175"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "190"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.3", ",", " ", "210"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.35", ",", " ", "255"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26500],

Cell[TextData[{
 Cell[BoxData["MeanPredictionCITable"], "InlineFormula"],
 " for a linear regression:"
}], "ExampleText",
 CellID->153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Regress", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"x", "^", "2"}]}], "}"}], ",", "x", ",", 
   RowBox[{"RegressionReport", "\[Rule]", 
    RowBox[{"{", "MeanPredictionCITable", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->26645265],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"MeanPredictionCITable", "\[Rule]", 
   TagBox[
    TagBox[GridBox[{
       {
        TagBox["\<\"Observed\"\>",
         HoldForm], 
        TagBox["\<\"Predicted\"\>",
         HoldForm], 
        TagBox["\<\"SE\"\>",
         HoldForm], 
        TagBox["\<\"CI\"\>",
         HoldForm]},
       {"90.`", "90.6010320530996`", "3.9770606501337618`", 
        RowBox[{"{", 
         RowBox[{"81.42991374793337`", ",", "99.77215035826583`"}], "}"}]},
       {"95.`", "98.55965613968651`", "3.6780090296534196`", 
        RowBox[{"{", 
         RowBox[{"90.07815210798745`", ",", "107.04116017138557`"}], "}"}]},
       {"110.`", "114.90325917464178`", "3.1285716499709837`", 
        RowBox[{"{", 
         RowBox[{"107.68876001252616`", ",", "122.11775833675739`"}], "}"}]},
       {"125.`", "128.12025988986647`", "2.7765602868754833`", 
        RowBox[{"{", 
         RowBox[{"121.71750038668795`", ",", "134.52301939304502`"}], "}"}]},
       {"140.`", "143.89538977577982`", "2.517001452281369`", 
        RowBox[{"{", 
         RowBox[{"138.0911740185041`", ",", "149.69960553305555`"}], "}"}]},
       {"150.`", "149.7222395534595`", "2.476378934619718`", 
        RowBox[{"{", 
         RowBox[{"144.01169948989394`", ",", "155.43277961702506`"}], "}"}]},
       {"175.`", "162.2286488323818`", "2.500410128769664`", 
        RowBox[{"{", 
         RowBox[{"156.46269273573256`", ",", "167.99460492903103`"}], "}"}]},
       {"190.`", "175.87200440938793`", "2.6918523259851397`", 
        RowBox[{"{", 
         RowBox[{"169.66458181430724`", ",", "182.0794270044686`"}], "}"}]},
       {"210.`", "214.95453340602006`", "3.8834592497187383`", 
        RowBox[{"{", 
         RowBox[{"205.99926031727176`", ",", "223.90980649476836`"}], "}"}]},
       {"255.`", "261.1429767656762`", "5.820143370796521`", 
        RowBox[{"{", 
         RowBox[{"247.72170208513833`", ",", "274.56425144621414`"}], "}"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxDividers->{
       "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[0.7]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     {None, OutputFormsDump`HeadedColumns}],
    Function[BoxForm`e$, 
     MatrixForm[
     BoxForm`e$, TableDepth -> 2, 
      TableHeadings -> {None, {"Observed", "Predicted", "SE", "CI"}}]]]}], 
  "}"}]], "Output",
 ImageSize->{500, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->96448436]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PredictedResponse",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/PredictedResponse"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SinglePredictionCITable",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/SinglePredictionCITable"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Regression Common Functions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/tutorial/RegressionCommon"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MeanPredictionCITable - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 15.2384790}", "context" -> 
    "RegressionCommon`", "keywords" -> {}, "index" -> True, "label" -> 
    "Regression Common Package Symbol", "language" -> "en", "paclet" -> 
    "RegressionCommon Package", "status" -> "None", "summary" -> 
    "MeanPredictionCITable is a possible value for the RegressionReport \
option which represents a table of confidence intervals for the mean \
predicted responses.", "synonyms" -> {}, "title" -> "MeanPredictionCITable", 
    "type" -> "Symbol", "uri" -> 
    "RegressionCommon/ref/MeanPredictionCITable"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4134, 140, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->15594284]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11775, 371}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1472, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2095, 65, 64, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2162, 68, 618, 17, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2817, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3295, 107, 236, 5, 70, "Notes",
 CellID->82101380],
Cell[3534, 114, 279, 9, 70, "Notes",
 CellID->22704],
Cell[3816, 125, 281, 10, 70, "Notes",
 CellID->19912]
}, Closed]],
Cell[CellGroupData[{
Cell[4134, 140, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->15594284],
Cell[CellGroupData[{
Cell[4518, 154, 148, 5, 70, "ExampleSection",
 CellID->443937996],
Cell[4669, 161, 141, 4, 70, "Input",
 CellID->455158924],
Cell[4813, 167, 50, 1, 70, "ExampleText",
 CellID->3902],
Cell[4866, 170, 937, 26, 70, "Input",
 CellID->26500],
Cell[5806, 198, 135, 4, 70, "ExampleText",
 CellID->153],
Cell[CellGroupData[{
Cell[5966, 206, 313, 9, 70, "Input",
 CellID->26645265],
Cell[6282, 217, 2847, 68, 184, "Output",
 CellID->96448436]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9190, 292, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[9509, 303, 537, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[10083, 325, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[10404, 336, 186, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[10605, 343, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

