(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12587,        426]
NotebookOptionsPosition[      9829,        337]
NotebookOutlinePosition[     11179,        374]
CellTagsIndexPosition[     11094,        369]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["REGRESSION COMMON PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regression Common Functions Package" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/tutorial/RegressionCommon"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Regression Common Functions Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BestFitParameters" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/BestFitParameters"], "ParameterTable" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/ParameterTable"], 
          "ParameterConfidenceRegion" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/ParameterConfidenceRegion"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"BestFitParameters\"\>", 
       2->"\<\"ParameterTable\"\>", 
       3->"\<\"ParameterConfidenceRegion\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ParameterCITable", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ParameterCITable"], "InlineFormula"],
     "\[LineSeparator]is a possible value for the ",
     Cell[BoxData[
      ButtonBox["RegressionReport",
       BaseStyle->"Link",
       ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
      "InlineFormula"],
     " option which represents a table of confidence interval information for \
the fitted parameters."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["ParameterCITable"], "InlineFormula"],
 " includes parameter estimates, standard errors and confidence intervals."
}], "Notes",
 CellID->556382607],

Cell[TextData[{
 "The confidence level for intervals can be specified via the ",
 Cell[BoxData[
  ButtonBox["ConfidenceLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/ConfidenceLevel"]], 
  "InlineFormula"],
 " option."
}], "Notes",
 CellID->22704],

Cell[TextData[{
 "In the regression report, ",
 Cell[BoxData["ParameterCITable"], "InlineFormula"],
 " has the ",
 Cell[BoxData[
  ButtonBox["TableForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
 " wrapper."
}], "Notes",
 CellID->6422]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->617334654],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->214309347],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->455158924],

Cell["Sample data:", "ExampleText",
 CellID->3902],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.05", ",", " ", "90"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.09", ",", " ", "95"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.14", ",", " ", "110"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.17", ",", " ", "125"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", " ", "140"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.21", ",", " ", "150"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.23", ",", " ", "175"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "190"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.3", ",", " ", "210"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.35", ",", " ", "255"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26500],

Cell[TextData[{
 Cell[BoxData["ParameterCITable"], "InlineFormula"],
 " for a linear regression:"
}], "ExampleText",
 CellID->153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Regress", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"x", "^", "2"}]}], "}"}], ",", "x", ",", 
   RowBox[{"RegressionReport", "\[Rule]", 
    RowBox[{"{", "ParameterCITable", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->26645265],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ParameterCITable", "\[Rule]", 
   TagBox[
    TagBox[GridBox[{
       {
        StyleBox["\[Null]",
         ShowStringCharacters->False], 
        TagBox["\<\"Estimate\"\>",
         HoldForm], 
        TagBox["\<\"SE\"\>",
         HoldForm], 
        TagBox["\<\"CI\"\>",
         HoldForm]},
       {
        TagBox["1",
         HoldForm], "87.04807487158759`", "4.115580148029904`", 
        RowBox[{"{", 
         RowBox[{"77.55753003146644`", ",", "96.53861971170873`"}], "}"}]},
       {
        TagBox[
         SuperscriptBox["x", "2"],
         HoldForm], "1421.1828726048054`", "69.91953945393817`", 
        RowBox[{"{", 
         RowBox[{"1259.948125492453`", ",", "1582.4176197171578`"}], "}"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxDividers->{
       "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
        "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[0.7]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
    Function[BoxForm`e$, 
     MatrixForm[
     BoxForm`e$, TableDepth -> 2, 
      TableHeadings -> {{1, $CellContext`x^2}, {"Estimate", "SE", "CI"}}]]]}],
   "}"}]], "Output",
 ImageSize->{416, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->641657237]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BestFitParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/BestFitParameters"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParameterTable",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/ParameterTable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParameterConfidenceRegion",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/ParameterConfidenceRegion"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->76440264]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Regression Common Functions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/tutorial/RegressionCommon"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ParameterCITable - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 15.5666124}", "context" -> 
    "RegressionCommon`", "keywords" -> {}, "index" -> True, "label" -> 
    "Regression Common Package Symbol", "language" -> "en", "paclet" -> 
    "RegressionCommon Package", "status" -> "None", "summary" -> 
    "ParameterCITable is a possible value for the RegressionReport option \
which represents a table of confidence interval information for the fitted \
parameters.", "synonyms" -> {}, "title" -> "ParameterCITable", "type" -> 
    "Symbol", "uri" -> "RegressionCommon/ref/ParameterCITable"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4217, 142, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->617334654]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10951, 362}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1630, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2253, 68, 59, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2315, 71, 617, 17, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2969, 93, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3447, 110, 177, 4, 70, "Notes",
 CellID->556382607],
Cell[3627, 116, 275, 9, 70, "Notes",
 CellID->22704],
Cell[3905, 127, 275, 10, 70, "Notes",
 CellID->6422]
}, Closed]],
Cell[CellGroupData[{
Cell[4217, 142, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->617334654],
Cell[CellGroupData[{
Cell[4602, 156, 148, 5, 70, "ExampleSection",
 CellID->214309347],
Cell[4753, 163, 141, 4, 70, "Input",
 CellID->455158924],
Cell[4897, 169, 50, 1, 70, "ExampleText",
 CellID->3902],
Cell[4950, 172, 937, 26, 70, "Input",
 CellID->26500],
Cell[5890, 200, 130, 4, 70, "ExampleText",
 CellID->153],
Cell[CellGroupData[{
Cell[6045, 208, 308, 9, 70, "Input",
 CellID->26645265],
Cell[6356, 219, 1693, 49, 68, "Output",
 CellID->641657237]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8110, 275, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[8429, 286, 814, 26, 70, "SeeAlso",
 CellID->76440264]
}, Open  ]],
Cell[CellGroupData[{
Cell[9280, 317, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[9601, 328, 186, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[9802, 335, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

