(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14744,        506]
NotebookOptionsPosition[     11767,        410]
NotebookOutlinePosition[     13161,        448]
CellTagsIndexPosition[     13076,        443]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["REGRESSION COMMON PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regression Common Functions Package" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/tutorial/RegressionCommon"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Regression Common Functions Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BestFitParameters" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/BestFitParameters"], 
          "ParameterCITable" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/ParameterCITable"], "ParameterTable" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/ParameterTable"], "Ellipsoid" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/Ellipsoid"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BestFitParameters\"\>", 
       2->"\<\"ParameterCITable\"\>", 3->"\<\"ParameterTable\"\>", 
       4->"\<\"Ellipsoid\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ParameterConfidenceRegion", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ParameterConfidenceRegion"], "InlineFormula"],
     "\[LineSeparator]is a possible value for the ",
     Cell[BoxData[
      ButtonBox["RegressionReport",
       BaseStyle->"Link",
       ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
      "InlineFormula"],
     " option which represents the elliptically shaped joint confidence \
region for parameter estimates."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["ParameterConfidenceRegion"], "InlineFormula"],
 " gives a confidence region for all fitted parameters."
}], "Notes",
 CellID->331441330],

Cell[TextData[{
 Cell[BoxData["ParameterConfidenceRegion"], "InlineFormula"],
 " is based on ",
 Cell[BoxData[
  ButtonBox["CovarianceMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/CovarianceMatrix"]], 
  "InlineFormula"],
 " for linear regressions using ",
 Cell[BoxData[
  ButtonBox["Regress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["DesignedRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/DesignedRegress"]], 
  "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["AsymptoticCovarianceMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/AsymptoticCovarianceMatrix"]], 
  "InlineFormula"],
 " for nonlinear regressions using ",
 Cell[BoxData[
  ButtonBox["NonlinearRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->18762],

Cell[TextData[{
 "The confidence level for the region can be specified via the ",
 Cell[BoxData[
  ButtonBox["ConfidenceLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/ConfidenceLevel"]], 
  "InlineFormula"],
 " option."
}], "Notes",
 CellID->22704],

Cell[TextData[{
 Cell[BoxData["ParameterConfidenceRegion"], "InlineFormula"],
 " is represented using an ",
 Cell[BoxData[
  ButtonBox["Ellipsoid",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/Ellipsoid"]], "InlineFormula"],
 " object."
}], "Notes",
 CellID->1655],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ParameterConfidenceRegion", "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["basis", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["basis", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " \[LineSeparator]can be specified to obtain a confidence region for the \
basis functions ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["basis", "TI"], 
    StyleBox["1", "TR"]], ",", 
   SubscriptBox[
    StyleBox["basis", "TI"], 
    StyleBox["2", "TR"]], ",", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 " in a linear regression."
}], "Notes",
 CellID->321874987],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ParameterConfidenceRegion", "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["par", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["par", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " \[LineSeparator]can be specified to obtain a confidence region for the \
parameters ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["par", "TI"], 
    StyleBox["1", "TR"]], ",", 
   SubscriptBox[
    StyleBox["par", "TI"], 
    StyleBox["2", "TR"]], ",", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 " in a nonlinear regression."
}], "Notes",
 CellID->370035793]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->176242306],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->75930237],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->455158924],

Cell["Sample data:", "ExampleText",
 CellID->3902],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.05", ",", " ", "90"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.09", ",", " ", "95"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.14", ",", " ", "110"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.17", ",", " ", "125"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", " ", "140"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.21", ",", " ", "150"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.23", ",", " ", "175"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "190"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.3", ",", " ", "210"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.35", ",", " ", "255"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26500],

Cell[TextData[{
 Cell[BoxData["ParameterConfidenceRegion"], "InlineFormula"],
 " for a linear regression:"
}], "ExampleText",
 CellID->153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Regress", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"x", "^", "2"}]}], "}"}], ",", "x", ",", 
   RowBox[{"RegressionReport", "\[Rule]", 
    RowBox[{"{", "ParameterConfidenceRegion", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->50367729],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ParameterConfidenceRegion", "\[Rule]", 
   RowBox[{"Ellipsoid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"87.04807487158759`", ",", "1421.1828726048054`"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"209.0320249686437`", ",", "7.36026280332049`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.047116226052073`"}], ",", "0.9988894139205852`"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.9988894139205851`", ",", "0.04711622605207301`"}], "}"}]}],
       "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{495, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->565783361]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BestFitParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/BestFitParameters"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParameterCITable",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/ParameterCITable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParameterTable",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/ParameterTable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ellipsoid",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/Ellipsoid"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->76440264]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Regression Common Functions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/tutorial/RegressionCommon"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ParameterConfidenceRegion - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 15.7541172}", "context" -> 
    "RegressionCommon`", "keywords" -> {}, "index" -> True, "label" -> 
    "Regression Common Package Symbol", "language" -> "en", "paclet" -> 
    "RegressionCommon Package", "status" -> "None", "summary" -> 
    "ParameterConfidenceRegion is a possible value for the RegressionReport \
option which represents the elliptically shaped joint confidence region for \
parameter estimates.", "synonyms" -> {}, "title" -> 
    "ParameterConfidenceRegion", "type" -> "Symbol", "uri" -> 
    "RegressionCommon/ref/ParameterConfidenceRegion"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6819, 232, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->176242306]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12933, 436}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1732, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2355, 70, 68, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2426, 73, 629, 17, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3092, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3570, 112, 167, 4, 70, "Notes",
 CellID->331441330],
Cell[3740, 118, 997, 33, 70, "Notes",
 CellID->18762],
Cell[4740, 153, 276, 9, 70, "Notes",
 CellID->22704],
Cell[5019, 164, 285, 9, 70, "Notes",
 CellID->1655],
Cell[5307, 175, 741, 25, 70, "Notes",
 CellID->321874987],
Cell[6051, 202, 731, 25, 70, "Notes",
 CellID->370035793]
}, Closed]],
Cell[CellGroupData[{
Cell[6819, 232, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->176242306],
Cell[CellGroupData[{
Cell[7204, 246, 147, 5, 70, "ExampleSection",
 CellID->75930237],
Cell[7354, 253, 141, 4, 70, "Input",
 CellID->455158924],
Cell[7498, 259, 50, 1, 70, "ExampleText",
 CellID->3902],
Cell[7551, 262, 937, 26, 70, "Input",
 CellID->26500],
Cell[8491, 290, 139, 4, 70, "ExampleText",
 CellID->153],
Cell[CellGroupData[{
Cell[8655, 298, 317, 9, 70, "Input",
 CellID->50367729],
Cell[8975, 309, 766, 23, 54, "Output",
 CellID->565783361]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9802, 339, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[10121, 350, 1060, 35, 70, "SeeAlso",
 CellID->76440264]
}, Open  ]],
Cell[CellGroupData[{
Cell[11218, 390, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[11539, 401, 186, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[11740, 408, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

