(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13169,        443]
NotebookOptionsPosition[     10293,        351]
NotebookOutlinePosition[     11693,        389]
CellTagsIndexPosition[     11608,        384]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["REGRESSION COMMON PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regression Common Functions Package" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/tutorial/RegressionCommon"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Regression Common Functions Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PredictedResponseDelta" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/PredictedResponseDelta"], "CookD" :> 
          Documentation`HelpLookup["paclet:RegressionCommon/ref/CookD"], 
          "HatDiagonal" :> 
          Documentation`HelpLookup["paclet:RegressionCommon/ref/HatDiagonal"],
           "CovarianceMatrixDetRatio" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/CovarianceMatrixDetRatio"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PredictedResponseDelta\"\>", 
       2->"\<\"CookD\"\>", 3->"\<\"HatDiagonal\"\>", 
       4->"\<\"CovarianceMatrixDetRatio\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PredictedResponseDelta", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["PredictedResponseDelta"], "InlineFormula"],
     "\[LineSeparator]is a possible value for the ",
     Cell[BoxData[
      ButtonBox["RegressionReport",
       BaseStyle->"Link",
       ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
      "InlineFormula"],
     " option for ",
     Cell[BoxData[
      ButtonBox["Regress",
       BaseStyle->"Link",
       ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["DesignedRegress",
       BaseStyle->"Link",
       ButtonData->"paclet:LinearRegression/ref/DesignedRegress"]], 
      "InlineFormula"],
     " which represents the effect on predicted values if data points are \
omitted."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["PredictedResponseDelta"], "InlineFormula"],
 " gives a list of values which measure the effect of removing a data point \
on the fitted response values. "
}], "Notes",
 CellID->158486308],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["th", "TI"]]], "InlineFormula"],
 " element in the list measures the effect of removing the ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["th", "TI"]]], "InlineFormula"],
 " element of the data set."
}], "Notes",
 CellID->184898209],

Cell[TextData[{
 Cell[BoxData["PredictedResponseDelta"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["StudentizedResiduals",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/StudentizedResiduals"], " ", 
   RowBox[{
    ButtonBox["Sqrt",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Sqrt"], "[", 
    RowBox[{
     ButtonBox["HatDiagonal",
      BaseStyle->"Link",
      ButtonData->"paclet:RegressionCommon/ref/HatDiagonal"], "/", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       ButtonBox["HatDiagonal",
        BaseStyle->"Link",
        ButtonData->"paclet:RegressionCommon/ref/HatDiagonal"]}], ")"}]}], 
    "]"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->325691826],

Cell[TextData[{
 Cell[BoxData["PredictedResponseDelta"], "InlineFormula"],
 " is also referred to as DFFITS."
}], "Notes",
 CellID->2290329]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->512267621],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->217841046],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->455158924],

Cell["Sample data:", "ExampleText",
 CellID->3902],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.05", ",", " ", "90"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.09", ",", " ", "95"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.14", ",", " ", "110"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.17", ",", " ", "125"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", " ", "140"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.21", ",", " ", "150"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.23", ",", " ", "175"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "190"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.3", ",", " ", "210"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.35", ",", " ", "255"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26500],

Cell[TextData[{
 Cell[BoxData["PredictedResponseDelta"], "InlineFormula"],
 " for a linear regression:"
}], "ExampleText",
 CellID->153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Regress", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"x", "^", "2"}]}], "}"}], ",", "x", ",", 
   RowBox[{"RegressionReport", "\[Rule]", 
    RowBox[{"{", "PredictedResponseDelta", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->26645265],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PredictedResponseDelta", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.04964164244066282`"}], ",", 
     RowBox[{"-", "0.2630612998016549`"}], ",", 
     RowBox[{"-", "0.2894885602877314`"}], ",", 
     RowBox[{"-", "0.15418571669313308`"}], ",", 
     RowBox[{"-", "0.1711427173341567`"}], ",", "0.011753099458224595`", ",", 
     "0.6906599952089097`", ",", "0.906939460148846`", ",", 
     RowBox[{"-", "0.40683186024600093`"}], ",", 
     RowBox[{"-", "1.3630572772848435`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{522, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2656500]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PredictedResponseDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/PredictedResponseDelta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CookD",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/CookD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HatDiagonal",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/HatDiagonal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CovarianceMatrixDetRatio",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/CovarianceMatrixDetRatio"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Regression Common Functions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/tutorial/RegressionCommon"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PredictedResponseDelta - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 22.6761694}", "context" -> 
    "RegressionCommon`", "keywords" -> {}, "index" -> True, "label" -> 
    "Regression Common Package Symbol", "language" -> "en", "paclet" -> 
    "RegressionCommon Package", "status" -> "None", "summary" -> 
    "PredictedResponseDelta is a possible value for the RegressionReport \
option for Regress and DesignedRegress which represents the effect on \
predicted values if data points are omitted.", "synonyms" -> {}, "title" -> 
    "PredictedResponseDelta", "type" -> "Symbol", "uri" -> 
    "RegressionCommon/ref/PredictedResponseDelta"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5408, 179, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->512267621]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11465, 377}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1737, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2360, 69, 65, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2428, 72, 963, 28, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3428, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3906, 122, 218, 5, 70, "Notes",
 CellID->158486308],
Cell[4127, 129, 354, 13, 70, "Notes",
 CellID->184898209],
Cell[4484, 144, 744, 24, 70, "Notes",
 CellID->325691826],
Cell[5231, 170, 140, 4, 70, "Notes",
 CellID->2290329]
}, Closed]],
Cell[CellGroupData[{
Cell[5408, 179, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->512267621],
Cell[CellGroupData[{
Cell[5793, 193, 148, 5, 70, "ExampleSection",
 CellID->217841046],
Cell[5944, 200, 141, 4, 70, "Input",
 CellID->455158924],
Cell[6088, 206, 50, 1, 70, "ExampleText",
 CellID->3902],
Cell[6141, 209, 937, 26, 70, "Input",
 CellID->26500],
Cell[7081, 237, 136, 4, 70, "ExampleText",
 CellID->153],
Cell[CellGroupData[{
Cell[7242, 245, 314, 9, 70, "Input",
 CellID->26645265],
Cell[7559, 256, 695, 17, 54, "Output",
 CellID->2656500]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8315, 280, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[8634, 291, 1073, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[9744, 331, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[10065, 342, 186, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[10266, 349, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

